/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.client.resourcepack;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.handler.codec.DecoderException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.mistersecret312.aperture_innovations.ApertureInnovations;
import net.mistersecret312.aperture_innovations.client.resourcepack.ClientPortalGunVariant;
import net.mistersecret312.aperture_innovations.client.resourcepack.ClientPortalGunVariants;
import net.mistersecret312.aperture_innovations.datapack.PortalGunVariant;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;

public class ResourcePackReloadListener {
    public static final String PATH = "aperture_innovations";
    public static final String GUN_VARIANT = "portal_gun_variant";
    private static Minecraft minecraft = Minecraft.getInstance();

    @EventBusSubscriber(modid="aperture_innovations", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        public ReloadListener() {
            super(new GsonBuilder().create(), ResourcePackReloadListener.PATH);
        }

        protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager manager, ProfilerFiller filler) {
            ClientPortalGunVariants.clear();
            ClientPacketListener clientPacketListener = minecraft.getConnection();
            if (clientPacketListener != null) {
                RegistryAccess.Frozen registries = clientPacketListener.registryAccess();
                Registry variantRegistry = registries.registryOrThrow(PortalGunVariant.REGISTRY_KEY);
                for (Map.Entry stargateVariantEntry : variantRegistry.entrySet()) {
                    ((PortalGunVariant)stargateVariantEntry.getValue()).resetMissing();
                }
            }
            for (Map.Entry<ResourceLocation, JsonElement> jsonEntry : jsonMap.entrySet()) {
                ResourceLocation location = jsonEntry.getKey();
                JsonElement element = jsonEntry.getValue();
                if (!ReloadListener.canShortenPath(location, ResourcePackReloadListener.GUN_VARIANT)) continue;
                location = ReloadListener.shortenPath(location, ResourcePackReloadListener.GUN_VARIANT);
                ReloadListener.addPortalGunVariant(location, element);
            }
        }

        private static void addPortalGunVariant(ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcePackReloadListener.GUN_VARIANT);
                ClientPortalGunVariant stargateVariant = (ClientPortalGunVariant)ClientPortalGunVariant.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(msg -> new DecoderException("Failed to parse Portal Gun Variant " + msg));
                ClientPortalGunVariants.addPortalGunVariant(location, stargateVariant);
            }
            catch (RuntimeException e) {
                ApertureInnovations.LOGGER.error("Could not load Portal Gun Variant: " + location.toString());
                ApertureInnovations.LOGGER.error(e.getMessage());
            }
        }

        @SubscribeEvent
        public static void registerReloadListener(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new ReloadListener());
        }

        private static boolean canShortenPath(ResourceLocation location, String shortenBy) {
            return location.getPath().startsWith(shortenBy) && location.getPath().length() > shortenBy.length();
        }

        private static ResourceLocation shortenPath(ResourceLocation location, String shortenBy) {
            return location.withPath(location.getPath().substring(shortenBy.length() + 1));
        }
    }
}

