/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.mistersecret312.aperture_innovations.ApertureInnovations;
import net.mistersecret312.aperture_innovations.client.renderer.PortalRenderer;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.network.ServerboundOpenPortalPacket;
import net.mistersecret312.aperture_innovations.network.ServerboundResetPortalLinkPacket;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.ClientPortalUtilities;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;
import net.mistersecret312.aperture_innovations.sounds.PortalSoundWrapper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="aperture_innovations", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void renderPortals(RenderLevelStageEvent event) {
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Camera camera = event.getCamera();
        PoseStack poseStack = event.getPoseStack();
        Matrix4f matrix4f = event.getModelViewMatrix();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            ClientLevel level = Minecraft.getInstance().level;
            PortalRenderer.LINKS.forEach((arg_0, arg_1) -> ClientEvents.lambda$renderPortals$0(poseStack, (Level)level, buffer, event, camera, arg_0, arg_1));
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            for (Map.Entry<UUID, ClientPortalLink> linkEntry : PortalRenderer.LINKS.entrySet()) {
                ClientPortalLink link = linkEntry.getValue();
                poseStack.pushPose();
                ResourceLocation texturePrimary = ClientPortalUtilities.getPortalVortexTexture(link, true);
                ResourceLocation textureSecondary = ClientPortalUtilities.getPortalVortexTexture(link, false);
                TextureAtlasSprite primary = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(texturePrimary);
                TextureAtlasSprite secondary = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(textureSecondary);
                for (int i = 0; i < 2; ++i) {
                    BlockPos otherPortalPos;
                    ResourceKey<Level> dimension;
                    ResourceKey<Level> resourceKey = dimension = i == 0 ? link.dimensionPrimary() : link.dimensionSecondary();
                    if (Minecraft.getInstance().level.dimension() != dimension) continue;
                    float scale = ClientPortalUtilities.getPortalOpeningAnimationProgress(link.linkID(), i == 0);
                    BlockPos portalPos = i == 0 ? link.posPrimary() : link.posSecondary();
                    BlockPos blockPos = otherPortalPos = i == 0 ? link.posSecondary() : link.posPrimary();
                    if (portalPos != null && Minecraft.getInstance().level.isLoaded(portalPos) && event.getLevelRenderer().getFrustum().isVisible(new AABB(portalPos).inflate(1.0))) {
                        if (i == 0) {
                            PortalRenderer.primaryRender(link, buffer, poseStack, camera, scale);
                        } else {
                            PortalRenderer.secondaryRender(link, buffer, poseStack, camera, scale);
                        }
                    }
                    if (i == 0 && link.posPrimary() != null) {
                        PortalRenderer.renderPortalVortex(link, camera, primary, (MultiBufferSource)buffer, poseStack, true);
                        continue;
                    }
                    if (link.posSecondary() == null) continue;
                    PortalRenderer.renderPortalVortex(link, camera, secondary, (MultiBufferSource)buffer, poseStack, false);
                }
                poseStack.popPose();
                buffer.endBatch();
            }
        }
    }

    @SubscribeEvent
    public static void renderBlockOverlay(RenderBlockScreenEffectEvent event) {
        Player player = event.getPlayer();
        Level level = player.level();
        BlockPos pos = event.getBlockPos();
        if (event.getOverlayType().equals((Object)RenderBlockScreenEffectEvent.OverlayType.BLOCK)) {
            boolean isOnCeiling;
            boolean isOnWall;
            Direction portalDirection;
            Pair<UUID, Boolean> portal = PortalUtilities.getClosestPortal((Entity)player);
            UUID uuid = (UUID)portal.getFirst();
            boolean isPrimary = (Boolean)portal.getSecond();
            if (uuid == null) {
                return;
            }
            Vec3 portalPos = PortalUtilities.getPortalPos(level, uuid, isPrimary);
            AABB portalBox = PortalUtilities.getPortalBoundingBox(portalPos, portalDirection = PortalUtilities.getPortalDirection(level, uuid, isPrimary), isOnWall = PortalUtilities.isPortalOnWall(level, uuid, isPrimary), isOnCeiling = PortalUtilities.isPortalOnCeiling(level, uuid, isPrimary));
            if (portalBox.contains(player.getEyePosition())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void mouseClicks(InputEvent.MouseButton.Pre event) {
        boolean hasPortalGun;
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (level == null || player == null || Minecraft.getInstance().screen != null) {
            return;
        }
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        boolean bl = hasPortalGun = main.is((Item)ItemInit.PORTAL_GUN.get()) || off.is((Item)ItemInit.PORTAL_GUN.get());
        if (!hasPortalGun) {
            return;
        }
        ItemStack gunItemStack = main.is((Item)ItemInit.PORTAL_GUN.get()) ? main : off;
        PortalGunItem gunItem = (PortalGunItem)gunItemStack.getItem();
        int dualityState = gunItem.getDualityState(gunItemStack);
        if (!(player.isShiftKeyDown() || event.getButton() != 0 || event.getAction() != 1 || dualityState != 2 && dualityState != 0)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundOpenPortalPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
        } else if (!(player.isShiftKeyDown() || event.getButton() != 1 || event.getAction() != 1 || dualityState != 2 && dualityState != 1)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundOpenPortalPacket(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null) {
            PortalRenderer.LINKS.forEach((linkID, link) -> {
                for (int i = 0; i < 2; ++i) {
                    PortalSoundWrapper.PortalAmbient ambient;
                    float progress;
                    BlockPos portalPos;
                    boolean isPrimary = i == 0;
                    BlockPos blockPos = portalPos = isPrimary ? link.posPrimary() : link.posSecondary();
                    if (portalPos != null && (progress = ClientPortalUtilities.getPortalOpeningAnimationProgress(linkID, isPrimary)) < 1.0f) {
                        ClientPortalUtilities.setPortalOpeningAnimationProgress(progress += 0.25f, linkID, isPrimary);
                    }
                    if (link.isOpen() || (ambient = ClientPortalUtilities.getAmbientSound(linkID, isPrimary)) == null) continue;
                    ambient.stopSound();
                }
            });
        }
        while (((KeyMapping)ApertureInnovations.ClientModEvents.RESET_PORTAL_GUN.get()).consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundResetPortalLinkPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static /* synthetic */ void lambda$renderPortals$0(PoseStack poseStack, Level level, MultiBufferSource.BufferSource buffer, RenderLevelStageEvent event, Camera camera, UUID linkID, ClientPortalLink link) {
        poseStack.pushPose();
        for (int i = 0; i < 2; ++i) {
            boolean otherMoonshot;
            ResourceKey<Level> dimension;
            ResourceKey<Level> resourceKey = dimension = i == 0 ? link.dimensionPrimary() : link.dimensionSecondary();
            if (level.dimension() != dimension) continue;
            poseStack.pushPose();
            float scale = ClientPortalUtilities.getPortalOpeningAnimationProgress(linkID, i == 0);
            BlockPos portalPos = i == 0 ? link.posPrimary() : link.posSecondary();
            BlockPos otherPortalPos = i == 0 ? link.posSecondary() : link.posPrimary();
            boolean moonshot = i == 0 ? link.moonshotPrimary() : link.moonshotSecondary();
            boolean bl = otherMoonshot = i == 0 ? link.moonshotSecondary() : link.moonshotPrimary();
            if ((portalPos != null || moonshot) && (otherPortalPos != null || otherMoonshot) && level.isLoaded(portalPos)) {
                PortalRenderer.renderPortalNonSee((MultiBufferSource)buffer, event.getProjectionMatrix(), poseStack, camera, link, i == 0, scale);
            }
            poseStack.popPose();
            buffer.endBatch();
        }
        poseStack.popPose();
    }
}

