/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.events;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.mistersecret312.aperture_innovations.capabilities.ApertureCapability;
import net.mistersecret312.aperture_innovations.capabilities.ApertureEnergy;
import net.mistersecret312.aperture_innovations.config.LongFallBootsConfig;
import net.mistersecret312.aperture_innovations.init.AdvancementInit;
import net.mistersecret312.aperture_innovations.init.AttachmentTypeInit;
import net.mistersecret312.aperture_innovations.init.SoundInit;
import net.mistersecret312.aperture_innovations.init.StatisticsInit;
import net.mistersecret312.aperture_innovations.items.LongFallBootsItem;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.network.ClientBoundPortalSyncPacket;
import net.mistersecret312.aperture_innovations.network.ClientboundPortalAmbientSoundPacket;
import net.mistersecret312.aperture_innovations.network.ClientboundPortalSoundsPacket;
import net.mistersecret312.aperture_innovations.network.ClientboundTeleportMomentumPacket;
import net.mistersecret312.aperture_innovations.portal.PortalLink;
import net.mistersecret312.aperture_innovations.portal.PortalLinkData;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingUseTotemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@EventBusSubscriber(modid="aperture_innovations", bus=EventBusSubscriber.Bus.GAME)
public class CommonEvents {
    @SubscribeEvent
    public static void levelTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            UUID uuid;
            ServerLevel serverLevel = (ServerLevel)level;
            PortalLinkData data = PortalLinkData.get(level);
            for (Map.Entry<UUID, PortalLink> entry : PortalUtilities.getPortalLinks((Level)serverLevel).entrySet()) {
                PortalLink link = entry.getValue();
                uuid = entry.getKey();
                for (int i = 0; i < 2; ++i) {
                    AABB centerBox;
                    BlockPos portalBlockPos;
                    boolean isPrimary = i == 0;
                    Vec3 portalPos = PortalUtilities.getPortalPos((Level)serverLevel, uuid, isPrimary);
                    BlockPos blockPos = portalBlockPos = isPrimary ? link.posPrimary : link.posSecondary;
                    if (portalPos == null) continue;
                    ResourceKey<Level> dimension = PortalUtilities.getPortalDimension((Level)serverLevel, uuid, isPrimary);
                    if (!serverLevel.dimension().equals(dimension)) continue;
                    Direction portalDirection = PortalUtilities.getPortalDirection((Level)serverLevel, uuid, isPrimary);
                    boolean isOnWall = PortalUtilities.isPortalOnWall((Level)serverLevel, uuid, isPrimary);
                    boolean isOnCeiling = PortalUtilities.isPortalOnCeiling((Level)serverLevel, uuid, isPrimary);
                    boolean otherMoonshot = isPrimary ? link.moonshotSecondary : link.moonshotPrimary;
                    AABB teleportBox = PortalUtilities.getPortalTeleportBox(portalPos, portalDirection, isOnWall, isOnCeiling);
                    Vec3 boxCenter = teleportBox.getCenter();
                    if (isOnWall) {
                        boxCenter = boxCenter.relative(portalDirection.getOpposite(), 0.5);
                    }
                    if (level.getBlockStates(centerBox = new AABB(boxCenter, boxCenter).inflate(0.25)).anyMatch(state -> {
                        Direction checkDirection = isOnWall ? portalDirection : (isOnCeiling ? Direction.DOWN : Direction.UP);
                        BlockPos statePos = portalBlockPos.relative(checkDirection.getOpposite());
                        boolean isSturdy = state.isFaceSturdy((BlockGetter)level, statePos, checkDirection);
                        return state.is(Blocks.AIR) || !isSturdy;
                    })) {
                        if (isPrimary) {
                            link.resetPrimary(level);
                            continue;
                        }
                        link.resetSecondary(level);
                        continue;
                    }
                    if (!link.isOpen() || portalPos == null) continue;
                    if (otherMoonshot) {
                        List entities = level.getEntitiesOfClass(Entity.class, new AABB(BlockPos.containing((Position)portalPos)).inflate(5.0));
                        for (Entity entity : entities) {
                            Vec3 pushVector = portalPos.subtract(entity.position()).multiply(0.08, 0.08, 0.08);
                            entity.push(pushVector.x, pushVector.y, pushVector.z);
                            if (!(entity instanceof ServerPlayer)) continue;
                            ServerPlayer player = (ServerPlayer)entity;
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundTeleportMomentumPacket(entity.getDeltaMovement().toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    }
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(BlockPos.containing((Position)portalPos)), (CustomPacketPayload)new ClientboundPortalAmbientSoundPacket(link.linkID, isPrimary, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            for (Entity entity : serverLevel.getAllEntities()) {
                boolean otherMoonshot;
                Pair<UUID, Boolean> pair = PortalUtilities.getClosestPortal(entity);
                uuid = (UUID)pair.getFirst();
                boolean isPrimary = (Boolean)pair.getSecond();
                if (uuid == null) {
                    return;
                }
                Vec3 portalPos = PortalUtilities.getPortalPos((Level)serverLevel, uuid, isPrimary);
                if (portalPos == null) continue;
                ResourceKey<Level> dimension = PortalUtilities.getPortalDimension((Level)serverLevel, uuid, isPrimary);
                if (!serverLevel.dimension().equals(dimension)) continue;
                Direction portalDirection = PortalUtilities.getPortalDirection((Level)serverLevel, uuid, isPrimary);
                boolean isOnWall = PortalUtilities.isPortalOnWall((Level)serverLevel, uuid, isPrimary);
                boolean isOnCeiling = PortalUtilities.isPortalOnCeiling((Level)serverLevel, uuid, isPrimary);
                AABB teleportBox = PortalUtilities.getPortalTeleportBox(portalPos, portalDirection, isOnWall, isOnCeiling);
                Vec3 entityCenter = entity.getBoundingBox().getCenter();
                AABB entityCenterBox = new AABB(entityCenter, entityCenter).inflate(0.25, 0.5, 0.25);
                if (!entityCenterBox.expandTowards(entity.getDeltaMovement().multiply(1.0, 1.0, 1.0)).intersects(teleportBox)) continue;
                Vec3 otherPortalPos = PortalUtilities.getPortalPos((Level)serverLevel, uuid, !isPrimary);
                PortalLink link = PortalUtilities.getPortalLinks((Level)serverLevel).get(uuid);
                boolean bl = otherMoonshot = isPrimary ? link.moonshotSecondary : link.moonshotPrimary;
                if (otherPortalPos == null && otherMoonshot) {
                    otherPortalPos = portalPos.add(0.0, 1000.0, 0.0);
                }
                if (otherPortalPos == null) continue;
                Direction otherDirection = PortalUtilities.getPortalDirection((Level)serverLevel, uuid, otherMoonshot == isPrimary);
                boolean otherWall = PortalUtilities.isPortalOnWall((Level)serverLevel, uuid, otherMoonshot == isPrimary);
                boolean otherCeiling = PortalUtilities.isPortalOnCeiling((Level)serverLevel, uuid, otherMoonshot == isPrimary);
                ResourceKey<Level> otherDimension = PortalUtilities.getPortalDimension((Level)serverLevel, uuid, otherMoonshot == isPrimary);
                float rotation = otherDirection.toYRot() - portalDirection.toYRot() + 180.0f;
                AABB otherTeleportBox = PortalUtilities.getPortalTeleportBox(otherPortalPos, otherDirection, otherWall, otherCeiling);
                otherPortalPos = otherTeleportBox.getCenter();
                otherPortalPos = otherWall ? otherPortalPos.add(0.0, -entity.getBoundingBox().getYsize() * 0.45, 0.0).add(Vec3.atLowerCornerOf((Vec3i)otherDirection.getNormal()).multiply((double)0.35f, 1.0, (double)0.35f)) : otherPortalPos.add(0.0, 0.1, 0.0);
                if (!isOnWall && otherWall) {
                    otherPortalPos = otherPortalPos.add(Vec3.atLowerCornerOf((Vec3i)otherDirection.getNormal()));
                }
                if (!otherWall && !isOnWall && !isOnCeiling && otherCeiling) {
                    otherPortalPos = otherPortalPos.add(0.0, -2.0, 0.0);
                }
                if (!(otherWall || isOnWall || isOnCeiling || otherCeiling)) {
                    otherPortalPos = otherPortalPos.add(0.0, 1.0, 0.0);
                }
                if (!otherWall && !isOnWall && isOnCeiling && !otherCeiling) {
                    otherPortalPos = otherPortalPos.add(0.0, 1.0, 0.0);
                }
                if (isOnWall && otherCeiling) {
                    otherPortalPos = otherPortalPos.add(0.0, -2.0, 0.0);
                }
                if (isOnWall && !otherWall && !otherCeiling) {
                    otherPortalPos = otherPortalPos.add(0.0, 1.0, 0.0);
                }
                Vector3f oldSpeed = entity.getDeltaMovement().toVector3f();
                ServerLevel otherPortalLevel = serverLevel.getServer().getLevel(otherDimension);
                entity.teleportTo(otherPortalLevel, otherPortalPos.x, otherPortalPos.y, otherPortalPos.z, Set.of(), entity.getYRot() + (!isOnWall && otherWall ? rotation + 180.0f : rotation), entity.getXRot());
                Vec3 otherPos = otherPortalPos;
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(BlockPos.containing((Position)portalPos)), (CustomPacketPayload)new ClientboundPortalSoundsPacket.EnterPortal(link.linkID, isPrimary), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)otherPortalLevel, (ChunkPos)new ChunkPos(BlockPos.containing((Position)otherPos)), (CustomPacketPayload)new ClientboundPortalSoundsPacket.EnterPortal(link.linkID, isPrimary), (CustomPacketPayload[])new CustomPacketPayload[0]);
                Quaternionf rotationQ = new Quaternionf((Quaternionfc)Axis.YP.rotationDegrees(rotation - 180.0f));
                if (isOnWall && otherWall) {
                    if (rotation == 0.0f) {
                        rotationQ = new Quaternionf();
                    }
                    if (rotation == 180.0f) {
                        rotationQ = new Quaternionf((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                    }
                }
                Vector3f newSpeed = oldSpeed.rotate((Quaternionfc)rotationQ);
                if (!isOnWall && !otherWall) {
                    if (!isOnCeiling && !otherCeiling) {
                        newSpeed = new Vector3f(newSpeed.x, -newSpeed.y + (link.isInterdimensionalLink() ? 0.25f : 0.0f), newSpeed.z);
                    }
                    if (isOnCeiling && !otherCeiling) {
                        newSpeed = new Vector3f(newSpeed.x, -newSpeed.y, newSpeed.z);
                    }
                }
                if (!isOnWall && otherWall) {
                    if (otherDirection.getAxis() == Direction.Axis.X) {
                        newSpeed = new Vector3f(newSpeed.x - (otherDirection.getAxisDirection().equals((Object)Direction.AxisDirection.NEGATIVE) ? -newSpeed.y : newSpeed.y), 0.0f, 0.0f);
                    }
                    if (otherDirection.getAxis() == Direction.Axis.Z) {
                        newSpeed = new Vector3f(0.0f, 0.0f, newSpeed.z + (otherDirection.getAxisDirection().equals((Object)Direction.AxisDirection.NEGATIVE) ? newSpeed.y : -newSpeed.y));
                    }
                }
                if (isOnWall && !otherWall && !otherCeiling) {
                    newSpeed = new Vector3f(0.0f, (float)(0.25 + entity.getDeltaMovement().length()), 0.0f);
                }
                entity.setDeltaMovement(new Vec3(newSpeed));
                entity.resetFallDistance();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.awardStat((ResourceLocation)StatisticsInit.TIMES_USED_PORTALS.get(), 1);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundTeleportMomentumPacket(newSpeed), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                Vec3 mathOtherPos = otherPortalPos;
                ApertureCapability aperture = (ApertureCapability)entity.getData(AttachmentTypeInit.APERTURE);
                aperture.portal = new Pair((Object)uuid, (Object)(!isPrimary ? 1 : 0));
                aperture.updateDistance();
                aperture.setFrictionlessTime(400);
                entity.setData(AttachmentTypeInit.APERTURE, (Object)aperture);
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)entity;
                AdvancementInit.PORTAL_TRAVEL.get().trigger(player, dimension.location(), otherDimension.location(), portalPos.distanceToSqr(mathOtherPos), aperture.verticalDistance, aperture.horizontalDistance, otherMoonshot);
            }
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PortalLinkData data = PortalLinkData.get(serverPlayer.level());
            data.portalLinks.forEach((uuid, link) -> {
                for (int i = 0; i < 2; ++i) {
                    boolean isPrimary;
                    boolean bl = isPrimary = i == 0;
                    if (isPrimary) {
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientBoundPortalSyncPacket((UUID)uuid, true, link.posPrimary, link.directionPrimary, link.wallPrimary, link.ceilingPrimary, link.dimensionPrimary, link.moonshotPrimary, link.variantKey, link.primaryPortalColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        continue;
                    }
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientBoundPortalSyncPacket((UUID)uuid, false, link.posSecondary, link.directionSecondary, link.wallSecondary, link.ceilingSecondary, link.dimensionSecondary, link.moonshotSecondary, link.variantKey, link.secondaryPortalColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerFall(EntityInvulnerabilityCheckEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (ItemStack stack : living.getArmorSlots()) {
                IEnergyStorage cap;
                if (!event.getSource().equals(entity.damageSources().fall()) && !event.getSource().equals(entity.damageSources().flyIntoWall()) || !(stack.getItem() instanceof LongFallBootsItem)) continue;
                if (!living.level().isClientSide() && (cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null && cap instanceof ApertureEnergy) {
                    long toExtract;
                    long extracted;
                    ApertureEnergy energy = (ApertureEnergy)cap;
                    if (((Boolean)LongFallBootsConfig.long_fall_boots_use_energy.get()).booleanValue() && (extracted = energy.extractLongEnergy(toExtract = ((Long)LongFallBootsConfig.fall_energy_consumption.get()).longValue(), false)) < toExtract) {
                        return;
                    }
                }
                ServerLevel level = (ServerLevel)living.level();
                level.playSound(null, living.blockPosition(), (SoundEvent)SoundInit.LONG_FALL_BOOTS_LAND.get(), SoundSource.PLAYERS, 0.15f, 1.0f);
                event.setInvulnerable(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void playerDied(LivingDeathEvent event) {
        LivingEntity living = event.getEntity();
        Level level = living.level();
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            Pair<UUID, Boolean> closestPortal = PortalUtilities.getClosestPortal((Entity)player);
            UUID linkID = (UUID)closestPortal.getFirst();
            if (linkID == null) {
                return;
            }
            boolean isPrimary = (Boolean)closestPortal.getSecond();
            Vec3 portalPos = PortalUtilities.getPortalPos(level, linkID, isPrimary);
            if (portalPos == null) {
                return;
            }
            boolean onWall = PortalUtilities.isPortalOnWall(level, linkID, isPrimary);
            boolean onCeiling = PortalUtilities.isPortalOnCeiling(level, linkID, isPrimary);
            double distance = portalPos.distanceTo(player.position());
            if (distance > 16.0) {
                return;
            }
            AdvancementInit.NEAR_PORTAL_DEATH.get().trigger(player, distance, !onWall && !onCeiling);
        }
    }

    @SubscribeEvent
    public static void totemDeath(LivingUseTotemEvent event) {
        LivingEntity living = event.getEntity();
        Level level = living.level();
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            Pair<UUID, Boolean> closestPortal = PortalUtilities.getClosestPortal((Entity)player);
            UUID linkID = (UUID)closestPortal.getFirst();
            if (linkID == null) {
                return;
            }
            boolean isPrimary = (Boolean)closestPortal.getSecond();
            Vec3 portalPos = PortalUtilities.getPortalPos(level, linkID, isPrimary);
            if (portalPos == null) {
                return;
            }
            boolean onWall = PortalUtilities.isPortalOnWall(level, linkID, isPrimary);
            boolean onCeiling = PortalUtilities.isPortalOnCeiling(level, linkID, isPrimary);
            long distance = (long)portalPos.distanceTo(player.position());
            if (distance > 16L) {
                return;
            }
            AdvancementInit.NEAR_PORTAL_DEATH.get().trigger(player, distance, !onWall && !onCeiling);
        }
    }

    @SubscribeEvent
    public static void livingTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ApertureCapability aperture = (ApertureCapability)living.getData(AttachmentTypeInit.APERTURE);
            aperture.tick(level, living);
        }
    }

    @SubscribeEvent
    public static void itemToss(ItemTossEvent event) {
        if (event.getEntity().getItem().getItem() instanceof PortalGunItem) {
            event.getEntity().setThrower((Entity)event.getPlayer());
        }
    }
}

