/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.init;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.mistersecret312.aperture_innovations.blocks.VerticalOneByTwoBlock;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockInit {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"aperture_innovations");
    public static final DeferredBlock<Block> METAL_SURFACE_BLOCK = BlockInit.registerBlock("metal_surface_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).mapColor(MapColor.COLOR_GRAY)));
    public static final DeferredBlock<Block> METAL_SURFACE_TILE_BLOCK = BlockInit.registerBlock("metal_surface_tile_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).mapColor(MapColor.COLOR_GRAY)));
    public static final DeferredBlock<Block> METAL_SURFACE_1x2_BLOCK = BlockInit.registerBlock("metal_surface_1x2_block", () -> new VerticalOneByTwoBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).mapColor(MapColor.COLOR_GRAY)));
    public static final DeferredBlock<Block> CONCRETE_SURFACE_BLOCK = BlockInit.registerBlock("concrete_surface_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CONCRETE).mapColor(MapColor.TERRACOTTA_WHITE)));
    public static final DeferredBlock<Block> CONCRETE_SURFACE_TILE_BLOCK = BlockInit.registerBlock("concrete_surface_tile_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CONCRETE).mapColor(MapColor.TERRACOTTA_WHITE)));
    public static final DeferredBlock<Block> CONCRETE_SURFACE_1x2_BLOCK = BlockInit.registerBlock("concrete_surface_1x2_block", () -> new VerticalOneByTwoBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CONCRETE).mapColor(MapColor.TERRACOTTA_WHITE)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredHolder<Item, BlockItem> registerBlockItem(String name, DeferredBlock<T> block) {
        return ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus bus) {
        BLOCKS.register(bus);
    }
}

