/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;

public class ColorfulGelItem
extends Item {
    public ColorfulGelItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        components.add((Component)Component.translatable((String)"item.aperture_innovations.colorful_gel.tooltip").withStyle(ChatFormatting.DARK_PURPLE));
        int gelColor = this.getColor(stack);
        if (gelColor != -1) {
            components.add((Component)Component.translatable((String)"item.aperture_innovations.colorful_gel.color", (Object[])new Object[]{Integer.toHexString(gelColor).toUpperCase()}).withStyle(style -> style.withColor(gelColor)));
        }
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.getColor(stack) != -1 ? 16 : 64;
    }

    public void setColor(ItemStack stack, int color) {
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, false));
    }

    public int getColor(ItemStack stack) {
        DyedItemColor color = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        if (color == null) {
            return -1;
        }
        if (color.showInTooltip()) {
            stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color.rgb(), false));
        }
        return color.rgb();
    }
}

