/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.items;

import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.mistersecret312.aperture_innovations.capabilities.ApertureEnergy;
import net.mistersecret312.aperture_innovations.config.LongFallBootsConfig;
import net.mistersecret312.aperture_innovations.init.DataComponentInit;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class LongFallBootsItem
extends ArmorItem {
    public static final String ENERGY = "Energy";
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"textures/models/armor/long_fall_boots.png");

    public LongFallBootsItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public boolean isBarVisible(ItemStack stack) {
        return (Boolean)LongFallBootsConfig.long_fall_boots_use_energy.get() != false && LongFallBootsItem.getEnergy(stack) != this.getCapacity();
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)LongFallBootsItem.getEnergy(stack) / (float)this.getCapacity());
    }

    public int getBarColor(ItemStack stack) {
        return new Color(0, 200, 255).getRGB();
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        if (((Boolean)LongFallBootsConfig.long_fall_boots_use_energy.get()).booleanValue()) {
            components.add((Component)Component.translatable((String)"item.aperture_innovations.long_fall_boots.energy").append(ApertureEnergy.energyToString(LongFallBootsItem.getEnergy(stack), this.getCapacity())).withStyle(ChatFormatting.DARK_RED));
        }
    }

    public static long getEnergy(ItemStack stack) {
        @Nullable IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap != null && cap instanceof ApertureEnergy) {
            ApertureEnergy energy = (ApertureEnergy)cap;
            return energy.getTrueEnergyStored();
        }
        return 0L;
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return TEXTURE;
    }

    public long getCapacity() {
        return (Long)LongFallBootsConfig.long_fall_boots_max_energy_stored.get();
    }

    public long getTransfer() {
        return (Boolean)LongFallBootsConfig.long_fall_boots_use_energy.get() != false ? 1000L : 0L;
    }

    public static class Energy
    extends ApertureEnergy.Item {
        public Energy(ItemStack stack) {
            super(stack, (Long)LongFallBootsConfig.long_fall_boots_max_energy_stored.get(), 1000L, 1000L);
        }

        @Override
        public long receiveLongEnergy(long maxReceive, boolean simulate) {
            return super.receiveLongEnergy(maxReceive, simulate);
        }

        @Override
        public long extractLongEnergy(long maxExtract, boolean simulate) {
            return super.extractLongEnergy(maxExtract, simulate);
        }

        @Override
        public long maxReceive() {
            Item item = this.stack.getItem();
            if (item instanceof LongFallBootsItem) {
                LongFallBootsItem boots = (LongFallBootsItem)item;
                return boots.getTransfer();
            }
            return 0L;
        }

        @Override
        public long maxExtract() {
            Item item = this.stack.getItem();
            if (item instanceof LongFallBootsItem) {
                LongFallBootsItem boots = (LongFallBootsItem)item;
                return boots.getTransfer();
            }
            return 0L;
        }

        @Override
        public long loadEnergy(ItemStack stack) {
            return (Long)stack.getOrDefault(DataComponentInit.ENERGY, (Object)((Long)LongFallBootsConfig.long_fall_boots_max_energy_stored.get()));
        }

        @Override
        public long getTrueMaxEnergyStored() {
            Item item = this.stack.getItem();
            if (item instanceof LongFallBootsItem) {
                LongFallBootsItem boots = (LongFallBootsItem)item;
                return boots.getCapacity();
            }
            return 0L;
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            this.stack.set(DataComponentInit.ENERGY, (Object)this.energy);
        }
    }
}

