/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.items;

import java.awt.Color;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mistersecret312.aperture_innovations.ApertureInnovations;
import net.mistersecret312.aperture_innovations.capabilities.ApertureEnergy;
import net.mistersecret312.aperture_innovations.client.renderer.PortalGunRenderer;
import net.mistersecret312.aperture_innovations.config.PortalGunConfig;
import net.mistersecret312.aperture_innovations.init.AdvancementInit;
import net.mistersecret312.aperture_innovations.init.DataComponentInit;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.network.ClientboundPortalSoundsPacket;
import net.mistersecret312.aperture_innovations.portal.PortalLink;
import net.mistersecret312.aperture_innovations.portal.PortalLinkData;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PortalGunItem
extends Item
implements GeoItem {
    public static final String ENERGY = "Energy";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PortalGunItem(Item.Properties pProperties) {
        super(pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static ItemStack createPortalGun(ResourceLocation variantKey) {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.PORTAL_GUN.get());
        PortalGunItem item = (PortalGunItem)stack.getItem();
        item.setVariant(stack, variantKey);
        return stack;
    }

    public boolean isBarVisible(ItemStack stack) {
        return (Boolean)PortalGunConfig.portal_gun_uses_energy.get() != false && (long)PortalGunItem.getEnergy(stack) != this.getCapacity();
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)PortalGunItem.getEnergy(stack) / (float)this.getCapacity());
    }

    public int getBarColor(ItemStack stack) {
        return new Color(0, 200, 255).getRGB();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        components.add((Component)Component.translatable((String)("aperture_innovations.portal_gun.variant_" + this.getVariant(stack).getPath())).withStyle(ChatFormatting.YELLOW));
        int dualityState = this.getDualityState(stack);
        int primaryStripeColor = this.getPrimaryStripeColor(stack);
        int secondaryStripeColor = this.getSecondaryStripeColor(stack);
        int primaryPortalColor = this.getPrimaryPortalColor(stack);
        int secondaryPortalColor = this.getSecondaryPortalColor(stack);
        if (dualityState == 0) {
            components.add((Component)Component.translatable((String)"item.aperture_innovations.portal_gun.duality_primary").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
        if (dualityState == 1) {
            components.add((Component)Component.translatable((String)"item.aperture_innovations.portal_gun.duality_secondary").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
        if (this.getPair(stack) != null && dualityState != 2) {
            components.add((Component)Component.translatable((String)"item.aperture_innovations.portal_gun.paired").withStyle(ChatFormatting.DARK_PURPLE));
        }
        if (((Boolean)PortalGunConfig.portal_gun_uses_energy.get()).booleanValue()) {
            components.add((Component)Component.translatable((String)"item.aperture_innovations.portal_gun.energy").append(ApertureEnergy.energyToString(PortalGunItem.getEnergy(stack), this.getCapacity())).withStyle(ChatFormatting.DARK_RED));
        }
        if (primaryPortalColor != -1 || primaryStripeColor != -1 || secondaryPortalColor != -1 || secondaryStripeColor != -1) {
            components.add((Component)Component.literal((String)""));
        }
        if (primaryPortalColor != -1) {
            components.add((Component)Component.translatable((String)"item.aperture_innovations.portal_gun.portal_primary_color", (Object[])new Object[]{Integer.toHexString(primaryPortalColor).toUpperCase()}).withStyle(style -> style.withColor(primaryPortalColor)));
        }
        if (secondaryPortalColor != -1) {
            components.add((Component)Component.translatable((String)"item.aperture_innovations.portal_gun.portal_secondary_color", (Object[])new Object[]{Integer.toHexString(secondaryPortalColor).toUpperCase()}).withStyle(style -> style.withColor(secondaryPortalColor)));
        }
        if (primaryStripeColor != -1) {
            components.add((Component)Component.translatable((String)"item.aperture_innovations.portal_gun.stripe_primary_color", (Object[])new Object[]{Integer.toHexString(primaryStripeColor).toUpperCase()}).withStyle(style -> style.withColor(primaryStripeColor)));
        }
        if (secondaryStripeColor != -1) {
            components.add((Component)Component.translatable((String)"item.aperture_innovations.portal_gun.stripe_secondary_color", (Object[])new Object[]{Integer.toHexString(secondaryStripeColor).toUpperCase()}).withStyle(style -> style.withColor(secondaryStripeColor)));
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (level.isClientSide() || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.isInitialized(stack)) {
            this.setInitialized(stack, true);
            PortalLinkData data = PortalLinkData.get(level);
            UUID linkID = this.getUUID(stack, true);
            PortalLink link = data.getLink(linkID);
            if (link == null) {
                data.addFreshLink(linkID);
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(player.blockPosition()), (CustomPacketPayload)new ClientboundPortalSoundsPacket.GunActivate(linkID, player.blockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else {
            long toExtract;
            ApertureEnergy energy;
            long extracted;
            IEnergyStorage cap;
            PortalLink link = PortalUtilities.getPortalLinks(level).get(this.getUUID(stack, false));
            if (link != null && link.isOpen() && ((Boolean)PortalGunConfig.portal_gun_uses_energy.get()).booleanValue() && (cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null && cap instanceof ApertureEnergy && (extracted = (energy = (ApertureEnergy)cap).extractLongEnergy(toExtract = (link.isInterdimensionalLink() ? (Long)PortalGunConfig.portal_gun_passive_consumption.get() : (Long)PortalGunConfig.portal_gun_interdimensional_passive_consumption.get()).longValue(), false)) < toExtract) {
                player.displayClientMessage((Component)Component.translatable((String)"item.aperture_innovations.portal_gun.not_enough_energy").withStyle(ChatFormatting.DARK_RED), true);
                link.reset(level);
            }
            if (link != null && isSelected && (this.getPair(stack) == null || this.getDualityState(stack) == 2)) {
                link.updateColors(level, this.getPrimaryPortalColor(stack), this.getSecondaryPortalColor(stack));
                link.updateVariant(level, this.getVariant(stack));
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Entity owner;
        if (entity.isInFluidType() && (owner = entity.getOwner()) instanceof Player) {
            Player player = (Player)owner;
            AdvancementInit.THROWN_INTO_FLUID.get().trigger((ServerPlayer)player, stack, entity.blockPosition());
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return this.getDualityState(stack) != 2;
    }

    public static int getEnergy(ItemStack stack) {
        @Nullable IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy != null) {
            return energy.getEnergyStored();
        }
        return 0;
    }

    public long getCapacity() {
        return (Long)PortalGunConfig.portal_gun_max_energy_stored.get();
    }

    public long getTransfer() {
        return (Boolean)PortalGunConfig.portal_gun_uses_energy.get() != false ? 10000L : 0L;
    }

    public static BlockHitResult rayTrace(Level level, Player player, double range) {
        float xRot = player.getXRot();
        float yRot = player.getYRot();
        Vec3 eyePos = player.getEyePosition();
        float f2 = Mth.cos((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-xRot * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-xRot * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 lookVec = new Vec3((double)f6, (double)f5, (double)f7);
        Vec3 endPos = eyePos.add(lookVec.scale(range));
        ClipContext context = new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player){

            public VoxelShape getBlockShape(BlockState state, BlockGetter level, BlockPos pos) {
                if (state.is(ApertureInnovations.SHOOT_THROUGH)) {
                    return Shapes.empty();
                }
                return super.getBlockShape(state, level, pos);
            }
        };
        return level.clip(context);
    }

    public boolean isLookingAtMoon(Player player, Level level) {
        HitResult hit = player.pick((double)((Integer)PortalGunConfig.portal_gun_shoot_range.get()).intValue(), 0.0f, false);
        if (hit.getType() != HitResult.Type.MISS) {
            return false;
        }
        float timeAngle = level.getSunAngle(0.0f);
        double moonX = Math.sin(timeAngle);
        double moonY = -Math.cos(timeAngle);
        Vec3 moonVector = new Vec3(moonX, moonY, 0.0);
        Vec3 lookVector = player.getLookAngle();
        double dot = lookVector.dot(moonVector);
        return dot > 0.995;
    }

    public UUID getUUID(ItemStack stack, boolean generateIfEmpty) {
        int dualityState = this.getDualityState(stack);
        if (dualityState != 2 && this.getPair(stack) != null) {
            return this.getPair(stack);
        }
        String linkString = (String)stack.get(DataComponentInit.LINK_ID);
        if (linkString == null && generateIfEmpty) {
            UUID linkID = UUID.randomUUID();
            this.setUUID(stack, linkID);
            return linkID;
        }
        if (linkString != null) {
            return UUID.fromString(linkString);
        }
        return null;
    }

    public void setUUID(ItemStack stack, UUID uuid) {
        stack.set(DataComponentInit.LINK_ID, (Object)uuid.toString());
    }

    public UUID getPair(ItemStack stack) {
        String pairString = (String)stack.get(DataComponentInit.PAIR_ID);
        if (pairString == null) {
            return null;
        }
        return UUID.fromString(pairString);
    }

    public void setPair(ItemStack stack, UUID pairID) {
        if (pairID == null) {
            stack.remove(DataComponentInit.PAIR_ID);
            return;
        }
        stack.set(DataComponentInit.PAIR_ID, (Object)pairID.toString());
    }

    public int getDualityState(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentInit.DUALITY_STATE, (Object)2);
    }

    public int getPrimaryStripeColor(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentInit.PRIMARY_STRIPE_COLOR, (Object)-1);
    }

    public int getSecondaryStripeColor(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentInit.SECONDARY_STRIPE_COLOR, (Object)-1);
    }

    public int getPrimaryPortalColor(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentInit.PRIMARY_PORTAL_COLOR, (Object)-1);
    }

    public int getSecondaryPortalColor(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentInit.SECONDARY_PORTAL_COLOR, (Object)-1);
    }

    public ResourceLocation getVariant(ItemStack stack) {
        return (ResourceLocation)stack.getOrDefault(DataComponentInit.PORTAL_GUN_VARIANT, (Object)ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"chell"));
    }

    public void setDualityState(ItemStack stack, int state) {
        stack.set(DataComponentInit.DUALITY_STATE, (Object)state);
    }

    public void setPrimaryStripeColor(ItemStack stack, int color) {
        stack.set(DataComponentInit.PRIMARY_STRIPE_COLOR, (Object)color);
    }

    public void setSecondaryStripeColor(ItemStack stack, int color) {
        stack.set(DataComponentInit.SECONDARY_STRIPE_COLOR, (Object)color);
    }

    public void setPrimaryPortalColor(ItemStack stack, int color) {
        stack.set(DataComponentInit.PRIMARY_PORTAL_COLOR, (Object)color);
    }

    public void setSecondaryPortalColor(ItemStack stack, int color) {
        stack.set(DataComponentInit.SECONDARY_PORTAL_COLOR, (Object)color);
    }

    public void setVariant(ItemStack stack, ResourceLocation variantKey) {
        stack.set(DataComponentInit.PORTAL_GUN_VARIANT, (Object)variantKey);
    }

    public int getLastShotPortal(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentInit.LAST_PORTAL, (Object)-1);
    }

    public void setLastShotPortal(ItemStack stack, int portal) {
        stack.set(DataComponentInit.LAST_PORTAL, (Object)portal);
    }

    public void setInitialized(ItemStack stack, boolean value) {
        stack.set(DataComponentInit.INITIALIZED, (Object)value);
    }

    public boolean isInitialized(ItemStack stack) {
        return (Boolean)stack.getOrDefault(DataComponentInit.INITIALIZED, (Object)false);
    }

    private <T extends PortalGunItem> PlayState handleAnimationState(AnimationState state) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "main", 0, this::handleAnimationState);
        controller.triggerableAnim("shoot", Animations.SHOOT);
        controller.triggerableAnim("reset", Animations.RESET);
        controller.triggerableAnim("hold", Animations.HOLD);
        controllers.add(controller);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private PortalGunRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PortalGunRenderer();
                }
                return this.renderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static class Animations {
        protected static final String MAIN_CONTROLLER = "main";
        protected static final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");
        protected static final RawAnimation RESET = RawAnimation.begin().thenPlay("reset");
        protected static final RawAnimation HOLD = RawAnimation.begin().thenLoop("hold");

        private Animations() {
        }
    }

    public static class Energy
    extends ApertureEnergy.Item {
        public Energy(ItemStack stack) {
            super(stack, (Long)PortalGunConfig.portal_gun_max_energy_stored.get(), 10000L, 10000L);
        }

        @Override
        public long receiveLongEnergy(long maxReceive, boolean simulate) {
            return super.receiveLongEnergy(maxReceive, simulate);
        }

        @Override
        public long extractLongEnergy(long maxExtract, boolean simulate) {
            return super.extractLongEnergy(maxExtract, simulate);
        }

        @Override
        public long maxReceive() {
            Item item = this.stack.getItem();
            if (item instanceof PortalGunItem) {
                PortalGunItem portalGun = (PortalGunItem)item;
                return portalGun.getTransfer();
            }
            return 0L;
        }

        @Override
        public long maxExtract() {
            Item item = this.stack.getItem();
            if (item instanceof PortalGunItem) {
                PortalGunItem portalGun = (PortalGunItem)item;
                return portalGun.getTransfer();
            }
            return 0L;
        }

        @Override
        public long loadEnergy(ItemStack stack) {
            return (Long)stack.getOrDefault(DataComponentInit.ENERGY, (Object)((Long)PortalGunConfig.portal_gun_max_energy_stored.get()));
        }

        @Override
        public long getTrueMaxEnergyStored() {
            Item item = this.stack.getItem();
            if (item instanceof PortalGunItem) {
                PortalGunItem portalGunItem = (PortalGunItem)item;
                return portalGunItem.getCapacity();
            }
            return 0L;
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            this.stack.set(DataComponentInit.ENERGY, (Object)this.energy);
        }
    }
}

