/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.mixin;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={CollisionGetter.class})
public interface CollisionMixin {
    @Overwrite
    default public Iterable<VoxelShape> getBlockCollisions(Entity entity, AABB entityBox) {
        ArrayList<VoxelShape> list = new ArrayList<VoxelShape>();
        CollisionGetter getter = (CollisionGetter)this;
        Iterable iterable = () -> new BlockCollisions(getter, entity, entityBox, false, (pos, shape) -> shape);
        for (VoxelShape voxelShape : iterable) {
            list.add(voxelShape);
        }
        if (entity == null) {
            return list;
        }
        Level level = entity.level();
        if (level == null) {
            return list;
        }
        Pair<UUID, Boolean> portal = PortalUtilities.getClosestPortal(entity);
        UUID uuid = (UUID)portal.getFirst();
        boolean isPrimary = (Boolean)portal.getSecond();
        if (uuid == null) {
            return list;
        }
        boolean isOpen = PortalUtilities.isPortalOpen(level, uuid);
        Vec3 portalPos = PortalUtilities.getPortalPos(level, uuid, isPrimary);
        Direction portalDirection = PortalUtilities.getPortalDirection(level, uuid, isPrimary);
        boolean isOnWall = PortalUtilities.isPortalOnWall(level, uuid, isPrimary);
        boolean isOnCeiling = PortalUtilities.isPortalOnCeiling(level, uuid, isPrimary);
        AABB portalBox = PortalUtilities.getPortalBoundingBox(portalPos, portalDirection, isOnWall, isOnCeiling);
        AABB floorBox = PortalUtilities.getPortalFloorBox(portalPos, portalDirection, isOnWall).inflate(0.0, 0.01, 0.0);
        list.removeIf(shape -> shape.bounds().intersects(portalBox) && isOpen);
        if (entityBox.intersects(floorBox) && isOpen) {
            list.add(Shapes.create((AABB)floorBox));
        }
        return list;
    }

    @Overwrite
    default public boolean collidesWithSuffocatingBlock(Entity entity, AABB entityBox) {
        CollisionGetter getter = (CollisionGetter)this;
        BlockCollisions blockcollisions = new BlockCollisions(getter, entity, entityBox, true, (pos, shape) -> shape);
        if (entity == null) {
            return this.original((Iterator<VoxelShape>)blockcollisions);
        }
        Level level = entity.level();
        if (level == null) {
            return this.original((Iterator<VoxelShape>)blockcollisions);
        }
        Pair<UUID, Boolean> portal = PortalUtilities.getClosestPortal(entity);
        UUID uuid = (UUID)portal.getFirst();
        boolean isPrimary = (Boolean)portal.getSecond();
        if (uuid == null) {
            return this.original((Iterator<VoxelShape>)blockcollisions);
        }
        boolean isOpen = PortalUtilities.isPortalOpen(level, uuid);
        Vec3 portalPos = PortalUtilities.getPortalPos(level, uuid, isPrimary);
        Direction portalDirection = PortalUtilities.getPortalDirection(level, uuid, isPrimary);
        boolean isOnWall = PortalUtilities.isPortalOnWall(level, uuid, isPrimary);
        boolean isOnCeiling = PortalUtilities.isPortalOnCeiling(level, uuid, isPrimary);
        AABB portalBox = PortalUtilities.getPortalBoundingBox(portalPos, portalDirection, isOnWall, isOnCeiling);
        AABB floorBox = PortalUtilities.getPortalFloorBox(portalPos, portalDirection, isOnWall).inflate(0.0, 0.01, 0.0);
        if (!isOpen) {
            portalBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            floorBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        ArrayList<VoxelShape> list = new ArrayList<VoxelShape>();
        blockcollisions.forEachRemaining(list::add);
        if (entityBox.intersects(floorBox)) {
            list.add(Shapes.create((AABB)floorBox));
        }
        for (VoxelShape shape2 : list) {
            if (!shape2.isEmpty() && shape2.bounds() == floorBox) {
                return true;
            }
            if (shape2.isEmpty() || shape2.bounds().intersects(portalBox)) continue;
            return true;
        }
        return false;
    }

    @Unique
    default public boolean original(Iterator<VoxelShape> blockcollisions) {
        while (blockcollisions.hasNext()) {
            VoxelShape shape = blockcollisions.next();
            if (shape.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

