/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.mixin;

import net.minecraft.client.model.PlayerModel;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public class PlayerModelMixin {
    @Unique
    private static final float LEG_V_PIVOT = 0.3125f;
    @Unique
    private static final float LEG_CUT_RATIO = 0.5f;

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    private void shortenLegs(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        PlayerModel self = (PlayerModel)this;
        boolean shortypants = this.shouldShortenLegs(entity);
        if (shortypants) {
            self.leftLeg.yScale = 0.5f;
            self.rightLeg.yScale = 0.5f;
            self.leftPants.yScale = 0.5f;
            self.rightPants.yScale = 0.5f;
        }
        self.leftLeg.skipDraw = shortypants;
        self.rightLeg.skipDraw = shortypants;
        self.leftPants.skipDraw = shortypants;
        self.rightPants.skipDraw = shortypants;
    }

    @Unique
    private boolean shouldShortenLegs(LivingEntity entity) {
        return true;
    }
}

