/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.mistersecret312.aperture_innovations.client.renderer.PortalRenderer;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientBoundPortalSyncPacket(UUID linkID, boolean isPrimary, BlockPos portalPos, Direction portalDirection, boolean portalWall, boolean portalCeiling, ResourceKey<Level> portalDimension, boolean moonshotPortal, ResourceLocation variant, int color) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientBoundPortalSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"s2c_portal_sync"));
    public static final StreamCodec<ByteBuf, ClientBoundPortalSyncPacket> STREAM_CODEC = new StreamCodec<ByteBuf, ClientBoundPortalSyncPacket>(){

        public ClientBoundPortalSyncPacket decode(ByteBuf buffer) {
            UUID uuid = FriendlyByteBuf.readUUID((ByteBuf)buffer);
            boolean isPrimary = buffer.readBoolean();
            boolean present = buffer.readBoolean();
            BlockPos pos = null;
            boolean wall = false;
            boolean ceiling = false;
            ResourceKey dimension = null;
            Direction direction = null;
            if (present) {
                pos = FriendlyByteBuf.readBlockPos((ByteBuf)buffer);
                direction = Direction.from3DDataValue((int)buffer.readInt());
                wall = buffer.readBoolean();
                ceiling = buffer.readBoolean();
                dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)Utf8String.read((ByteBuf)buffer, (int)Short.MAX_VALUE)));
            }
            boolean moonshot = buffer.readBoolean();
            ResourceLocation variant = ResourceLocation.parse((String)Utf8String.read((ByteBuf)buffer, (int)Short.MAX_VALUE));
            int color = buffer.readInt();
            return new ClientBoundPortalSyncPacket(uuid, isPrimary, pos, direction, wall, ceiling, (ResourceKey<Level>)dimension, moonshot, variant, color);
        }

        public void encode(ByteBuf buffer, ClientBoundPortalSyncPacket packet) {
            FriendlyByteBuf.writeUUID((ByteBuf)buffer, (UUID)packet.linkID);
            buffer.writeBoolean(packet.isPrimary);
            if (packet.portalPos != null) {
                buffer.writeBoolean(true);
                FriendlyByteBuf.writeBlockPos((ByteBuf)buffer, (BlockPos)packet.portalPos);
                buffer.writeInt(packet.portalDirection.get3DDataValue());
                buffer.writeBoolean(packet.portalWall);
                buffer.writeBoolean(packet.portalCeiling);
                Utf8String.write((ByteBuf)buffer, (CharSequence)packet.portalDimension.location().toString(), (int)Short.MAX_VALUE);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeBoolean(packet.moonshotPortal);
            Utf8String.write((ByteBuf)buffer, (CharSequence)packet.variant.toString(), (int)Short.MAX_VALUE);
            buffer.writeInt(packet.color);
        }
    };

    public CustomPacketPayload.Type<ClientBoundPortalSyncPacket> type() {
        return TYPE;
    }

    public static void handle(ClientBoundPortalSyncPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ClientPortalLink link = PortalRenderer.LINKS.getOrDefault(packet.linkID, new ClientPortalLink());
            link.variantKey = packet.variant;
            link.linkID = packet.linkID;
            if (packet.isPrimary) {
                link.posPrimary = packet.portalPos;
                link.wallPrimary = packet.portalWall;
                link.directionPrimary = packet.portalDirection;
                link.ceilingPrimary = packet.portalCeiling;
                link.dimensionPrimary = packet.portalDimension;
                link.moonshotPrimary = packet.moonshotPortal;
                link.primaryPortalColor = packet.color;
            } else {
                link.posSecondary = packet.portalPos;
                link.wallSecondary = packet.portalWall;
                link.directionSecondary = packet.portalDirection;
                link.ceilingSecondary = packet.portalCeiling;
                link.dimensionSecondary = packet.portalDimension;
                link.moonshotSecondary = packet.moonshotPortal;
                link.secondaryPortalColor = packet.color;
            }
            PortalRenderer.LINKS.put(packet.linkID, link);
        });
    }
}

