/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.mistersecret312.aperture_innovations.sounds.SoundAccess;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public abstract class ClientboundPortalSoundsPacket {

    public record ResetPortal(UUID linkID, BlockPos pos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ResetPortal> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"s2c_reset_portal"));
        public static final StreamCodec<ByteBuf, ResetPortal> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, ResetPortal::linkID, (StreamCodec)BlockPos.STREAM_CODEC, ResetPortal::pos, ResetPortal::new);

        public static void handle(ResetPortal packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playResetPortalSound(packet.linkID, packet.pos, true));
        }

        public CustomPacketPayload.Type<ResetPortal> type() {
            return TYPE;
        }
    }

    public record ShootPortal(UUID linkID, BlockPos pos, boolean isPrimary) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ShootPortal> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"s2c_shoot_portal"));
        public static final StreamCodec<ByteBuf, ShootPortal> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, ShootPortal::linkID, (StreamCodec)BlockPos.STREAM_CODEC, ShootPortal::pos, (StreamCodec)ByteBufCodecs.BOOL, ShootPortal::isPrimary, ShootPortal::new);

        public static void handle(ShootPortal packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playShootPortalSound(packet.linkID, packet.pos, packet.isPrimary));
        }

        public CustomPacketPayload.Type<ShootPortal> type() {
            return TYPE;
        }
    }

    public record GunActivate(UUID linkID, BlockPos pos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<GunActivate> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"s2c_gun_activate"));
        public static final StreamCodec<ByteBuf, GunActivate> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, GunActivate::linkID, (StreamCodec)BlockPos.STREAM_CODEC, GunActivate::pos, GunActivate::new);

        public static void handle(GunActivate packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playGunActivateSound(packet.linkID, packet.pos, true));
        }

        public CustomPacketPayload.Type<GunActivate> type() {
            return TYPE;
        }
    }

    public record FizzlePortal(UUID linkID, boolean isPrimary) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<FizzlePortal> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"s2c_fizzle_portal"));
        public static final StreamCodec<ByteBuf, FizzlePortal> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, FizzlePortal::linkID, (StreamCodec)ByteBufCodecs.BOOL, FizzlePortal::isPrimary, FizzlePortal::new);

        public static void handle(FizzlePortal packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playFizzlePortalSound(packet.linkID, packet.isPrimary));
        }

        public CustomPacketPayload.Type<FizzlePortal> type() {
            return TYPE;
        }
    }

    public record InvalidSurface(UUID linkID, BlockPos pos, boolean isPrimary) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<InvalidSurface> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"s2c_invalid_surface"));
        public static final StreamCodec<ByteBuf, InvalidSurface> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, InvalidSurface::linkID, (StreamCodec)BlockPos.STREAM_CODEC, InvalidSurface::pos, (StreamCodec)ByteBufCodecs.BOOL, InvalidSurface::isPrimary, InvalidSurface::new);

        public static void handle(InvalidSurface packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playInvalidSurfaceSound(packet.linkID, packet.pos, packet.isPrimary));
        }

        public CustomPacketPayload.Type<InvalidSurface> type() {
            return TYPE;
        }
    }

    public record EnterPortal(UUID linkID, boolean isPrimary) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<EnterPortal> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"s2c_enter_portal"));
        public static final StreamCodec<ByteBuf, EnterPortal> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, EnterPortal::linkID, (StreamCodec)ByteBufCodecs.BOOL, EnterPortal::isPrimary, EnterPortal::new);

        public static void handle(EnterPortal packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playEnterPortalSound(packet.linkID, packet.isPrimary));
        }

        public CustomPacketPayload.Type<EnterPortal> type() {
            return TYPE;
        }
    }

    public record OpenPortal(UUID linkID, boolean isPrimary) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<OpenPortal> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"s2c_open_portal"));
        public static final StreamCodec<ByteBuf, OpenPortal> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, OpenPortal::linkID, (StreamCodec)ByteBufCodecs.BOOL, OpenPortal::isPrimary, OpenPortal::new);

        public static void handle(OpenPortal packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playOpenPortalSound(packet.linkID, packet.isPrimary));
        }

        public CustomPacketPayload.Type<OpenPortal> type() {
            return TYPE;
        }
    }
}

