/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.mistersecret312.aperture_innovations.ApertureInnovations;
import net.mistersecret312.aperture_innovations.capabilities.ApertureEnergy;
import net.mistersecret312.aperture_innovations.config.PortalGunConfig;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.network.ClientboundPortalSoundsPacket;
import net.mistersecret312.aperture_innovations.portal.PortalLink;
import net.mistersecret312.aperture_innovations.portal.PortalLinkData;
import net.mistersecret312.aperture_innovations.portal.PortalPlacement;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;

public record ServerboundOpenPortalPacket(boolean isPrimary) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundOpenPortalPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"c2s_open_portal"));
    public static final StreamCodec<ByteBuf, ServerboundOpenPortalPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ServerboundOpenPortalPacket::isPrimary, ServerboundOpenPortalPacket::new);

    public CustomPacketPayload.Type<ServerboundOpenPortalPacket> type() {
        return TYPE;
    }

    public static void handle(ServerboundOpenPortalPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            boolean hasPortalGun;
            ServerPlayer player = (ServerPlayer)ctx.player();
            Level level = player.level();
            boolean isPrimary = packet.isPrimary;
            ItemStack main = player.getMainHandItem();
            ItemStack off = player.getOffhandItem();
            boolean bl = hasPortalGun = main.is((Item)ItemInit.PORTAL_GUN.get()) || off.is((Item)ItemInit.PORTAL_GUN.get());
            if (!hasPortalGun) {
                return;
            }
            ItemStack gunStack = main.is((Item)ItemInit.PORTAL_GUN.get()) ? main : off;
            PortalGunItem portalGun = (PortalGunItem)gunStack.getItem();
            if (((Boolean)PortalGunConfig.portal_gun_consume_on_shot.get()).booleanValue() && ((Boolean)PortalGunConfig.portal_gun_uses_energy.get()).booleanValue() && !ServerboundOpenPortalPacket.consumeEnergy(gunStack, (Player)player)) {
                return;
            }
            boolean moonshot = portalGun.isLookingAtMoon((Player)player, level);
            if (moonshot) {
                if (!((Boolean)PortalGunConfig.portal_gun_consume_on_shot.get()).booleanValue() && ((Boolean)PortalGunConfig.portal_gun_uses_energy.get()).booleanValue() && !ServerboundOpenPortalPacket.consumeEnergy(gunStack, (Player)player)) {
                    return;
                }
                UUID linkID = portalGun.getUUID(gunStack, true);
                PortalLinkData linkData = PortalLinkData.get(level);
                PortalLink link = linkData.getLink(gunStack);
                if (link == null) {
                    linkData.addFreshLink(linkID);
                    link = linkData.getLink(linkID);
                }
                portalGun.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                portalGun.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                if (isPrimary) {
                    portalGun.setLastShotPortal(gunStack, 0);
                    link.setMoonshot(isPrimary, true, level);
                } else {
                    portalGun.setLastShotPortal(gunStack, 1);
                    link.setMoonshot(isPrimary, true, level);
                }
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(player.blockPosition()), (CustomPacketPayload)new ClientboundPortalSoundsPacket.ShootPortal(linkID, player.blockPosition(), isPrimary), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            BlockHitResult result = PortalGunItem.rayTrace(player.level(), (Player)player, ((Integer)PortalGunConfig.portal_gun_shoot_range.get()).intValue());
            if (!result.getType().equals((Object)HitResult.Type.MISS)) {
                PortalPlacement.Result placement;
                UUID linkID = portalGun.getUUID(gunStack, false);
                if (linkID != null && !level.getBlockState(result.getBlockPos()).is(ApertureInnovations.SHOOT_THROUGH) && (level.getBlockState(result.getBlockPos()).is(ApertureInnovations.IMPORTALABLE) || !level.getFluidState(result.getBlockPos()).isEmpty() || ((Boolean)PortalGunConfig.use_portalable_tag.get()).booleanValue() && !level.getBlockState(result.getBlockPos()).is(ApertureInnovations.PORTALABLE))) {
                    if (!((Boolean)PortalGunConfig.portal_gun_consume_on_shot.get()).booleanValue() && ((Boolean)PortalGunConfig.portal_gun_uses_energy.get()).booleanValue() && !ServerboundOpenPortalPacket.consumeEnergy(gunStack, (Player)player)) {
                        return;
                    }
                    portalGun.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    portalGun.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(player.blockPosition()), (CustomPacketPayload)new ClientboundPortalSoundsPacket.ShootPortal(linkID, player.blockPosition(), isPrimary), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(player.blockPosition()), (CustomPacketPayload)new ClientboundPortalSoundsPacket.InvalidSurface(linkID, player.blockPosition(), isPrimary), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return;
                }
                PortalLinkData linkData = PortalLinkData.get(level);
                PortalLink link = linkData.getLink(gunStack);
                if (link == null) {
                    linkData.addFreshLink(linkID);
                    link = linkData.getLink(linkID);
                }
                if ((placement = PortalPlacement.getBestPlacement(level, result, (Player)player, linkID, isPrimary)) != null) {
                    portalGun.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    portalGun.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    if (!((Boolean)PortalGunConfig.portal_gun_consume_on_shot.get()).booleanValue() && ((Boolean)PortalGunConfig.portal_gun_uses_energy.get()).booleanValue() && !ServerboundOpenPortalPacket.consumeEnergy(gunStack, (Player)player)) {
                        return;
                    }
                    if (isPrimary) {
                        portalGun.setLastShotPortal(gunStack, 0);
                        link.createPrimaryPortal(level, placement.bottomPos, (ResourceKey<Level>)level.dimension(), placement.facing, placement.rotation);
                        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(player.blockPosition()), (CustomPacketPayload)new ClientboundPortalSoundsPacket.ShootPortal(linkID, player.blockPosition(), isPrimary), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    } else {
                        portalGun.setLastShotPortal(gunStack, 1);
                        link.createSecondaryPortal(level, placement.bottomPos, (ResourceKey<Level>)level.dimension(), placement.facing, placement.rotation);
                        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(player.blockPosition()), (CustomPacketPayload)new ClientboundPortalSoundsPacket.ShootPortal(linkID, player.blockPosition(), isPrimary), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else {
                    portalGun.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    portalGun.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(player.blockPosition()), (CustomPacketPayload)new ClientboundPortalSoundsPacket.ShootPortal(linkID, player.blockPosition(), isPrimary), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(player.blockPosition()), (CustomPacketPayload)new ClientboundPortalSoundsPacket.InvalidSurface(linkID, player.blockPosition(), isPrimary), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
    }

    public static boolean consumeEnergy(ItemStack stack, Player player) {
        @Nullable IEnergyStorage capability = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (capability != null && capability instanceof ApertureEnergy) {
            ApertureEnergy energy = (ApertureEnergy)capability;
            long requiredEnergy = (Long)PortalGunConfig.portal_gun_shoot_consumption.get();
            if (energy.getTrueEnergyStored() > requiredEnergy) {
                energy.extractLongEnergy(requiredEnergy, false);
                return true;
            }
            player.displayClientMessage((Component)Component.translatable((String)"item.aperture_innovations.portal_gun.not_enough_energy").withStyle(ChatFormatting.DARK_RED), true);
            return false;
        }
        return false;
    }
}

