/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.portal;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.mistersecret312.aperture_innovations.client.resourcepack.ClientPortalGunVariant;
import net.mistersecret312.aperture_innovations.client.resourcepack.ClientPortalGunVariants;
import net.mistersecret312.aperture_innovations.datapack.PortalGunVariant;
import net.mistersecret312.aperture_innovations.sounds.PortalSoundWrapper;

public class ClientPortalLink {
    public UUID linkID;
    public BlockPos posPrimary;
    public BlockPos posSecondary;
    public boolean wallPrimary;
    public boolean wallSecondary;
    public boolean ceilingPrimary;
    public boolean ceilingSecondary;
    public ResourceKey<Level> dimensionPrimary;
    public ResourceKey<Level> dimensionSecondary;
    public Direction directionPrimary;
    public Direction directionSecondary;
    public boolean moonshotPrimary;
    public boolean moonshotSecondary;
    public ResourceLocation variantKey;
    public int primaryPortalColor = -1;
    public int secondaryPortalColor = -1;
    public PortalSoundWrapper.PortalAmbient primaryAmbient = null;
    public PortalSoundWrapper.PortalAmbient secondaryAmbient = null;

    public ClientPortalLink() {
    }

    public ClientPortalLink(UUID linkID, BlockPos posPrimary, BlockPos posSecondary, boolean wallPrimary, boolean wallSecondary, boolean ceilingPrimary, boolean ceilingSecondary, ResourceKey<Level> dimensionPrimary, ResourceKey<Level> dimensionSecondary, Direction directionPrimary, Direction directionSecondary, boolean moonshotPrimary, boolean moonshotSecondary, float openingPrimary, float openingSecondary, ResourceLocation variantKey, int primaryPortalColor, int secondaryPortalColor) {
        this.linkID = linkID;
        this.posPrimary = posPrimary;
        this.posSecondary = posSecondary;
        this.wallPrimary = wallPrimary;
        this.wallSecondary = wallSecondary;
        this.ceilingPrimary = ceilingPrimary;
        this.ceilingSecondary = ceilingSecondary;
        this.dimensionPrimary = dimensionPrimary;
        this.dimensionSecondary = dimensionSecondary;
        this.directionPrimary = directionPrimary;
        this.directionSecondary = directionSecondary;
        this.moonshotPrimary = moonshotPrimary;
        this.moonshotSecondary = moonshotSecondary;
        this.variantKey = variantKey;
        this.primaryPortalColor = primaryPortalColor;
        this.secondaryPortalColor = secondaryPortalColor;
    }

    public boolean isOpen() {
        return !(this.posPrimary == null && !this.moonshotPrimary || this.posSecondary == null && !this.moonshotSecondary);
    }

    public ClientPortalGunVariant getVariant() {
        Registry registry = Minecraft.getInstance().level.registryAccess().registryOrThrow(PortalGunVariant.REGISTRY_KEY);
        PortalGunVariant dataVariant = (PortalGunVariant)registry.get(this.variantKey);
        return ClientPortalGunVariants.getPortalGunVariant(dataVariant.getClientVariant());
    }

    public UUID linkID() {
        return this.linkID;
    }

    public BlockPos posPrimary() {
        return this.posPrimary;
    }

    public BlockPos posSecondary() {
        return this.posSecondary;
    }

    public Direction directionPrimary() {
        return this.directionPrimary;
    }

    public Direction directionSecondary() {
        return this.directionSecondary;
    }

    public ResourceKey<Level> dimensionPrimary() {
        return this.dimensionPrimary;
    }

    public ResourceKey<Level> dimensionSecondary() {
        return this.dimensionSecondary;
    }

    public ResourceLocation variantKey() {
        return this.variantKey;
    }

    public boolean ceilingPrimary() {
        return this.ceilingPrimary;
    }

    public boolean ceilingSecondary() {
        return this.ceilingSecondary;
    }

    public boolean moonshotPrimary() {
        return this.moonshotPrimary;
    }

    public boolean moonshotSecondary() {
        return this.moonshotSecondary;
    }

    public boolean wallPrimary() {
        return this.wallPrimary;
    }

    public boolean wallSecondary() {
        return this.wallSecondary;
    }

    public int primaryPortalColor() {
        return this.primaryPortalColor;
    }

    public int secondaryPortalColor() {
        return this.secondaryPortalColor;
    }

    public void stopAmbient(boolean isPrimary) {
        if (this.primaryAmbient != null) {
            this.primaryAmbient.stopSound();
        }
        if (this.secondaryAmbient != null) {
            this.secondaryAmbient.stopSound();
        }
    }

    public void playAmbient(boolean isPrimary) {
        if (this.primaryAmbient != null && !this.primaryAmbient.isPlaying()) {
            this.primaryAmbient.playSound();
        }
        if (this.secondaryAmbient != null && !this.secondaryAmbient.isPlaying()) {
            this.secondaryAmbient.playSound();
        }
    }
}

