/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.portal;

import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.mistersecret312.aperture_innovations.client.ColorUtil;
import net.mistersecret312.aperture_innovations.client.resourcepack.ClientPortalGunVariant;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.sounds.PortalSoundWrapper;

public class ClientPortalUtilities {
    public static HashMap<UUID, Pair<PortalSoundWrapper.PortalAmbient, PortalSoundWrapper.PortalAmbient>> AMBIENTS = new HashMap();
    public static HashMap<UUID, Pair<Float, Float>> OPENING_ANIMATIONS = new HashMap();

    public static ColorUtil.RGBA getPortalColor(ClientPortalLink link, boolean isPrimary) {
        ColorUtil.RGBA variantColor;
        ClientPortalGunVariant variant = link.getVariant();
        int gunColor = isPrimary ? link.primaryPortalColor() : link.secondaryPortalColor();
        ColorUtil.RGBA rGBA = variantColor = isPrimary ? variant.primaryPortal().getColor() : variant.secondaryPortal().getColor();
        if (gunColor == -1) {
            return variantColor;
        }
        Color rgbaColor = new Color(gunColor, false);
        return new ColorUtil.RGBA((float)rgbaColor.getRed() / 255.0f, (float)rgbaColor.getGreen() / 255.0f, (float)rgbaColor.getBlue() / 255.0f, 1.0f);
    }

    public static ResourceLocation getCrosshairTexture(ClientPortalLink link, boolean isPrimary) {
        int gunColor;
        ClientPortalGunVariant variant = link.getVariant();
        int n = gunColor = isPrimary ? link.primaryPortalColor() : link.secondaryPortalColor();
        if (gunColor == -1) {
            return variant.crosshairTexture();
        }
        return isPrimary ? (variant.primaryPortal().isGenericColoring() ? variant.genericPortal().getCrosshairTexture() : variant.crosshairTexture()) : (variant.secondaryPortal().isGenericColoring() ? variant.genericPortal().getCrosshairTexture() : variant.crosshairTexture());
    }

    public static ResourceLocation getPortalHighlightTexture(ClientPortalLink link, boolean isPrimary) {
        int gunColor;
        ClientPortalGunVariant variant = link.getVariant();
        int n = gunColor = isPrimary ? link.primaryPortalColor() : link.secondaryPortalColor();
        if (gunColor == -1) {
            return isPrimary ? variant.primaryPortal().getHighlightTexture() : variant.secondaryPortal().getHighlightTexture();
        }
        return isPrimary ? (variant.primaryPortal().isGenericColoring() ? variant.genericPortal().getHighlightTexture() : variant.primaryPortal().getHighlightTexture()) : (variant.secondaryPortal().isGenericColoring() ? variant.genericPortal().getHighlightTexture() : variant.secondaryPortal().getHighlightTexture());
    }

    public static ResourceLocation getPortalGunCoreTexture(ClientPortalLink link, int lastPortal) {
        int gunColor;
        ClientPortalGunVariant variant = link.getVariant();
        ResourceLocation genericCore = variant.genericPortal().getCoreTexture();
        ResourceLocation idleCore = variant.idleCoreTexture();
        ResourceLocation primaryCore = variant.primaryPortal().getCoreTexture();
        ResourceLocation secondaryCore = variant.secondaryPortal().getCoreTexture();
        if (lastPortal == -1) {
            return idleCore;
        }
        boolean isPrimary = lastPortal == 0;
        int n = gunColor = isPrimary ? link.primaryPortalColor() : link.secondaryPortalColor();
        if (gunColor == -1) {
            return isPrimary ? primaryCore : secondaryCore;
        }
        return isPrimary ? (variant.primaryPortal().isGenericColoring() ? genericCore : primaryCore) : (variant.secondaryPortal().isGenericColoring() ? genericCore : secondaryCore);
    }

    public static ResourceLocation getPortalGunTexture(ClientPortalLink link) {
        ClientPortalGunVariant variant = link.getVariant();
        return variant.texture();
    }

    public static ResourceLocation getPortalClosedTexture(ClientPortalLink link, boolean isPrimary) {
        int gunColor;
        ClientPortalGunVariant variant = link.getVariant();
        int n = gunColor = isPrimary ? link.primaryPortalColor() : link.secondaryPortalColor();
        if (gunColor == -1) {
            return isPrimary ? variant.primaryPortal().getClosedTexture() : variant.secondaryPortal().getClosedTexture();
        }
        return isPrimary ? (variant.primaryPortal().isGenericColoring() ? variant.genericPortal().getClosedTexture() : variant.primaryPortal().getClosedTexture()) : (variant.secondaryPortal().isGenericColoring() ? variant.genericPortal().getClosedTexture() : variant.secondaryPortal().getClosedTexture());
    }

    public static ResourceLocation getPortalVortexTexture(ClientPortalLink link, boolean isPrimary) {
        int gunColor;
        ClientPortalGunVariant variant = link.getVariant();
        int n = gunColor = isPrimary ? link.primaryPortalColor() : link.secondaryPortalColor();
        if (gunColor == -1) {
            return isPrimary ? variant.primaryPortal().getVortexTexture() : variant.secondaryPortal().getVortexTexture();
        }
        return isPrimary ? (variant.primaryPortal().isGenericColoring() ? variant.genericPortal().getVortexTexture() : variant.primaryPortal().getVortexTexture()) : (variant.secondaryPortal().isGenericColoring() ? variant.genericPortal().getVortexTexture() : variant.secondaryPortal().getVortexTexture());
    }

    public static PortalSoundWrapper.PortalAmbient getAmbientSound(UUID uuid, boolean isPrimary) {
        Pair<PortalSoundWrapper.PortalAmbient, PortalSoundWrapper.PortalAmbient> pair = AMBIENTS.getOrDefault(uuid, (Pair<PortalSoundWrapper.PortalAmbient, PortalSoundWrapper.PortalAmbient>)new Pair(null, null));
        if (isPrimary) {
            return (PortalSoundWrapper.PortalAmbient)pair.getFirst();
        }
        return (PortalSoundWrapper.PortalAmbient)pair.getSecond();
    }

    public static void setAmbientSound(PortalSoundWrapper.PortalAmbient ambient, UUID uuid, boolean isPrimary) {
        Pair pair = AMBIENTS.getOrDefault(uuid, (Pair<PortalSoundWrapper.PortalAmbient, PortalSoundWrapper.PortalAmbient>)new Pair(null, null));
        pair = isPrimary ? new Pair((Object)ambient, (Object)((PortalSoundWrapper.PortalAmbient)pair.getSecond())) : new Pair((Object)((PortalSoundWrapper.PortalAmbient)pair.getFirst()), (Object)ambient);
        AMBIENTS.put(uuid, (Pair<PortalSoundWrapper.PortalAmbient, PortalSoundWrapper.PortalAmbient>)pair);
    }

    public static float getPortalOpeningAnimationProgress(UUID uuid, boolean isPrimary) {
        Pair<Float, Float> pair = OPENING_ANIMATIONS.getOrDefault(uuid, (Pair<Float, Float>)new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        if (isPrimary) {
            return ((Float)pair.getFirst()).floatValue();
        }
        return ((Float)pair.getSecond()).floatValue();
    }

    public static void setPortalOpeningAnimationProgress(float progress, UUID uuid, boolean isPrimary) {
        Pair pair = OPENING_ANIMATIONS.getOrDefault(uuid, (Pair<Float, Float>)new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        pair = isPrimary ? new Pair((Object)Float.valueOf(progress), (Object)((Float)pair.getSecond())) : new Pair((Object)((Float)pair.getFirst()), (Object)Float.valueOf(progress));
        OPENING_ANIMATIONS.put(uuid, (Pair<Float, Float>)pair);
    }
}

