/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.portal;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.mistersecret312.aperture_innovations.datapack.PortalGunVariant;
import net.mistersecret312.aperture_innovations.network.ClientboundPortalSoundsPacket;
import net.mistersecret312.aperture_innovations.portal.PortalLinkData;
import net.neoforged.neoforge.network.PacketDistributor;

public class PortalLink {
    public UUID linkID;
    public BlockPos posPrimary;
    public BlockPos posSecondary;
    public boolean wallPrimary;
    public boolean wallSecondary;
    public boolean ceilingPrimary;
    public boolean ceilingSecondary;
    public ResourceKey<Level> dimensionPrimary;
    public ResourceKey<Level> dimensionSecondary;
    public Direction directionPrimary;
    public Direction directionSecondary;
    public boolean moonshotPrimary = false;
    public boolean moonshotSecondary = false;
    public ResourceLocation variantKey = null;
    public int primaryPortalColor = -1;
    public int secondaryPortalColor = -1;

    public PortalLink(UUID linkID, ResourceLocation variantKey) {
        this.linkID = linkID;
        this.variantKey = variantKey;
    }

    public PortalLink(UUID linkID, BlockPos posPrimary, BlockPos posSecondary, boolean wallPrimary, boolean wallSecondary, boolean ceilingPrimary, boolean ceilingSecondary, ResourceKey<Level> dimensionPrimary, ResourceKey<Level> dimensionSecondary, Direction directionPrimary, Direction directionSecondary, ResourceLocation variantKey, int primaryPortalColor, int secondaryPortalColor) {
        this.linkID = linkID;
        this.posPrimary = posPrimary;
        this.posSecondary = posSecondary;
        this.wallPrimary = wallPrimary;
        this.wallSecondary = wallSecondary;
        this.ceilingPrimary = ceilingPrimary;
        this.ceilingSecondary = ceilingSecondary;
        this.dimensionPrimary = dimensionPrimary;
        this.dimensionSecondary = dimensionSecondary;
        this.directionPrimary = directionPrimary;
        this.directionSecondary = directionSecondary;
        this.primaryPortalColor = primaryPortalColor;
        this.secondaryPortalColor = secondaryPortalColor;
        this.variantKey = variantKey;
    }

    public void createPrimaryPortal(Level level, BlockPos pos, ResourceKey<Level> dimension, Direction direction, Direction facing) {
        this.posPrimary = pos;
        this.dimensionPrimary = dimension;
        this.directionPrimary = facing.equals((Object)Direction.UP) ? direction : facing;
        this.wallPrimary = facing.equals((Object)Direction.UP);
        this.ceilingPrimary = direction.equals((Object)Direction.DOWN);
        this.moonshotPrimary = false;
        ServerLevel portalLevel = level.getServer().getLevel(this.dimensionPrimary);
        if (portalLevel != null) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)portalLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new ClientboundPortalSoundsPacket.OpenPortal(this.linkID, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        PortalLinkData.get(level).setDirty(this.linkID, true);
    }

    public void createSecondaryPortal(Level level, BlockPos pos, ResourceKey<Level> dimension, Direction direction, Direction facing) {
        this.posSecondary = pos;
        this.dimensionSecondary = dimension;
        this.directionSecondary = facing.equals((Object)Direction.UP) ? direction : facing;
        this.wallSecondary = facing.equals((Object)Direction.UP);
        this.ceilingSecondary = direction.equals((Object)Direction.DOWN);
        this.moonshotSecondary = false;
        ServerLevel portalLevel = level.getServer().getLevel(this.dimensionSecondary);
        if (portalLevel != null) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)portalLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new ClientboundPortalSoundsPacket.OpenPortal(this.linkID, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        PortalLinkData.get(level).setDirty(this.linkID, false);
    }

    public void updateColors(Level level, int primaryPortalColor, int secondaryPortalColor) {
        if (this.primaryPortalColor != primaryPortalColor) {
            this.primaryPortalColor = primaryPortalColor;
            PortalLinkData.get(level).setDirty(this.linkID, true);
        }
        if (this.secondaryPortalColor != secondaryPortalColor) {
            this.secondaryPortalColor = secondaryPortalColor;
            PortalLinkData.get(level).setDirty(this.linkID, false);
        }
    }

    public void updateVariant(Level level, ResourceLocation variantKey) {
        if (this.variantKey != variantKey) {
            this.variantKey = variantKey;
            PortalLinkData.get(level).setDirty(this.linkID, true);
            PortalLinkData.get(level).setDirty(this.linkID, false);
        }
    }

    public void reset(Level level) {
        if (this.posPrimary != null || this.moonshotPrimary) {
            this.resetPrimary(level);
        }
        if (this.posSecondary != null || this.moonshotSecondary) {
            this.resetSecondary(level);
        }
    }

    public void resetPrimary(Level level) {
        ServerLevel portalLevel;
        if (this.posPrimary != null && (portalLevel = level.getServer().getLevel(this.dimensionPrimary)) != null) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)portalLevel, (ChunkPos)new ChunkPos(this.posPrimary), (CustomPacketPayload)new ClientboundPortalSoundsPacket.FizzlePortal(this.linkID, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.posPrimary = null;
        this.wallPrimary = false;
        this.ceilingPrimary = false;
        this.dimensionPrimary = null;
        this.directionPrimary = null;
        this.moonshotPrimary = false;
        PortalLinkData.get(level).setDirty(this.linkID, true);
    }

    public void resetSecondary(Level level) {
        ServerLevel portalLevel;
        if (this.posSecondary != null && (portalLevel = level.getServer().getLevel(this.dimensionSecondary)) != null) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)portalLevel, (ChunkPos)new ChunkPos(this.posSecondary), (CustomPacketPayload)new ClientboundPortalSoundsPacket.FizzlePortal(this.linkID, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.posSecondary = null;
        this.wallSecondary = false;
        this.ceilingSecondary = false;
        this.dimensionSecondary = null;
        this.directionSecondary = null;
        this.moonshotSecondary = false;
        PortalLinkData.get(level).setDirty(this.linkID, false);
    }

    public void setMoonshot(boolean isPrimary, boolean moonshot, Level level) {
        if (isPrimary) {
            this.posPrimary = null;
            this.moonshotPrimary = moonshot;
        } else {
            this.posSecondary = null;
            this.moonshotSecondary = moonshot;
        }
        PortalLinkData.get(level).setDirty(this.linkID, isPrimary);
    }

    public boolean isOpen() {
        return !(this.posPrimary == null && !this.moonshotPrimary || this.posSecondary == null && !this.moonshotSecondary);
    }

    public boolean isInterdimensionalLink() {
        if (this.posPrimary == null || this.posSecondary == null) {
            return false;
        }
        return this.dimensionPrimary != this.dimensionSecondary;
    }

    public static PortalLink load(CompoundTag tag) {
        UUID linkID = tag.getUUID("link");
        BlockPos posPrimary = null;
        boolean wallPrimary = false;
        boolean ceilingPrimary = false;
        ResourceKey<Level> dimensionPrimary = null;
        Direction directionPrimary = null;
        int openingPrimary = 0;
        if (tag.contains("posPrimary")) {
            posPrimary = NbtUtils.readBlockPos((CompoundTag)tag, (String)"posPrimary").orElse(null);
            wallPrimary = tag.getBoolean("wallPrimary");
            ceilingPrimary = tag.getBoolean("ceilingPrimary");
            dimensionPrimary = PortalLink.stringToDimension(tag.getString("dimensionPrimary"));
            directionPrimary = Direction.from3DDataValue((int)tag.getInt("directionPrimary"));
            openingPrimary = tag.getInt("openingPrimary");
        }
        BlockPos posSecondary = null;
        boolean wallSecondary = false;
        boolean ceilingSecondary = false;
        ResourceKey<Level> dimensionSecondary = null;
        Direction directionSecondary = null;
        int openingSecondary = 0;
        if (tag.contains("posSecondary")) {
            posSecondary = NbtUtils.readBlockPos((CompoundTag)tag, (String)"posSecondary").orElse(null);
            wallSecondary = tag.getBoolean("wallSecondary");
            ceilingSecondary = tag.getBoolean("ceilingSecondary");
            dimensionSecondary = PortalLink.stringToDimension(tag.getString("dimensionSecondary"));
            directionSecondary = Direction.from3DDataValue((int)tag.getInt("directionSecondary"));
            openingSecondary = tag.getInt("openingSecondary");
        }
        ResourceLocation variantKey = ResourceLocation.parse((String)tag.getString("variantKey"));
        int primaryPortalColor = tag.getInt("primaryPortalColor");
        int secondaryPortalColor = tag.getInt("secondaryPortalColor");
        PortalLink link = new PortalLink(linkID, posPrimary, posSecondary, wallPrimary, wallSecondary, ceilingPrimary, ceilingSecondary, dimensionPrimary, dimensionSecondary, directionPrimary, directionSecondary, variantKey, primaryPortalColor, secondaryPortalColor);
        return link;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("link", this.linkID);
        if (this.posPrimary != null) {
            tag.put("posPrimary", NbtUtils.writeBlockPos((BlockPos)this.posPrimary));
            tag.putBoolean("wallPrimary", this.wallPrimary);
            tag.putBoolean("ceilingPrimary", this.ceilingPrimary);
            tag.putString("dimensionPrimary", this.dimensionPrimary.location().toString());
            tag.putInt("directionPrimary", this.directionPrimary.get3DDataValue());
        }
        if (this.posSecondary != null) {
            tag.put("posSecondary", NbtUtils.writeBlockPos((BlockPos)this.posSecondary));
            tag.putBoolean("wallSecondary", this.wallSecondary);
            tag.putBoolean("ceilingSecondary", this.ceilingSecondary);
            tag.putString("dimensionSecondary", this.dimensionSecondary.location().toString());
            tag.putInt("directionSecondary", this.directionSecondary.get3DDataValue());
        }
        if (this.variantKey == null) {
            this.variantKey = ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"chell");
        }
        tag.putString("variantKey", this.variantKey.toString());
        tag.putInt("primaryPortalColor", this.primaryPortalColor);
        tag.putInt("secondaryPortalColor", this.secondaryPortalColor);
        return tag;
    }

    public PortalGunVariant getGunVariant(Level level) {
        Registry registry = level.getServer().registryAccess().registryOrThrow(PortalGunVariant.REGISTRY_KEY);
        return (PortalGunVariant)registry.get(this.variantKey);
    }

    public static ResourceKey<Level> stringToDimension(String dimensionString) {
        String[] split = dimensionString.split(":");
        if (split.length > 1) {
            return ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dimension")), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)split[0], (String)split[1]));
        }
        return null;
    }
}

