/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.portal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.mistersecret312.aperture_innovations.datapack.PortalGunVariant;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.network.ClientBoundPortalSyncPacket;
import net.mistersecret312.aperture_innovations.portal.PortalLink;
import net.neoforged.neoforge.network.PacketDistributor;

public class PortalLinkData
extends SavedData {
    private static final String FILE_NAME = "aperture_innovations-portal_links";
    private static final String PORTAL_LINK = "portal_links";
    public HashMap<UUID, PortalLink> portalLinks = new HashMap();
    private MinecraftServer server;

    private CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.put(PORTAL_LINK, (Tag)this.serializePortalLinkData());
        return tag;
    }

    private CompoundTag serializePortalLinkData() {
        CompoundTag objectsTag = new CompoundTag();
        this.portalLinks.forEach((uuid, pad) -> objectsTag.put(uuid.toString(), (Tag)pad.save()));
        return objectsTag;
    }

    private void deserialize(CompoundTag tag) {
        this.deserializePortalLinkData(tag.getCompound(PORTAL_LINK));
    }

    private void deserializePortalLinkData(CompoundTag tag) {
        for (String key : tag.getAllKeys()) {
            this.portalLinks.put(UUID.fromString(key), PortalLink.load(tag.getCompound(key)));
        }
    }

    public void addFreshLink(UUID uuid) {
        Registry registry = this.server.registryAccess().registryOrThrow(PortalGunVariant.REGISTRY_KEY);
        List variants = registry.entrySet().stream().toList();
        ResourceLocation location = ((ResourceKey)((Map.Entry)variants.get(this.server.overworld().getRandom().nextInt(variants.size()))).getKey()).location();
        this.portalLinks.put(uuid, new PortalLink(uuid, location));
        this.setDirty(uuid, true);
        this.setDirty(uuid, false);
    }

    public PortalLink getLink(UUID uuid) {
        return this.portalLinks.get(uuid);
    }

    @Nullable
    public PortalLink getLink(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof PortalGunItem) {
            PortalGunItem portalGun = (PortalGunItem)item;
            return this.portalLinks.get(portalGun.getUUID(stack, true));
        }
        return null;
    }

    public void setDirty(UUID uuid, boolean isPrimary) {
        PortalLink link = this.portalLinks.get(uuid);
        if (isPrimary) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ClientBoundPortalSyncPacket(uuid, true, link.posPrimary, link.directionPrimary, link.wallPrimary, link.ceilingPrimary, link.dimensionPrimary, link.moonshotPrimary, link.variantKey, link.primaryPortalColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ClientBoundPortalSyncPacket(uuid, false, link.posSecondary, link.directionSecondary, link.wallSecondary, link.ceilingSecondary, link.dimensionSecondary, link.moonshotSecondary, link.variantKey, link.secondaryPortalColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.setDirty();
    }

    public void setDirty() {
        super.setDirty();
    }

    public PortalLinkData(MinecraftServer server) {
        this.server = server;
    }

    public static PortalLinkData create(MinecraftServer server) {
        return new PortalLinkData(server);
    }

    public static PortalLinkData load(MinecraftServer server, CompoundTag tag) {
        PortalLinkData data = PortalLinkData.create(server);
        data.server = server;
        data.deserialize(tag);
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag = this.serialize();
        return tag;
    }

    @Nonnull
    public static PortalLinkData get(Level level) {
        if (level.isClientSide()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return PortalLinkData.get(level.getServer());
    }

    public static SavedData.Factory<PortalLinkData> dataFactory(MinecraftServer server) {
        return new SavedData.Factory(() -> PortalLinkData.create(server), (tag, provider) -> PortalLinkData.load(server, tag));
    }

    @Nonnull
    public static PortalLinkData get(MinecraftServer server) {
        DimensionDataStorage storage = server.overworld().getDataStorage();
        return (PortalLinkData)storage.computeIfAbsent(PortalLinkData.dataFactory(server), FILE_NAME);
    }
}

