/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.portal;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;

public class PortalPlacement {
    public static Result getBestPlacement(Level level, BlockHitResult hit, Player player, UUID uuid, boolean isPrimary) {
        BlockPos hitPos = hit.getBlockPos();
        Direction face = hit.getDirection();
        Direction rotation = face.getAxis().isVertical() ? player.getDirection() : Direction.UP;
        BlockPos tryBottomPos = !face.getAxis().isVertical() ? hitPos.relative(rotation.getOpposite()) : (face.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE) ? hitPos.relative(rotation.getOpposite()) : hitPos.relative(rotation));
        if (PortalPlacement.isValidSpot(level, tryBottomPos, rotation, face, uuid, isPrimary)) {
            return new Result(tryBottomPos, rotation, face);
        }
        tryBottomPos = hitPos;
        if (face.getAxis().isVertical() && face.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE)) {
            tryBottomPos = hitPos;
        }
        if (PortalPlacement.isValidSpot(level, tryBottomPos, rotation, face, uuid, isPrimary)) {
            return new Result(tryBottomPos, rotation, face);
        }
        return null;
    }

    private static boolean isValidSpot(Level level, BlockPos bottomPos, Direction rotation, Direction face, UUID uuid, boolean isPrimary) {
        BlockPos topPos = face.getAxis().isVertical() ? (face.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE) ? bottomPos.relative(rotation) : bottomPos.relative(rotation.getOpposite())) : bottomPos.relative(rotation);
        BlockPos portalBottom = bottomPos.relative(face);
        BlockPos portalTop = topPos.relative(face);
        if (level.getBlockState(bottomPos).isAir() || level.getBlockState(topPos).isAir()) {
            return false;
        }
        if (!PortalPlacement.isReplaceable(level, portalBottom) || !PortalPlacement.isReplaceable(level, portalTop)) {
            return false;
        }
        if (!level.getBlockState(bottomPos).isFaceSturdy((BlockGetter)level, bottomPos, face) || !level.getBlockState(topPos).isFaceSturdy((BlockGetter)level, topPos, face)) {
            return false;
        }
        return !PortalPlacement.hasExistingPortal(level, portalBottom, uuid, isPrimary) && !PortalPlacement.hasExistingPortal(level, portalTop, uuid, isPrimary);
    }

    private static boolean isReplaceable(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.isAir() || state.canBeReplaced();
    }

    private static boolean hasExistingPortal(Level level, BlockPos pos, UUID uuid, boolean isPrimary) {
        AtomicBoolean found = new AtomicBoolean(false);
        PortalUtilities.getPortalLinks(level).forEach((entryID, portalLink) -> {
            for (int i = 0; i < 2; ++i) {
                boolean onCeiling;
                boolean onWall;
                Direction portalDirection;
                AABB portalBox;
                Vec3 portalPos;
                boolean entryPrimarity;
                boolean bl = entryPrimarity = i == 0;
                if (uuid.equals(entryID) && entryPrimarity == isPrimary || (portalPos = PortalUtilities.getPortalPos(level, entryID, entryPrimarity)) == null || !(portalBox = PortalUtilities.getPortalTeleportBox(portalPos, portalDirection = PortalUtilities.getPortalDirection(level, entryID, entryPrimarity), onWall = PortalUtilities.isPortalOnWall(level, entryID, entryPrimarity), onCeiling = PortalUtilities.isPortalOnCeiling(level, entryID, entryPrimarity))).intersects(new AABB(pos))) continue;
                found.set(true);
            }
        });
        return found.get();
    }

    public static class Result {
        public BlockPos bottomPos;
        public Direction rotation;
        public Direction facing;

        public Result(BlockPos pos, Direction rot, Direction face) {
            this.bottomPos = pos;
            this.rotation = rot;
            this.facing = face;
        }
    }
}

