/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.portal;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.mistersecret312.aperture_innovations.client.renderer.PortalRenderer;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.PortalLink;
import net.mistersecret312.aperture_innovations.portal.PortalLinkData;

public class PortalUtilities {
    public static HashMap<UUID, PortalLink> getPortalLinks(Level level) {
        if (level.isClientSide()) {
            return new HashMap<UUID, PortalLink>();
        }
        PortalLinkData data = PortalLinkData.get(level);
        return data.portalLinks;
    }

    public static HashMap<UUID, ClientPortalLink> getPortalLinks() {
        return PortalRenderer.LINKS;
    }

    public static Vec3 getPortalPos(Level level, UUID uuid, boolean isPrimary) {
        Direction direction;
        BlockPos portalPos;
        if (level.isClientSide()) {
            Direction direction2;
            BlockPos portalPos2;
            ClientPortalLink link = PortalUtilities.getPortalLinks().get(uuid);
            if (isPrimary) {
                portalPos2 = link.posPrimary();
                direction2 = link.directionPrimary();
            } else {
                portalPos2 = link.posSecondary();
                direction2 = link.directionSecondary();
            }
            if (portalPos2 == null) {
                return null;
            }
            return portalPos2.getCenter().add(Vec3.atLowerCornerOf((Vec3i)direction2.getNormal()).multiply(0.5, 0.5, 0.5).add(0.0, 0.5, 0.0));
        }
        PortalLink link = PortalUtilities.getPortalLinks(level).get(uuid);
        if (isPrimary) {
            portalPos = link.posPrimary;
            direction = link.directionPrimary;
        } else {
            portalPos = link.posSecondary;
            direction = link.directionSecondary;
        }
        if (portalPos == null) {
            return null;
        }
        return portalPos.getCenter().add(Vec3.atLowerCornerOf((Vec3i)direction.getNormal()).multiply(0.5, 0.5, 0.5).add(0.0, 0.5, 0.0));
    }

    public static Direction getPortalDirection(Level level, UUID uuid, boolean isPrimary) {
        if (level.isClientSide()) {
            ClientPortalLink link = PortalUtilities.getPortalLinks().get(uuid);
            return isPrimary ? link.directionPrimary() : link.directionSecondary();
        }
        PortalLink link = PortalUtilities.getPortalLinks(level).get(uuid);
        return isPrimary ? link.directionPrimary : link.directionSecondary;
    }

    public static boolean isPortalOnWall(Level level, UUID uuid, boolean isPrimary) {
        if (level.isClientSide()) {
            ClientPortalLink link = PortalUtilities.getPortalLinks().get(uuid);
            return isPrimary ? link.wallPrimary() : link.wallSecondary();
        }
        PortalLink link = PortalUtilities.getPortalLinks(level).get(uuid);
        return isPrimary ? link.wallPrimary : link.wallSecondary;
    }

    public static boolean isPortalOpen(Level level, UUID uuid) {
        if (level.isClientSide()) {
            ClientPortalLink link = PortalUtilities.getPortalLinks().get(uuid);
            return link.isOpen();
        }
        PortalLink link = PortalUtilities.getPortalLinks(level).get(uuid);
        return link.isOpen();
    }

    public static boolean isPortalOnCeiling(Level level, UUID uuid, boolean isPrimary) {
        if (level.isClientSide()) {
            ClientPortalLink link = PortalUtilities.getPortalLinks().get(uuid);
            return isPrimary ? link.ceilingPrimary() : link.ceilingSecondary();
        }
        PortalLink link = PortalUtilities.getPortalLinks(level).get(uuid);
        return isPrimary ? link.ceilingPrimary : link.ceilingSecondary;
    }

    public static ResourceKey<Level> getPortalDimension(Level level, UUID uuid, boolean isPrimary) {
        if (level.isClientSide()) {
            ClientPortalLink link = PortalUtilities.getPortalLinks().get(uuid);
            return isPrimary ? link.dimensionPrimary() : link.dimensionSecondary();
        }
        PortalLink link = PortalUtilities.getPortalLinks(level).get(uuid);
        return isPrimary ? link.dimensionPrimary : link.dimensionSecondary;
    }

    public static AABB getPortalBoundingBox(Vec3 portalPos, Direction portalDirection, boolean isOnWall, boolean isOnCeiling) {
        AABB portal = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (isOnWall) {
            Direction.Axis axis = portalDirection.getAxis();
            portal = axis.equals((Object)Direction.Axis.X) ? new AABB(portalPos.x - 0.25, portalPos.y - 1.0, portalPos.z - 0.25, portalPos.x + 0.25, portalPos.y + 1.0, portalPos.z + 0.5) : new AABB(portalPos.x - 0.25, portalPos.y - 1.0, portalPos.z - 0.25, portalPos.x + 0.25, portalPos.y + 1.0, portalPos.z + 0.25);
        } else {
            portalPos = portalPos.subtract(Vec3.atLowerCornerOf((Vec3i)(isOnCeiling ? portalDirection.getNormal() : Vec3i.ZERO)));
            portalPos = portalPos.subtract(0.0, isOnCeiling ? 1.0 : 0.0, 0.0);
            Direction.Axis axis = portalDirection.getAxis();
            if (axis.equals((Object)Direction.Axis.X)) {
                portal = new AABB(portalPos.x - 1.0, portalPos.y - 0.25, portalPos.z - 0.25, portalPos.x + 1.0, portalPos.y + 0.25, portalPos.z + 0.5);
            } else if (axis.equals((Object)Direction.Axis.Z)) {
                portal = new AABB(portalPos.x - 0.25, portalPos.y - 0.25, portalPos.z - 1.0, portalPos.x + 0.25, portalPos.y + 0.25, portalPos.z + 1.0);
            }
            portal = isOnCeiling ? portal.expandTowards(0.0, 1.0, 0.0) : portal.expandTowards(0.0, -1.0, 0.0);
        }
        return portal;
    }

    public static AABB getPortalTeleportBox(Vec3 portalPos, Direction portalDirection, boolean isOnWall, boolean isOnCeiling) {
        AABB portal = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (isOnWall) {
            Direction.Axis axis = portalDirection.getAxis();
            portal = axis.equals((Object)Direction.Axis.X) ? new AABB(portalPos.x - 0.01, portalPos.y - 1.0, portalPos.z - 0.5, portalPos.x + 0.01, portalPos.y + 1.0, portalPos.z + 0.5) : new AABB(portalPos.x - 0.5, portalPos.y - 1.0, portalPos.z - 0.01, portalPos.x + 0.5, portalPos.y + 1.0, portalPos.z + 0.01);
        } else {
            portalPos = portalPos.subtract(Vec3.atLowerCornerOf((Vec3i)(isOnCeiling ? portalDirection.getNormal() : Vec3i.ZERO)));
            portalPos = portalPos.subtract(0.0, isOnCeiling ? 1.0 : 0.0, 0.0);
            Direction.Axis axis = portalDirection.getAxis();
            if (axis.equals((Object)Direction.Axis.X)) {
                portal = new AABB(portalPos.x - 0.95, portalPos.y - 0.01, portalPos.z - 0.5, portalPos.x + 0.95, portalPos.y + 0.01, portalPos.z + 0.5);
            } else if (axis.equals((Object)Direction.Axis.Z)) {
                portal = new AABB(portalPos.x - 0.5, portalPos.y - 0.01, portalPos.z - 0.95, portalPos.x + 0.5, portalPos.y + 0.01, portalPos.z + 0.95);
            }
            portal = isOnCeiling ? portal.expandTowards(0.0, 1.0, 0.0) : portal.expandTowards(0.0, -1.0, 0.0);
        }
        return portal;
    }

    public static AABB getPortalFloorBox(Vec3 portalPos, Direction direction, boolean isOnWall) {
        if (isOnWall) {
            return new AABB(portalPos.x - 0.25, portalPos.y - 1.0, portalPos.z - 0.25, portalPos.x + 0.25, portalPos.y - 1.0, portalPos.z + 0.25);
        }
        return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static Pair<UUID, Boolean> getClosestPortal(Entity entity) {
        UUID uuid = null;
        boolean isPrimary = false;
        double closestDistance = Double.MAX_VALUE;
        if (entity == null) {
            return Pair.of(uuid, (Object)isPrimary);
        }
        Level level = entity.level();
        if (level.isClientSide()) {
            for (Map.Entry<UUID, ClientPortalLink> entry : PortalUtilities.getPortalLinks().entrySet()) {
                for (int i = 0; i < 2; ++i) {
                    double distance;
                    Vec3 pos = PortalUtilities.getPortalPos(entity.level(), entry.getKey(), i == 0);
                    if (pos == null || !(closestDistance > (distance = entity.position().distanceTo(pos)))) continue;
                    closestDistance = distance;
                    uuid = entry.getKey();
                    isPrimary = i == 0;
                }
            }
            return Pair.of(uuid, (Object)isPrimary);
        }
        for (Map.Entry<UUID, PortalLink> entry : PortalUtilities.getPortalLinks(level).entrySet()) {
            for (int i = 0; i < 2; ++i) {
                double distance;
                Vec3 pos = PortalUtilities.getPortalPos(entity.level(), entry.getKey(), i == 0);
                if (pos == null || !(closestDistance > (distance = entity.position().distanceTo(pos)))) continue;
                closestDistance = distance;
                uuid = entry.getKey();
                isPrimary = i == 0;
            }
        }
        return Pair.of(uuid, (Object)isPrimary);
    }
}

