/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.recipes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.mistersecret312.aperture_innovations.init.RecipeInit;
import net.mistersecret312.aperture_innovations.items.ColorfulGelItem;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;

public class PortalGunColoringRecipe
extends CustomRecipe {
    public PortalGunColoringRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput container, Level level) {
        ItemStack itemstack = ItemStack.EMPTY;
        ItemStack itemStack2 = ItemStack.EMPTY;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < container.width(); ++i) {
            for (int j = 0; j < container.height(); ++j) {
                ItemStack itemstack1 = container.getItem(i, j);
                if (itemstack1.isEmpty()) continue;
                if (itemstack1.getItem() instanceof PortalGunItem) {
                    if (!itemstack.isEmpty()) {
                        if (!itemStack2.isEmpty()) {
                            return false;
                        }
                        itemStack2 = itemstack1;
                    }
                    itemstack = itemstack1;
                    continue;
                }
                if (!(itemstack1.getItem() instanceof ColorfulGelItem)) {
                    return false;
                }
                list.add(itemstack1);
            }
        }
        return !itemstack.isEmpty();
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider registryAccess) {
        ArrayList list = Lists.newArrayList();
        ItemStack gunItemStack = ItemStack.EMPTY;
        ItemStack secondGunStack = ItemStack.EMPTY;
        for (int i = 0; i < container.width(); ++i) {
            for (int j = 0; j < container.height(); ++j) {
                ItemStack itemstack1 = container.getItem(i, j);
                if (itemstack1.isEmpty()) continue;
                Item item = itemstack1.getItem();
                if (item instanceof PortalGunItem) {
                    if (!gunItemStack.isEmpty()) {
                        if (!secondGunStack.isEmpty()) {
                            return ItemStack.EMPTY;
                        }
                        secondGunStack = itemstack1.copy();
                        continue;
                    }
                    gunItemStack = itemstack1.copy();
                    continue;
                }
                if (!(item instanceof ColorfulGelItem)) {
                    return ItemStack.EMPTY;
                }
                list.add(itemstack1);
            }
        }
        PortalGunItem gunItem = (PortalGunItem)gunItemStack.getItem();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack gelStack = (ItemStack)list.get(i);
            ColorfulGelItem gel = (ColorfulGelItem)gelStack.getItem();
            if (i == 0) {
                gunItem.setPrimaryPortalColor(gunItemStack, gel.getColor(gelStack));
            }
            if (i == 1) {
                gunItem.setSecondaryPortalColor(gunItemStack, gel.getColor(gelStack));
            }
            if (i == 2) {
                gunItem.setPrimaryStripeColor(gunItemStack, gel.getColor(gelStack));
            }
            if (i != 3) continue;
            gunItem.setSecondaryStripeColor(gunItemStack, gel.getColor(gelStack));
        }
        if (list.isEmpty()) {
            int dualityState = gunItem.getDualityState(gunItemStack);
            ++dualityState;
            dualityState %= 3;
            if (gunItem.getPair(gunItemStack) == null && secondGunStack.isEmpty()) {
                gunItem.setDualityState(gunItemStack, dualityState);
            }
            gunItem.setPair(gunItemStack, null);
        }
        return gunItemStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput pContainer) {
        NonNullList nonnulllist = NonNullList.withSize((int)pContainer.size(), (Object)ItemStack.EMPTY);
        ItemStack portalGunStack = ItemStack.EMPTY;
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = pContainer.getItem(i);
            Item item2 = item.getItem();
            if (item2 instanceof PortalGunItem) {
                PortalGunItem gun = (PortalGunItem)item2;
                if (portalGunStack.isEmpty()) {
                    portalGunStack = item;
                    continue;
                }
                UUID pairID = gun.getUUID(portalGunStack, true);
                gun.setPair(item, pairID);
                nonnulllist.set(i, (Object)item.copy());
                continue;
            }
            if (!item.hasCraftingRemainingItem()) continue;
            nonnulllist.set(i, (Object)item.getCraftingRemainingItem());
        }
        return nonnulllist;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeInit.GUN_COLORING.get();
    }
}

