/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.sounds;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;

public class PortalSound<T extends ClientPortalLink>
extends AbstractTickableSoundInstance {
    protected T link;
    protected BlockPos portalPos;
    protected Minecraft minecraft = Minecraft.getInstance();
    protected int fullDistance;
    protected int maxDistance;

    public PortalSound(T link, boolean isPrimary, SoundEvent soundEvent, int fullDistance, int maxDistance) {
        super(soundEvent, SoundSource.AMBIENT, SoundInstance.createUnseededRandom());
        this.link = link;
        BlockPos blockPos = this.portalPos = isPrimary ? ((ClientPortalLink)link).posPrimary() : ((ClientPortalLink)link).posSecondary();
        if (this.portalPos == null) {
            this.portalPos = this.minecraft.player.getOnPos();
        }
        this.relative = true;
        this.fullDistance = fullDistance;
        this.maxDistance = maxDistance;
    }

    public void tick() {
        if (this.link == null || this.portalPos == null) {
            this.stop();
        }
    }

    public boolean canStartSilent() {
        return true;
    }

    public void stopSound() {
        this.stop();
    }

    public double getDistanceFromSource() {
        LocalPlayer player = this.minecraft.player;
        Vec3 playerPos = player.position();
        return this.portalPos.getCenter().distanceTo(playerPos);
    }

    public float getVolume() {
        float localVolume = 0.0f;
        double distanceFromSource = this.getDistanceFromSource();
        float fullDistance = this.fullDistance;
        float maxDistance = this.maxDistance;
        if (fullDistance >= maxDistance) {
            maxDistance = fullDistance + 1.0f;
        }
        if (fullDistance >= maxDistance) {
            maxDistance = fullDistance + 1.0f;
        }
        localVolume = distanceFromSource <= (double)fullDistance ? this.getMaxVolume() : (distanceFromSource <= (double)maxDistance ? (float)((double)this.getMaxVolume() - (distanceFromSource - (double)fullDistance) / (double)(maxDistance - fullDistance)) : this.getMinVolume());
        return super.getVolume() * localVolume;
    }

    public float getMaxVolume() {
        return 1.0f;
    }

    public float getMinVolume() {
        return 0.0f;
    }
}

