/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.sounds;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.mistersecret312.aperture_innovations.client.resourcepack.ClientPortalGunVariant;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.ClientPortalUtilities;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;
import net.mistersecret312.aperture_innovations.sounds.GenericGunSound;
import net.mistersecret312.aperture_innovations.sounds.GenericPortalSound;
import net.mistersecret312.aperture_innovations.sounds.PortalSoundWrapper;

public class SoundAccess {
    protected static Minecraft minecraft = Minecraft.getInstance();

    public static void playPortalAmbient(UUID uuid, boolean isPrimary, boolean stop) {
        ClientPortalLink link = PortalUtilities.getPortalLinks().get(uuid);
        if (SoundAccess.minecraft.level.dimension() != PortalUtilities.getPortalDimension((Level)SoundAccess.minecraft.level, uuid, isPrimary)) {
            return;
        }
        PortalSoundWrapper.PortalAmbient ambientSound = ClientPortalUtilities.getAmbientSound(uuid, isPrimary);
        if (link.isOpen() && PortalUtilities.getPortalPos((Level)SoundAccess.minecraft.level, uuid, isPrimary) != null) {
            BlockPos portalPos;
            if (ambientSound == null) {
                ambientSound = new PortalSoundWrapper.PortalAmbient(link, isPrimary);
                ClientPortalUtilities.setAmbientSound(ambientSound, uuid, isPrimary);
            }
            BlockPos blockPos = portalPos = isPrimary ? link.posPrimary() : link.posSecondary();
            if (!portalPos.equals((Object)ambientSound.sound.portalPos)) {
                ambientSound.stopSound();
                ambientSound = new PortalSoundWrapper.PortalAmbient(link, isPrimary);
                ClientPortalUtilities.setAmbientSound(ambientSound, uuid, isPrimary);
            }
            if (stop) {
                ambientSound.stopSound();
            } else if (!ambientSound.isPlaying()) {
                ambientSound.playSound();
            }
        }
    }

    public static void playOpenPortalSound(UUID linkID, boolean isPrimary) {
        if (SoundAccess.minecraft.level.dimension() != PortalUtilities.getPortalDimension((Level)SoundAccess.minecraft.level, linkID, isPrimary)) {
            return;
        }
        GenericPortalSound sound = new GenericPortalSound(PortalUtilities.getPortalLinks().get(linkID), isPrimary, SoundAccess.getPortalOpenSound(linkID, isPrimary), 5, 10, 0.35f);
        ClientPortalUtilities.setPortalOpeningAnimationProgress(0.0f, linkID, isPrimary);
        minecraft.getSoundManager().play((SoundInstance)sound);
    }

    public static void playEnterPortalSound(UUID linkID, boolean isPrimary) {
        if (SoundAccess.minecraft.level.dimension() != PortalUtilities.getPortalDimension((Level)SoundAccess.minecraft.level, linkID, isPrimary)) {
            return;
        }
        GenericPortalSound sound = new GenericPortalSound(PortalUtilities.getPortalLinks().get(linkID), isPrimary, SoundAccess.getEnterPortalSound(linkID, isPrimary), 5, 10, 0.35f);
        minecraft.getSoundManager().play((SoundInstance)sound);
    }

    public static void playFizzlePortalSound(UUID linkID, boolean isPrimary) {
        if (SoundAccess.minecraft.level.dimension() != PortalUtilities.getPortalDimension((Level)SoundAccess.minecraft.level, linkID, isPrimary)) {
            return;
        }
        GenericPortalSound sound = new GenericPortalSound(PortalUtilities.getPortalLinks().get(linkID), isPrimary, SoundAccess.getFizzlePortalSound(linkID, isPrimary), 5, 10, 0.35f);
        ClientPortalUtilities.setPortalOpeningAnimationProgress(0.0f, linkID, isPrimary);
        minecraft.getSoundManager().play((SoundInstance)sound);
        SoundAccess.playPortalAmbient(linkID, isPrimary, true);
    }

    public static void playInvalidSurfaceSound(UUID linkID, BlockPos pos, boolean isPrimary) {
        GenericGunSound sound = new GenericGunSound(PortalUtilities.getPortalLinks().get(linkID), pos, isPrimary, SoundAccess.getInvalidSurfaceSound(linkID, isPrimary), 5, 10, 0.35f);
        minecraft.getSoundManager().play((SoundInstance)sound);
    }

    public static void playGunActivateSound(UUID linkID, BlockPos pos, boolean isPrimary) {
        GenericGunSound sound = new GenericGunSound(PortalUtilities.getPortalLinks().get(linkID), pos, isPrimary, SoundAccess.getGunActivateSound(linkID), 5, 10, 0.35f);
        minecraft.getSoundManager().play((SoundInstance)sound);
    }

    public static void playShootPortalSound(UUID linkID, BlockPos pos, boolean isPrimary) {
        GenericGunSound sound = new GenericGunSound(PortalUtilities.getPortalLinks().get(linkID), pos, isPrimary, SoundAccess.getShotPortalSound(linkID, isPrimary), 5, 10, 0.35f);
        minecraft.getSoundManager().play((SoundInstance)sound);
    }

    public static void playResetPortalSound(UUID linkID, BlockPos pos, boolean isPrimary) {
        GenericGunSound sound = new GenericGunSound(PortalUtilities.getPortalLinks().get(linkID), pos, isPrimary, SoundAccess.getGunResetSound(linkID), 5, 10, 0.35f);
        minecraft.getSoundManager().play((SoundInstance)sound);
    }

    public static SoundEvent getPortalAmbient(UUID uuid, boolean isPrimary) {
        ClientPortalGunVariant variant = PortalUtilities.getPortalLinks().get(uuid).getVariant();
        if (isPrimary) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.primaryPortal().getAmbientSound());
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.secondaryPortal().getAmbientSound());
    }

    public static SoundEvent getPortalOpenSound(UUID uuid, boolean isPrimary) {
        ClientPortalGunVariant variant = PortalUtilities.getPortalLinks().get(uuid).getVariant();
        if (isPrimary) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.primaryPortal().getOpeningSound());
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.secondaryPortal().getOpeningSound());
    }

    public static SoundEvent getEnterPortalSound(UUID uuid, boolean isPrimary) {
        ClientPortalGunVariant variant = PortalUtilities.getPortalLinks().get(uuid).getVariant();
        if (isPrimary) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.primaryPortal().getEnterSound());
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.secondaryPortal().getEnterSound());
    }

    public static SoundEvent getFizzlePortalSound(UUID uuid, boolean isPrimary) {
        ClientPortalGunVariant variant = PortalUtilities.getPortalLinks().get(uuid).getVariant();
        if (isPrimary) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.primaryPortal().getFizzleSound());
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.secondaryPortal().getFizzleSound());
    }

    public static SoundEvent getInvalidSurfaceSound(UUID uuid, boolean isPrimary) {
        ClientPortalGunVariant variant = PortalUtilities.getPortalLinks().get(uuid).getVariant();
        if (isPrimary) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.primaryPortal().getInvalidSurfaceSound());
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.secondaryPortal().getInvalidSurfaceSound());
    }

    public static SoundEvent getGunActivateSound(UUID uuid) {
        ClientPortalGunVariant variant = PortalUtilities.getPortalLinks().get(uuid).getVariant();
        return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.activationSound());
    }

    public static SoundEvent getShotPortalSound(UUID uuid, boolean isPrimary) {
        ClientPortalGunVariant variant = PortalUtilities.getPortalLinks().get(uuid).getVariant();
        if (isPrimary) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.primaryPortal().getShotSound());
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.secondaryPortal().getShotSound());
    }

    public static SoundEvent getGunResetSound(UUID uuid) {
        ClientPortalGunVariant variant = PortalUtilities.getPortalLinks().get(uuid).getVariant();
        return SoundEvent.createVariableRangeEvent((ResourceLocation)variant.resetSound());
    }
}

