/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.mistersecret312.aperture_innovations.Config;
import net.mistersecret312.aperture_innovations.client.Layers;
import net.mistersecret312.aperture_innovations.client.overlay.CrosshairOverlay;
import net.mistersecret312.aperture_innovations.client.resourcepack.ResourcePackReloadListener;
import net.mistersecret312.aperture_innovations.datapack.PortalGunVariant;
import net.mistersecret312.aperture_innovations.init.AdvancementInit;
import net.mistersecret312.aperture_innovations.init.BlockInit;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.init.ItemTabInit;
import net.mistersecret312.aperture_innovations.init.NetworkInit;
import net.mistersecret312.aperture_innovations.init.RecipeInit;
import net.mistersecret312.aperture_innovations.init.SoundInit;
import net.mistersecret312.aperture_innovations.init.StatisticsInit;
import net.mistersecret312.aperture_innovations.items.ColorfulGelItem;
import net.mistersecret312.aperture_innovations.items.ColorfulGelItemProperty;
import org.slf4j.Logger;

@Mod(value="aperture_innovations")
public class ApertureInnovations {
    public static final String MODID = "aperture_innovations";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final TagKey<Block> SHOOT_THROUGH = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation("aperture_innovations", "shoot_through"));
    public static final TagKey<Block> IMPORTALABLE = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation("aperture_innovations", "importalable"));
    public static final TagKey<Block> PORTALABLE = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation("aperture_innovations", "portalable"));

    public ApertureInnovations() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ItemInit.register(modEventBus);
        BlockInit.register(modEventBus);
        ItemTabInit.register(modEventBus);
        SoundInit.register(modEventBus);
        StatisticsInit.register(modEventBus);
        RecipeInit.register(modEventBus);
        AdvancementInit.register();
        modEventBus.addListener(Layers::registerLayers);
        modEventBus.addListener(event -> event.dataPackRegistry(PortalGunVariant.REGISTRY_KEY, PortalGunVariant.CODEC, PortalGunVariant.CODEC));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG, "aperture_innovations-common.toml");
        NetworkInit.register();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @Mod.EventBusSubscriber(modid="aperture_innovations", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        public static final Lazy<KeyMapping> RESET_PORTAL_GUN = Lazy.of(() -> new KeyMapping("aperture_innovations.portal_gun.reset", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 82, "key.category.aperture_innovations"));

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ItemProperties.register((Item)((Item)ItemInit.COLORFUL_GEL.get()), (ResourceLocation)new ResourceLocation(ApertureInnovations.MODID, "colored"), (ItemPropertyFunction)new ColorfulGelItemProperty()));
        }

        @SubscribeEvent
        public static void registerClientReload(RegisterClientReloadListenersEvent event) {
            ResourcePackReloadListener.ReloadListener.registerReloadListener(event);
        }

        @SubscribeEvent
        public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
            ColorfulGelItem gelItem = (ColorfulGelItem)((Object)ItemInit.COLORFUL_GEL.get());
            event.register((stack, color) -> color != 1 ? -1 : gelItem.getColor(stack), new ItemLike[]{(ItemLike)ItemInit.COLORFUL_GEL.get()});
        }

        @SubscribeEvent
        public static void registerKeybindings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)RESET_PORTAL_GUN.get());
        }

        @SubscribeEvent
        public static void registerOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("portal_crosshair", CrosshairOverlay.OVERLAY);
        }
    }
}

