/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;

public class NearPortalDeathCriterion
extends SimpleCriterionTrigger<NearPortalDeathTrigger> {
    public static final NearPortalDeathCriterion INSTANCE = new NearPortalDeathCriterion();
    public static final ResourceLocation CRITERION_ID = new ResourceLocation("aperture_innovations", "near_portal_death");

    protected NearPortalDeathTrigger createInstance(JsonObject obj, ContextAwarePredicate playerPredicate, DeserializationContext predicateDeserializer) {
        Optional<Long> distanceToPortal = Optional.empty();
        Optional<Boolean> isFloor = Optional.empty();
        if (GsonHelper.m_144762_((JsonObject)obj, (String)"distance")) {
            distanceToPortal = Optional.of(GsonHelper.m_13921_((JsonObject)obj, (String)"distance"));
        }
        if (GsonHelper.m_13880_((JsonObject)obj, (String)"isFloor")) {
            isFloor = Optional.of(GsonHelper.m_13912_((JsonObject)obj, (String)"isFloor"));
        }
        return new NearPortalDeathTrigger(playerPredicate, distanceToPortal, isFloor);
    }

    public void trigger(ServerPlayer player, long distanceToPortal, boolean isFloor) {
        this.m_66234_(player, trigger -> trigger.matches(distanceToPortal, isFloor));
    }

    public ResourceLocation m_7295_() {
        return CRITERION_ID;
    }

    public static class NearPortalDeathTrigger
    extends AbstractCriterionTriggerInstance {
        private final Optional<Long> distanceToPortal;
        private final Optional<Boolean> isFloor;

        public NearPortalDeathTrigger(ContextAwarePredicate entity, Optional<Long> distanceToPortal, Optional<Boolean> isFloor) {
            super(CRITERION_ID, entity);
            this.isFloor = isFloor;
            this.distanceToPortal = distanceToPortal;
        }

        public boolean matches(long distanceToPortal, boolean isFloor) {
            if (this.distanceToPortal.isPresent() && this.distanceToPortal.get() < distanceToPortal) {
                return false;
            }
            return !this.isFloor.isPresent() || this.isFloor.get() == isFloor;
        }

        public JsonObject m_7683_(SerializationContext predicateSerializer) {
            JsonObject jsonObject = super.m_7683_(predicateSerializer);
            if (this.distanceToPortal.isPresent()) {
                jsonObject.add("distance", (JsonElement)new JsonPrimitive((Number)this.distanceToPortal.get()));
            }
            if (this.isFloor.isPresent()) {
                jsonObject.add("floor", (JsonElement)new JsonPrimitive(this.isFloor.get()));
            }
            return jsonObject;
        }
    }
}

