/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;

public class PortalTravelCriterion
extends SimpleCriterionTrigger<PortalTravelTrigger> {
    public static final PortalTravelCriterion INSTANCE = new PortalTravelCriterion();
    public static final ResourceLocation CRITERION_ID = new ResourceLocation("aperture_innovations", "portal_travel");

    protected PortalTravelTrigger createInstance(JsonObject obj, ContextAwarePredicate playerPredicate, DeserializationContext predicateDeserializer) {
        Optional<ResourceLocation> initialDimension = Optional.empty();
        Optional<ResourceLocation> destinationDimension = Optional.empty();
        Optional<Long> teleportDistance = Optional.empty();
        Optional<Long> verticalFlight = Optional.empty();
        Optional<Long> horizontalJump = Optional.empty();
        Optional<Boolean> lunacy = Optional.empty();
        if (GsonHelper.m_13813_((JsonObject)obj, (String)"from")) {
            initialDimension = Optional.of(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"from")));
        }
        if (GsonHelper.m_13813_((JsonObject)obj, (String)"to")) {
            destinationDimension = Optional.of(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"to")));
        }
        if (GsonHelper.m_144762_((JsonObject)obj, (String)"distance")) {
            teleportDistance = Optional.of(GsonHelper.m_13921_((JsonObject)obj, (String)"distance"));
        }
        if (GsonHelper.m_144762_((JsonObject)obj, (String)"flight")) {
            verticalFlight = Optional.of(GsonHelper.m_13921_((JsonObject)obj, (String)"flight"));
        }
        if (GsonHelper.m_144762_((JsonObject)obj, (String)"jump")) {
            horizontalJump = Optional.of(GsonHelper.m_13921_((JsonObject)obj, (String)"jump"));
        }
        if (GsonHelper.m_13880_((JsonObject)obj, (String)"lunacy")) {
            lunacy = Optional.of(GsonHelper.m_13912_((JsonObject)obj, (String)"lunacy"));
        }
        return new PortalTravelTrigger(playerPredicate, initialDimension, destinationDimension, teleportDistance, horizontalJump, verticalFlight, lunacy);
    }

    public void trigger(ServerPlayer player, ResourceLocation initialDimension, ResourceLocation destinationDimension, long teleportDistance, long verticalFlight, long horizontalJump, boolean lunacy) {
        this.m_66234_(player, trigger -> trigger.matches(initialDimension, destinationDimension, teleportDistance, horizontalJump, verticalFlight, lunacy));
    }

    public ResourceLocation m_7295_() {
        return CRITERION_ID;
    }

    public static class PortalTravelTrigger
    extends AbstractCriterionTriggerInstance {
        private final Optional<ResourceLocation> initialDimension;
        private final Optional<ResourceLocation> destinationDimension;
        private final Optional<Long> teleportDistance;
        private final Optional<Long> horizontalJump;
        private final Optional<Long> verticalFlight;
        private final Optional<Boolean> lunacy;

        public PortalTravelTrigger(ContextAwarePredicate entity, Optional<ResourceLocation> initialDimension, Optional<ResourceLocation> destinationDimension, Optional<Long> teleportDistance, Optional<Long> horizontalJump, Optional<Long> verticalFlight, Optional<Boolean> lunacy) {
            super(CRITERION_ID, entity);
            this.initialDimension = initialDimension;
            this.destinationDimension = destinationDimension;
            this.teleportDistance = teleportDistance;
            this.horizontalJump = horizontalJump;
            this.verticalFlight = verticalFlight;
            this.lunacy = lunacy;
        }

        public boolean matches(ResourceLocation initialDimension, ResourceLocation destinationDimension, long teleportDistance, long horizontalJump, long verticalFlight, boolean lunacy) {
            if (this.initialDimension.isPresent() && !Objects.equals(this.initialDimension.get(), initialDimension)) {
                return false;
            }
            if (this.destinationDimension.isPresent() && !Objects.equals(this.destinationDimension.get(), destinationDimension)) {
                return false;
            }
            if (this.teleportDistance.isPresent() && this.teleportDistance.get() > teleportDistance) {
                return false;
            }
            if (this.horizontalJump.isPresent() && this.horizontalJump.get() > horizontalJump) {
                return false;
            }
            if (this.verticalFlight.isPresent() && this.verticalFlight.get() > verticalFlight) {
                return false;
            }
            return !this.lunacy.isPresent() || this.lunacy.get() == lunacy;
        }

        public JsonObject m_7683_(SerializationContext predicateSerializer) {
            JsonObject jsonObject = super.m_7683_(predicateSerializer);
            if (this.initialDimension.isPresent()) {
                jsonObject.add("from", (JsonElement)new JsonPrimitive(this.initialDimension.get().toString()));
            }
            if (this.destinationDimension.isPresent()) {
                jsonObject.add("to", (JsonElement)new JsonPrimitive(this.destinationDimension.get().toString()));
            }
            if (this.teleportDistance.isPresent()) {
                jsonObject.add("distance", (JsonElement)new JsonPrimitive((Number)this.teleportDistance.get()));
            }
            if (this.horizontalJump.isPresent()) {
                jsonObject.add("distance", (JsonElement)new JsonPrimitive((Number)this.horizontalJump.get()));
            }
            if (this.verticalFlight.isPresent()) {
                jsonObject.add("distance", (JsonElement)new JsonPrimitive((Number)this.verticalFlight.get()));
            }
            if (this.lunacy.isPresent()) {
                jsonObject.add("lunacy", (JsonElement)new JsonPrimitive(this.lunacy.get()));
            }
            return jsonObject;
        }
    }
}

