/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.capabilities;

import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.PacketDistributor;
import net.mistersecret312.aperture_innovations.init.NetworkInit;
import net.mistersecret312.aperture_innovations.network.ClientboundApertureCapabilityPacket;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ApertureCapability
implements INBTSerializable<CompoundTag> {
    public Vector3d distanceVec;
    public Pair<UUID, Boolean> portal;
    public double horizontalDistance;
    public double verticalDistance;
    public int frictionlessTime = 0;

    public void tick(Level level, LivingEntity living) {
        if (level.m_5776_()) {
            return;
        }
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            NetworkInit.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundApertureCapabilityPacket(this.frictionlessTime));
        }
        if (this.frictionlessTime > 0) {
            --this.frictionlessTime;
        }
        if (living.m_20096_() || living.m_21255_()) {
            this.portal = null;
            this.distanceVec = new Vector3d();
            this.horizontalDistance = 0.0;
            this.verticalDistance = 0.0;
            this.frictionlessTime = 0;
        } else if (this.portal != null) {
            Vec3 speed = living.m_20184_();
            Vector3f movementVector = new Vector3f(speed.f_82479_ > 0.0 ? (float)speed.f_82479_ : (float)(-speed.f_82479_), speed.f_82480_ > 0.0 ? (float)speed.f_82480_ : (float)(-speed.f_82480_), speed.f_82481_ > 0.0 ? (float)speed.f_82481_ : (float)(-speed.f_82481_));
            this.distanceVec.add((Vector3fc)movementVector);
        }
    }

    public void updateDistance() {
        if (this.portal == null || this.distanceVec == null) {
            return;
        }
        if (this.distanceVec.lengthSquared() > 0.0) {
            this.horizontalDistance += (double)Mth.m_14116_((float)((float)(Math.pow(this.distanceVec.x, 2.0) + Math.pow(this.distanceVec.z, 2.0))));
            this.verticalDistance += Math.sqrt(Math.pow(this.distanceVec.y, 2.0));
        }
        this.distanceVec = new Vector3d();
    }

    public void setFrictionlessTime(int frictionlessTime) {
        this.frictionlessTime = frictionlessTime;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag distanceTag = new CompoundTag();
        distanceTag.m_128347_("x", this.distanceVec.x);
        distanceTag.m_128347_("y", this.distanceVec.y);
        distanceTag.m_128347_("z", this.distanceVec.z);
        tag.m_128365_("distance", (Tag)distanceTag);
        tag.m_128347_("horizontal", this.horizontalDistance);
        tag.m_128347_("vertical", this.verticalDistance);
        tag.m_128405_("frictionlessTime", this.frictionlessTime);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        Vector3d distanceVec = new Vector3d();
        CompoundTag distanceTag = nbt.m_128469_("distance");
        distanceVec.x = distanceTag.m_128459_("x");
        distanceVec.y = distanceTag.m_128459_("y");
        distanceVec.z = distanceTag.m_128459_("z");
        this.distanceVec = distanceVec;
        this.horizontalDistance = nbt.m_128459_("horizontal");
        this.verticalDistance = nbt.m_128459_("vertical");
        this.frictionlessTime = nbt.m_128451_("frictionlessTime");
    }
}

