/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.capabilities.item;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.mistersecret312.aperture_innovations.capabilities.item.ItemEnergy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemEnergyProvider
implements ICapabilityProvider {
    private static final String ENERGY = "Energy";
    private ItemStack stack;
    private final ItemEnergy ENERGY_STORAGE = new ItemEnergy(this.capacity(), this.maxReceive(), this.maxExtract()){

        @Override
        public void reloadEnergy() {
            ItemEnergyProvider.this.loadEnergy();
        }

        @Override
        public boolean canReceive() {
            return super.canReceive() && ItemEnergyProvider.this.canReceiveEnergy();
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            ItemEnergyProvider.this.energyChanged(difference, simulate);
        }
    };
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);

    public ItemEnergyProvider(ItemStack stack) {
        this.stack = stack;
    }

    public abstract long capacity();

    public abstract long maxReceive();

    public abstract long maxExtract();

    public boolean canReceiveEnergy() {
        return this.stack.m_41613_() == 1;
    }

    public void energyChanged(long difference, boolean simulate) {
        this.saveEnergy();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return LazyOptional.empty();
    }

    public void loadEnergy() {
        if (!this.stack.m_41782_()) {
            return;
        }
        CompoundTag tag = this.stack.m_41783_();
        if (tag.m_128425_(ENERGY, 4)) {
            this.ENERGY_STORAGE.deserializeNBT(tag.m_128423_(ENERGY));
        }
    }

    public void saveEnergy() {
        if (this.ENERGY_STORAGE.getEnergyWithoutLoading() > 0L) {
            CompoundTag tag = this.stack.m_41784_();
            tag.m_128365_(ENERGY, this.ENERGY_STORAGE.serializeNBT());
            this.stack.m_41751_(tag);
        } else if (this.stack.m_41783_() != null && this.stack.m_41783_().m_128441_(ENERGY)) {
            this.stack.m_41749_(ENERGY);
        }
    }
}

