/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.mistersecret312.aperture_innovations.client.ColorUtil;
import net.mistersecret312.aperture_innovations.client.renderer.PortalRenderer;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.ClientPortalUtilities;

public class CrosshairOverlay {
    public static final IGuiOverlay OVERLAY = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        boolean hasPortalGun;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        if (!Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
            return;
        }
        if (player == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        boolean bl = hasPortalGun = main.m_150930_((Item)ItemInit.PORTAL_GUN.get()) || off.m_150930_((Item)ItemInit.PORTAL_GUN.get());
        if (!hasPortalGun) {
            return;
        }
        ItemStack gunStack = main.m_150930_((Item)ItemInit.PORTAL_GUN.get()) ? main : off;
        PortalGunItem portalGun = (PortalGunItem)gunStack.m_41720_();
        int dualityState = portalGun.getDualityState(gunStack);
        ClientPortalLink link = PortalRenderer.LINKS.get(portalGun.getUUID(gunStack, false));
        if (link != null) {
            boolean hasPrimary = link.posPrimary() != null || link.moonshotPrimary();
            boolean hasSecondary = link.posSecondary() != null || link.moonshotSecondary();
            ColorUtil.RGBA primaryColor = ClientPortalUtilities.getPortalColor(link, true);
            ColorUtil.RGBA secondaryColor = ClientPortalUtilities.getPortalColor(link, false);
            ResourceLocation primaryCrosshairTexture = ClientPortalUtilities.getCrosshairTexture(link, true);
            ResourceLocation secondaryCrosshairTexture = ClientPortalUtilities.getCrosshairTexture(link, false);
            int uOffsetPrimary = hasPrimary ? 0 : 51;
            int uOffsetSecondary = hasSecondary ? 34 : 17;
            poseStack.m_85836_();
            int x = (screenWidth - 17) / 2;
            int y = (screenHeight - 33) / 2;
            poseStack.m_252880_((float)x, (float)y, 0.0f);
            poseStack.m_85836_();
            if (dualityState == 1) {
                primaryCrosshairTexture = secondaryCrosshairTexture;
                primaryColor = secondaryColor;
                poseStack.m_252880_(17.0f, 33.0f, 0.0f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                uOffsetPrimary = uOffsetSecondary;
            }
            RenderSystem.setShaderColor((float)primaryColor.red(), (float)primaryColor.green(), (float)primaryColor.blue(), (float)primaryColor.alpha());
            guiGraphics.m_280163_(primaryCrosshairTexture, 0, 0, (float)uOffsetPrimary, 0.0f, 17, 33, 68, 33);
            poseStack.m_85849_();
            poseStack.m_85836_();
            if (dualityState == 0) {
                secondaryCrosshairTexture = primaryCrosshairTexture;
                secondaryColor = primaryColor;
                poseStack.m_252880_(17.0f, 33.0f, 0.0f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                uOffsetSecondary = uOffsetPrimary;
            }
            RenderSystem.setShaderColor((float)secondaryColor.red(), (float)secondaryColor.green(), (float)secondaryColor.blue(), (float)secondaryColor.alpha());
            guiGraphics.m_280163_(secondaryCrosshairTexture, 0, 0, (float)uOffsetSecondary, 0.0f, 17, 33, 68, 33);
            poseStack.m_85849_();
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    };
}

