/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.client.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.mistersecret312.aperture_innovations.client.ColorUtil;
import net.mistersecret312.aperture_innovations.client.renderer.geckolib.DynamicGeoItemRenderer;
import net.mistersecret312.aperture_innovations.client.resourcepack.ClientPortalGunVariant;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.ClientPortalUtilities;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.DefaultedItemGeoModel;

public class PortalGunRenderer
extends DynamicGeoItemRenderer<PortalGunItem> {
    public PortalGunRenderer() {
        super(new DefaultedItemGeoModel(new ResourceLocation("aperture_innovations", "portal_gun")));
    }

    @Override
    protected boolean boneRenderOverride(PoseStack poseStack, GeoBone bone, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ArrayList gunCore = Lists.newArrayList((Object[])new String[]{"CoreOuter", "CoreInner", "PortalLight", "Muzzle"});
        if (gunCore.contains(bone.getName())) {
            int portal = ((PortalGunItem)this.getAnimatable()).getLastShotPortal(this.currentItemStack);
            ClientPortalLink link = PortalUtilities.getPortalLinks().get(((PortalGunItem)this.getAnimatable()).getUUID(this.currentItemStack, false));
            if (portal == -1) {
                return super.boneRenderOverride(poseStack, bone, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            }
            ColorUtil.RGBA color = ClientPortalUtilities.getPortalColor(link, portal == 0);
            this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red *= color.red(), green *= color.green(), blue *= color.blue(), alpha *= color.alpha());
            return true;
        }
        if (bone.getName().equals("StripePrimary") || bone.getName().equals("StripeSecondary")) {
            int stripeColor;
            boolean isPrimary = bone.getName().equals("StripePrimary");
            int n = stripeColor = isPrimary ? ((PortalGunItem)this.getAnimatable()).getPrimaryStripeColor(this.currentItemStack) : ((PortalGunItem)this.getAnimatable()).getSecondaryStripeColor(this.currentItemStack);
            if (stripeColor == -1) {
                ColorUtil.RGBA color;
                ClientPortalLink link = PortalUtilities.getPortalLinks().get(((PortalGunItem)this.getAnimatable()).getUUID(this.currentItemStack, false));
                ClientPortalGunVariant variant = ClientPortalGunVariant.DEFAULT_VARIANT;
                if (link != null) {
                    variant = link.getVariant();
                }
                ColorUtil.RGBA rGBA = color = isPrimary ? variant.getPrimaryStripeColor() : variant.getSecondaryStripeColor();
                if (color.red() == 1.0f && color.green() == 1.0f && color.blue() == 1.0f && color.alpha() == 1.0f) {
                    return true;
                }
                this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red *= color.red(), green *= color.green(), blue *= color.blue(), alpha *= color.alpha());
                return true;
            }
            Color color = new Color(stripeColor, false);
            if (color.getRGB() == -1) {
                return true;
            }
            this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red *= (float)color.getRed() / 255.0f, green *= (float)color.getGreen() / 255.0f, blue *= (float)color.getBlue() / 255.0f, alpha);
            return true;
        }
        return super.boneRenderOverride(poseStack, bone, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    @Nullable
    protected RenderType getRenderTypeOverrideForBone(GeoBone bone, PortalGunItem animatable, ResourceLocation texturePath, MultiBufferSource bufferSource, float partialTick) {
        ArrayList gunCore = Lists.newArrayList((Object[])new String[]{"CoreOuter", "CoreInner", "PortalLight", "Muzzle"});
        if (gunCore.contains(bone.getName())) {
            return DynamicGeoItemRenderer.GLOWING_FUNCTION.apply(this.getTextureOverrideForBone(bone, animatable, partialTick));
        }
        return super.getRenderTypeOverrideForBone(bone, animatable, texturePath, bufferSource, partialTick);
    }

    @Override
    @Nullable
    protected ResourceLocation getTextureOverrideForBone(GeoBone bone, PortalGunItem animatable, float partialTick) {
        int portal = ((PortalGunItem)this.getAnimatable()).getLastShotPortal(this.currentItemStack);
        ClientPortalLink link = PortalUtilities.getPortalLinks().get(((PortalGunItem)this.getAnimatable()).getUUID(this.currentItemStack, false));
        if (link != null) {
            ArrayList gunCore = Lists.newArrayList((Object[])new String[]{"CoreOuter", "CoreInner", "PortalLight", "Muzzle"});
            if (gunCore.contains(bone.getName())) {
                return ClientPortalUtilities.getPortalGunCoreTexture(link, portal);
            }
            return ClientPortalUtilities.getPortalGunTexture(link);
        }
        return new ResourceLocation("aperture_innovations", "textures/item/portal_gun.png");
    }

    public RenderType getRenderType(PortalGunItem animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }
}

