/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.mistersecret312.aperture_innovations.client.ColorUtil;
import net.mistersecret312.aperture_innovations.client.PortalRenderTypes;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.ClientPortalUtilities;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class PortalRenderer {
    public static HashMap<UUID, ClientPortalLink> LINKS = new HashMap();

    public static void primaryRender(ClientPortalLink link, MultiBufferSource.BufferSource buffer, PoseStack poseStack, Camera camera, float scale) {
        if (link.posPrimary() != null) {
            poseStack.m_85836_();
            Vec3 pos = link.posPrimary().m_252807_();
            poseStack.m_85837_(-camera.m_90583_().f_82479_ + pos.f_82479_, -camera.m_90583_().f_82480_ + pos.f_82480_ + 0.5, -camera.m_90583_().f_82481_ + pos.f_82481_);
            poseStack.m_252781_(link.directionPrimary().m_253075_());
            if (link.wallPrimary()) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            } else {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(link.ceilingPrimary() ? 0.0f : 180.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252880_(0.0f, 0.5f, -0.5f);
                if (link.ceilingPrimary()) {
                    poseStack.m_252880_(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.m_85841_(scale, scale, 1.0f);
            poseStack.m_252880_(0.5f, 0.0f, 0.51f);
            PortalRenderer.renderPortalFrame(ClientPortalUtilities.getPortalClosedTexture(link, true), ClientPortalUtilities.getPortalColor(link, true), (MultiBufferSource)buffer, poseStack);
            poseStack.m_85849_();
        }
    }

    public static void secondaryRender(ClientPortalLink link, MultiBufferSource.BufferSource buffer, PoseStack poseStack, Camera camera, float scale) {
        if (link.posSecondary() != null) {
            poseStack.m_85836_();
            Vec3 pos = link.posSecondary().m_252807_();
            poseStack.m_85837_(-camera.m_90583_().f_82479_ + pos.f_82479_, -camera.m_90583_().f_82480_ + pos.f_82480_ + 0.5, -camera.m_90583_().f_82481_ + pos.f_82481_);
            poseStack.m_252781_(link.directionSecondary().m_253075_());
            if (link.wallSecondary()) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            } else {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(link.ceilingSecondary() ? 0.0f : 180.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252880_(0.0f, 0.5f, -0.5f);
                if (link.ceilingSecondary()) {
                    poseStack.m_252880_(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.m_85841_(scale, scale, 1.0f);
            poseStack.m_252880_(0.5f, 0.0f, 0.51f);
            PortalRenderer.renderPortalFrame(ClientPortalUtilities.getPortalClosedTexture(link, false), ClientPortalUtilities.getPortalColor(link, false), (MultiBufferSource)buffer, poseStack);
            poseStack.m_85849_();
        }
    }

    public static void renderPortalNonSee(MultiBufferSource buffer, PoseStack poseStack, Camera camera, ClientPortalLink link, boolean isPrimary, float scale) {
        poseStack.m_85836_();
        Vec3 pos = isPrimary ? link.posPrimary().m_252807_() : link.posSecondary().m_252807_();
        Direction direction = isPrimary ? link.directionPrimary() : link.directionSecondary();
        poseStack.m_85837_(pos.f_82479_ - camera.m_90583_().f_82479_, pos.f_82480_ - camera.m_90583_().f_82480_ + 0.5, pos.f_82481_ - camera.m_90583_().f_82481_);
        poseStack.m_252781_(direction.m_253075_());
        if (isPrimary) {
            if (link.wallPrimary()) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            } else {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(link.ceilingPrimary() ? 0.0f : 180.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252880_(0.0f, 0.5f, -0.5f);
                if (link.ceilingPrimary()) {
                    poseStack.m_252880_(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.m_252880_(0.5f, 0.0f, 0.52f);
        } else {
            if (link.wallSecondary()) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            } else {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(link.ceilingSecondary() ? 0.0f : 180.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252880_(0.0f, 0.5f, -0.5f);
                if (link.ceilingSecondary()) {
                    poseStack.m_252880_(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.m_252880_(0.5f, 0.0f, 0.52f);
        }
        poseStack.m_85841_(1.0f, 2.0f, 1.0f);
        poseStack.m_85837_(-0.5, 0.0, 0.0);
        poseStack.m_85841_(scale, scale, scale);
        VertexConsumer consumerA = buffer.m_6299_(PortalRenderTypes.portal(isPrimary ? link.getVariant().primaryPortal.getMaskTexture() : link.getVariant().secondaryPortal.getMaskTexture()));
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), -0.5f, -0.5f, 0.0f).m_193479_(FastColor.ABGR32.m_266248_((int)255, (int)255, (int)255, (int)255)).m_7421_(0.0f, 1.0f).m_5752_();
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), 0.5f, -0.5f, 0.0f).m_193479_(FastColor.ABGR32.m_266248_((int)255, (int)255, (int)255, (int)255)).m_7421_(1.0f, 1.0f).m_5752_();
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), 0.5f, 0.5f, 0.0f).m_193479_(FastColor.ABGR32.m_266248_((int)255, (int)255, (int)255, (int)255)).m_7421_(1.0f, 0.0f).m_5752_();
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), -0.5f, 0.5f, 0.0f).m_193479_(FastColor.ABGR32.m_266248_((int)255, (int)255, (int)255, (int)255)).m_7421_(0.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    public static void renderPortalFrame(ResourceLocation texture, ColorUtil.RGBA color, MultiBufferSource buffer, PoseStack poseStack) {
        poseStack.m_85836_();
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        VertexConsumer consumerA = buffer.m_6299_(PortalRenderTypes.portalFrame(texture));
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), -0.5f, -0.5f, 0.0f).m_85950_(color.red(), color.green(), color.blue(), color.alpha()).m_7421_(0.0f, 1.0f).m_5752_();
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), 0.5f, -0.5f, 0.0f).m_85950_(color.red(), color.green(), color.blue(), color.alpha()).m_7421_(1.0f, 1.0f).m_5752_();
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), 0.5f, 0.5f, 0.0f).m_85950_(color.red(), color.green(), color.blue(), color.alpha()).m_7421_(1.0f, 0.0f).m_5752_();
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), -0.5f, 0.5f, 0.0f).m_85950_(color.red(), color.green(), color.blue(), color.alpha()).m_7421_(0.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    public static void renderPortalHighlight(MultiBufferSource buffer, PoseStack poseStack, ResourceLocation texture, ColorUtil.RGBA color, boolean isPrimary) {
        poseStack.m_85836_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)516);
        GL11.glEnable((int)2960);
        RenderSystem.stencilFunc((int)517, (int)1, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)color.red(), (float)color.green(), (float)color.blue(), (float)color.alpha());
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_252986_(matrix, -0.5f, -0.5f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, 0.5f, -0.5f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, 0.5f, 0.5f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, -0.5f, 0.5f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2960);
        if (!isPrimary) {
            RenderSystem.clear((int)1024, (boolean)Minecraft.f_91002_);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
        poseStack.m_85849_();
    }

    public static void renderPortalVortex(ClientPortalLink link, Camera camera, TextureAtlasSprite sprite, MultiBufferSource buffer, PoseStack poseStack, boolean isPrimary) {
        ItemStack gunStack;
        PortalGunItem portalGun;
        UUID linkID;
        boolean hasPortalGun;
        poseStack.m_85836_();
        Vec3 pos = isPrimary ? link.posPrimary().m_252807_() : link.posSecondary().m_252807_();
        Direction direction = isPrimary ? link.directionPrimary() : link.directionSecondary();
        poseStack.m_85837_(pos.f_82479_ - camera.m_90583_().f_82479_, pos.f_82480_ - camera.m_90583_().f_82480_ + 0.5, pos.f_82481_ - camera.m_90583_().f_82481_);
        poseStack.m_252781_(direction.m_253075_());
        if (isPrimary) {
            if (link.wallPrimary()) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            } else {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(link.ceilingPrimary() ? 0.0f : 180.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252880_(0.0f, 0.5f, -0.5f);
                if (link.ceilingPrimary()) {
                    poseStack.m_252880_(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.m_252880_(0.5f, 0.0f, 0.52f);
        } else {
            if (link.wallSecondary()) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            } else {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(link.ceilingSecondary() ? 0.0f : 180.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252880_(0.0f, 0.5f, -0.5f);
                if (link.ceilingSecondary()) {
                    poseStack.m_252880_(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.m_252880_(0.5f, 0.0f, 0.52f);
        }
        poseStack.m_252880_(-0.3125f, 0.0f, 0.005f);
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        float scale = isPrimary ? link.openingPrimary() : link.openingSecondary();
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_252880_((1.0f - scale) * -0.5f, 0.0f, 0.0f);
        ColorUtil.RGBA color = ClientPortalUtilities.getPortalColor(link, isPrimary);
        VertexConsumer consumerA = buffer.m_6299_(PortalRenderTypes.portalVortex(sprite.m_247685_()));
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), -0.5f, -0.5f, 0.0f).m_85950_(color.red(), color.green(), color.blue(), color.alpha()).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), 0.5f, -0.5f, 0.0f).m_85950_(color.red(), color.green(), color.blue(), color.alpha()).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), 0.5f, 0.5f, 0.0f).m_85950_(color.red(), color.green(), color.blue(), color.alpha()).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
        consumerA.m_252986_(poseStack.m_85850_().m_252922_(), -0.5f, 0.5f, 0.0f).m_85950_(color.red(), color.green(), color.blue(), color.alpha()).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        boolean bl = hasPortalGun = main.m_150930_((Item)ItemInit.PORTAL_GUN.get()) || off.m_150930_((Item)ItemInit.PORTAL_GUN.get());
        if (hasPortalGun && (linkID = (portalGun = (PortalGunItem)(gunStack = main.m_150930_((Item)ItemInit.PORTAL_GUN.get()) ? main : off).m_41720_()).getUUID(gunStack, false)) != null && linkID.equals(link.linkID())) {
            ResourceLocation texture = ClientPortalUtilities.getPortalHighlightTexture(link, isPrimary);
            poseStack.m_85836_();
            poseStack.m_252880_(0.15625f, 0.0f, 0.0f);
            PortalRenderer.renderPortalHighlight(buffer, poseStack, texture, color, isPrimary);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            poseStack.m_252880_(0.3125f, 0.0f, 0.0f);
            PortalRenderer.renderPortalHighlight(buffer, poseStack, texture, color, isPrimary);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }
}

