/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mistersecret312.aperture_innovations.ApertureInnovations;
import net.mistersecret312.aperture_innovations.client.renderer.PortalRenderer;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.init.NetworkInit;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.network.ServerboundOpenPortalPacket;
import net.mistersecret312.aperture_innovations.network.ServerboundResetPortalLinkPacket;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.ClientPortalUtilities;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;
import net.mistersecret312.aperture_innovations.sounds.PortalSoundWrapper;

@Mod.EventBusSubscriber(modid="aperture_innovations", value={Dist.CLIENT})
public class ClientEvents {
    public static final ResourceLocation TEXTURE_PRIMARY_VORTEX = ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"block/portal/portal_blue_vortex");
    public static final ResourceLocation TEXTURE_SECONDARY_VORTEX = ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"block/portal/portal_orange_vortex");

    @SubscribeEvent
    public static void renderPortals(RenderLevelStageEvent event) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Camera camera = event.getCamera();
        PoseStack poseStack = event.getPoseStack();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            PortalRenderer.LINKS.forEach((arg_0, arg_1) -> ClientEvents.lambda$renderPortals$0(poseStack, (Level)level, buffer, camera, arg_0, arg_1));
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            for (Map.Entry<UUID, ClientPortalLink> linkEntry : PortalRenderer.LINKS.entrySet()) {
                ClientPortalLink link = linkEntry.getValue();
                poseStack.m_85836_();
                ResourceLocation texturePrimary = ClientPortalUtilities.getPortalVortexTexture(link, true);
                ResourceLocation textureSecondary = ClientPortalUtilities.getPortalVortexTexture(link, false);
                TextureAtlasSprite primary = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texturePrimary);
                TextureAtlasSprite secondary = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(textureSecondary);
                for (int i = 0; i < 2; ++i) {
                    ResourceKey<Level> dimension;
                    ResourceKey<Level> resourceKey = dimension = i == 0 ? link.dimensionPrimary() : link.dimensionSecondary();
                    if (Minecraft.m_91087_().f_91073_.m_46472_() != dimension) continue;
                    poseStack.m_85836_();
                    float scale = ClientPortalUtilities.getPortalOpeningAnimationProgress(link.linkID(), i == 0);
                    BlockPos portalPos = i == 0 ? link.posPrimary() : link.posSecondary();
                    BlockPos otherPortalPos = i == 0 ? link.posSecondary() : link.posPrimary();
                    poseStack.m_85849_();
                    if (portalPos != null && Minecraft.m_91087_().f_91073_.m_46749_(portalPos) && event.getLevelRenderer().getFrustum().m_113029_(new AABB(portalPos).m_82400_(1.0))) {
                        if (i == 0) {
                            PortalRenderer.primaryRender(link, buffer, poseStack, camera, scale);
                        } else {
                            PortalRenderer.secondaryRender(link, buffer, poseStack, camera, scale);
                        }
                    }
                    if (i == 0 && link.posPrimary() != null) {
                        PortalRenderer.renderPortalVortex(link, camera, primary, (MultiBufferSource)buffer, poseStack, true);
                        continue;
                    }
                    if (link.posSecondary() == null) continue;
                    PortalRenderer.renderPortalVortex(link, camera, secondary, (MultiBufferSource)buffer, poseStack, false);
                }
                poseStack.m_85849_();
                buffer.m_109911_();
            }
        }
    }

    @SubscribeEvent
    public static void renderBlockOverlay(RenderBlockScreenEffectEvent event) {
        Player player = event.getPlayer();
        Level level = player.m_9236_();
        BlockPos pos = event.getBlockPos();
        if (event.getOverlayType().equals((Object)RenderBlockScreenEffectEvent.OverlayType.BLOCK)) {
            boolean isOnCeiling;
            boolean isOnWall;
            Direction portalDirection;
            Pair<UUID, Boolean> portal = PortalUtilities.getClosestPortal((Entity)player);
            UUID uuid = (UUID)portal.getFirst();
            boolean isPrimary = (Boolean)portal.getSecond();
            if (uuid == null) {
                return;
            }
            Vec3 portalPos = PortalUtilities.getPortalPos(level, uuid, isPrimary);
            AABB portalBox = PortalUtilities.getPortalBoundingBox(portalPos, portalDirection = PortalUtilities.getPortalDirection(level, uuid, isPrimary), isOnWall = PortalUtilities.isPortalOnWall(level, uuid, isPrimary), isOnCeiling = PortalUtilities.isPortalOnCeiling(level, uuid, isPrimary));
            if (portalBox.m_82390_(player.m_146892_())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void mouseClicks(InputEvent.MouseButton.Pre event) {
        boolean hasPortalGun;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level == null || player == null || Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        boolean bl = hasPortalGun = main.m_150930_((Item)ItemInit.PORTAL_GUN.get()) || off.m_150930_((Item)ItemInit.PORTAL_GUN.get());
        if (!hasPortalGun) {
            return;
        }
        ItemStack gunItemStack = main.m_150930_((Item)ItemInit.PORTAL_GUN.get()) ? main : off;
        PortalGunItem gunItem = (PortalGunItem)gunItemStack.m_41720_();
        int dualityState = gunItem.getDualityState(gunItemStack);
        if (!(player.m_6144_() || event.getButton() != 0 || event.getAction() != 1 || dualityState != 2 && dualityState != 0)) {
            NetworkInit.INSTANCE.sendToServer((Object)new ServerboundOpenPortalPacket(true));
            event.setCanceled(true);
        } else if (!(player.m_6144_() || event.getButton() != 1 || event.getAction() != 1 || dualityState != 2 && dualityState != 1)) {
            NetworkInit.INSTANCE.sendToServer((Object)new ServerboundOpenPortalPacket(false));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && mc.f_91074_ != null) {
                PortalRenderer.LINKS.forEach((linkID, link) -> {
                    for (int i = 0; i < 2; ++i) {
                        PortalSoundWrapper.PortalAmbient ambient;
                        float progress;
                        BlockPos portalPos;
                        boolean isPrimary = i == 0;
                        BlockPos blockPos = portalPos = isPrimary ? link.posPrimary() : link.posSecondary();
                        if (portalPos != null && (progress = ClientPortalUtilities.getPortalOpeningAnimationProgress(linkID, isPrimary)) < 1.0f) {
                            ClientPortalUtilities.setPortalOpeningAnimationProgress(progress += 0.25f, linkID, isPrimary);
                        }
                        if (link.isOpen() || (ambient = ClientPortalUtilities.getAmbientSound(linkID, isPrimary)) == null) continue;
                        ambient.stopSound();
                    }
                });
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            while (((KeyMapping)ApertureInnovations.ClientModEvents.RESET_PORTAL_GUN.get()).m_90859_()) {
                NetworkInit.INSTANCE.sendToServer((Object)new ServerboundResetPortalLinkPacket());
            }
        }
    }

    private static /* synthetic */ void lambda$renderPortals$0(PoseStack poseStack, Level level, MultiBufferSource.BufferSource buffer, Camera camera, UUID linkID, ClientPortalLink link) {
        poseStack.m_85836_();
        for (int i = 0; i < 2; ++i) {
            boolean otherMoonshot;
            ResourceKey<Level> dimension;
            ResourceKey<Level> resourceKey = dimension = i == 0 ? link.dimensionPrimary() : link.dimensionSecondary();
            if (level.m_46472_() != dimension) continue;
            poseStack.m_85836_();
            float scale = ClientPortalUtilities.getPortalOpeningAnimationProgress(linkID, i == 0);
            BlockPos portalPos = i == 0 ? link.posPrimary() : link.posSecondary();
            BlockPos otherPortalPos = i == 0 ? link.posSecondary() : link.posPrimary();
            boolean moonshot = i == 0 ? link.moonshotPrimary() : link.moonshotSecondary();
            boolean bl = otherMoonshot = i == 0 ? link.moonshotSecondary() : link.moonshotPrimary();
            if ((portalPos != null || moonshot) && (otherPortalPos != null || otherMoonshot) && level.m_46749_(portalPos)) {
                PortalRenderer.renderPortalNonSee((MultiBufferSource)buffer, poseStack, camera, link, i == 0, scale);
            }
            poseStack.m_85849_();
            buffer.m_109911_();
        }
        poseStack.m_85849_();
    }
}

