/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.events;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingUseTotemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.mistersecret312.aperture_innovations.advancements.NearPortalDeathCriterion;
import net.mistersecret312.aperture_innovations.advancements.PortalTravelCriterion;
import net.mistersecret312.aperture_innovations.capabilities.ApertureCapability;
import net.mistersecret312.aperture_innovations.capabilities.ApertureEnergy;
import net.mistersecret312.aperture_innovations.capabilities.GenericProvider;
import net.mistersecret312.aperture_innovations.config.LongFallBootsConfig;
import net.mistersecret312.aperture_innovations.init.CapabilityInit;
import net.mistersecret312.aperture_innovations.init.NetworkInit;
import net.mistersecret312.aperture_innovations.init.SoundInit;
import net.mistersecret312.aperture_innovations.init.StatisticsInit;
import net.mistersecret312.aperture_innovations.items.LongFallBootsItem;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.network.ClientBoundPortalLinkSyncPacket;
import net.mistersecret312.aperture_innovations.network.ClientboundPortalAmbientSoundPacket;
import net.mistersecret312.aperture_innovations.network.ClientboundPortalSoundsPacket;
import net.mistersecret312.aperture_innovations.network.ClientboundTeleportMomentumPacket;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.PortalLink;
import net.mistersecret312.aperture_innovations.portal.PortalLinkData;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="aperture_innovations", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    @SubscribeEvent
    public static void levelTick(TickEvent.LevelTickEvent event) {
        if (event.side.isServer() && event.phase.equals((Object)TickEvent.Phase.END)) {
            Level level = event.level;
            PortalLinkData data = PortalLinkData.get(event.level);
            if (level instanceof ServerLevel) {
                UUID uuid;
                ServerLevel serverLevel = (ServerLevel)level;
                for (Map.Entry<UUID, PortalLink> entry : PortalUtilities.getPortalLinks((Level)serverLevel).entrySet()) {
                    PortalLink link = entry.getValue();
                    uuid = entry.getKey();
                    for (int i = 0; i < 2; ++i) {
                        AABB centerBox;
                        BlockPos portalBlockPos;
                        boolean isPrimary = i == 0;
                        Vec3 portalPos = PortalUtilities.getPortalPos((Level)serverLevel, uuid, isPrimary);
                        BlockPos blockPos = portalBlockPos = isPrimary ? link.posPrimary : link.posSecondary;
                        if (portalPos == null) continue;
                        ResourceKey<Level> dimension = PortalUtilities.getPortalDimension((Level)serverLevel, uuid, isPrimary);
                        if (!serverLevel.m_46472_().equals(dimension)) continue;
                        Direction portalDirection = PortalUtilities.getPortalDirection((Level)serverLevel, uuid, isPrimary);
                        boolean isOnWall = PortalUtilities.isPortalOnWall((Level)serverLevel, uuid, isPrimary);
                        boolean isOnCeiling = PortalUtilities.isPortalOnCeiling((Level)serverLevel, uuid, isPrimary);
                        boolean otherMoonshot = isPrimary ? link.moonshotSecondary : link.moonshotPrimary;
                        AABB teleportBox = PortalUtilities.getPortalTeleportBox(portalPos, portalDirection, isOnWall, isOnCeiling);
                        Vec3 boxCenter = teleportBox.m_82399_();
                        if (isOnWall) {
                            boxCenter = boxCenter.m_231075_(portalDirection.m_122424_(), 0.5);
                        }
                        if (level.m_45556_(centerBox = new AABB(boxCenter, boxCenter).m_82400_(0.25)).anyMatch(state -> {
                            Direction checkDirection = isOnWall ? portalDirection : (isOnCeiling ? Direction.DOWN : Direction.UP);
                            BlockPos statePos = portalBlockPos.m_121945_(checkDirection.m_122424_());
                            boolean isSturdy = state.m_60783_((BlockGetter)level, statePos, checkDirection);
                            return state.m_60713_(Blocks.f_50016_) || !isSturdy;
                        })) {
                            if (isPrimary) {
                                link.resetPrimary(level);
                                continue;
                            }
                            link.resetSecondary(level);
                            continue;
                        }
                        if (link.isOpen() && portalPos != null) {
                            if (otherMoonshot) {
                                List entities = level.m_45976_(Entity.class, new AABB(BlockPos.m_274446_((Position)portalPos)).m_82400_(5.0));
                                for (Entity entity : entities) {
                                    Vec3 pushVector = portalPos.m_82546_(entity.m_20182_()).m_82542_(0.08, 0.08, 0.08);
                                    entity.m_5997_(pushVector.f_82479_, pushVector.f_82480_, pushVector.f_82481_);
                                    if (!(entity instanceof ServerPlayer)) continue;
                                    ServerPlayer player = (ServerPlayer)entity;
                                    NetworkInit.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundTeleportMomentumPacket(entity.m_20184_()));
                                }
                            }
                            NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(BlockPos.m_274446_((Position)portalPos))), (Object)new ClientboundPortalAmbientSoundPacket(link.linkID, isPrimary, false));
                        }
                        if (portalPos == null) continue;
                        if (i == 0) {
                            ++link.openingPrimary;
                            continue;
                        }
                        ++link.openingSecondary;
                    }
                }
                for (Entity entity : serverLevel.m_8583_()) {
                    boolean otherMoonshot;
                    Pair<UUID, Boolean> pair = PortalUtilities.getClosestPortal(entity);
                    uuid = (UUID)pair.getFirst();
                    boolean isPrimary = (Boolean)pair.getSecond();
                    if (uuid == null) {
                        return;
                    }
                    Vec3 portalPos = PortalUtilities.getPortalPos((Level)serverLevel, uuid, isPrimary);
                    if (portalPos == null) continue;
                    ResourceKey<Level> dimension = PortalUtilities.getPortalDimension((Level)serverLevel, uuid, isPrimary);
                    if (!serverLevel.m_46472_().equals(dimension)) continue;
                    Direction portalDirection = PortalUtilities.getPortalDirection((Level)serverLevel, uuid, isPrimary);
                    boolean isOnWall = PortalUtilities.isPortalOnWall((Level)serverLevel, uuid, isPrimary);
                    boolean isOnCeiling = PortalUtilities.isPortalOnCeiling((Level)serverLevel, uuid, isPrimary);
                    AABB teleportBox = PortalUtilities.getPortalTeleportBox(portalPos, portalDirection, isOnWall, isOnCeiling);
                    Vec3 entityCenter = entity.m_20191_().m_82399_();
                    AABB entityCenterBox = new AABB(entityCenter, entityCenter).m_82377_(0.25, 0.5, 0.25);
                    if (!entityCenterBox.m_82369_(entity.m_20184_().m_82542_(1.0, 1.0, 1.0)).m_82381_(teleportBox)) continue;
                    Vec3 otherPortalPos = PortalUtilities.getPortalPos((Level)serverLevel, uuid, !isPrimary);
                    PortalLink link = PortalUtilities.getPortalLinks((Level)serverLevel).get(uuid);
                    boolean bl = otherMoonshot = isPrimary ? link.moonshotSecondary : link.moonshotPrimary;
                    if (otherPortalPos == null && otherMoonshot) {
                        otherPortalPos = portalPos.m_82520_(0.0, 1000.0, 0.0);
                    }
                    if (otherPortalPos == null) continue;
                    Direction otherDirection = PortalUtilities.getPortalDirection((Level)serverLevel, uuid, otherMoonshot == isPrimary);
                    boolean otherWall = PortalUtilities.isPortalOnWall((Level)serverLevel, uuid, otherMoonshot == isPrimary);
                    boolean otherCeiling = PortalUtilities.isPortalOnCeiling((Level)serverLevel, uuid, otherMoonshot == isPrimary);
                    ResourceKey<Level> otherDimension = PortalUtilities.getPortalDimension((Level)serverLevel, uuid, otherMoonshot == isPrimary);
                    float rotation = otherDirection.m_122435_() - portalDirection.m_122435_() + 180.0f;
                    AABB otherTeleportBox = PortalUtilities.getPortalTeleportBox(otherPortalPos, otherDirection, otherWall, otherCeiling);
                    otherPortalPos = otherTeleportBox.m_82399_();
                    otherPortalPos = otherWall ? otherPortalPos.m_82520_(0.0, -entity.m_20191_().m_82376_() * 0.45, 0.0).m_82549_(Vec3.m_82528_((Vec3i)otherDirection.m_122436_()).m_82542_((double)0.35f, 1.0, (double)0.35f)) : otherPortalPos.m_82520_(0.0, 0.1, 0.0);
                    if (!isOnWall && otherWall) {
                        otherPortalPos = otherPortalPos.m_82549_(Vec3.m_82528_((Vec3i)otherDirection.m_122436_()));
                    }
                    if (!otherWall && !isOnWall && !isOnCeiling && otherCeiling) {
                        otherPortalPos = otherPortalPos.m_82520_(0.0, -3.0, 0.0);
                    }
                    if (!(otherWall || isOnWall || isOnCeiling || otherCeiling)) {
                        otherPortalPos = otherPortalPos.m_82520_(0.0, 1.0, 0.0);
                    }
                    if (!otherWall && !isOnWall && isOnCeiling && !otherCeiling) {
                        otherPortalPos = otherPortalPos.m_82520_(0.0, 1.0, 0.0);
                    }
                    if (isOnWall && otherCeiling) {
                        otherPortalPos = otherPortalPos.m_82520_(0.0, -3.0, 0.0);
                    }
                    if (isOnWall && !otherWall && !otherCeiling) {
                        otherPortalPos = otherPortalPos.m_82520_(0.0, 1.0, 0.0);
                    }
                    Vector3f oldSpeed = entity.m_20184_().m_252839_();
                    ServerLevel otherPortalLevel = serverLevel.m_7654_().m_129880_(otherDimension);
                    entity.m_264318_(otherPortalLevel, otherPortalPos.f_82479_, otherPortalPos.f_82480_, otherPortalPos.f_82481_, Set.of(), entity.m_146908_() + (!isOnWall && otherWall ? rotation + 180.0f : rotation), entity.m_146909_());
                    Vec3 otherPos = otherPortalPos;
                    NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(BlockPos.m_274446_((Position)portalPos))), (Object)new ClientboundPortalSoundsPacket.EnterPortal(uuid, isPrimary));
                    NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> CommonEvents.lambda$levelTick$4((Level)otherPortalLevel, otherPos)), (Object)new ClientboundPortalSoundsPacket.EnterPortal(uuid, isPrimary));
                    Quaternionf rotationQ = new Quaternionf((Quaternionfc)Axis.f_252436_.m_252977_(rotation - 180.0f));
                    if (isOnWall && otherWall) {
                        if (rotation == 0.0f) {
                            rotationQ = new Quaternionf();
                        }
                        if (rotation == 180.0f) {
                            rotationQ = new Quaternionf((Quaternionfc)Axis.f_252436_.m_252977_(180.0f));
                        }
                    }
                    Vector3f newSpeed = oldSpeed.rotate((Quaternionfc)rotationQ);
                    if (!isOnWall && !otherWall) {
                        if (!isOnCeiling && !otherCeiling) {
                            newSpeed = new Vector3f(newSpeed.x, -newSpeed.y + (link.isInterdimensionalLink() ? 0.25f : 0.0f), newSpeed.z);
                        }
                        if (isOnCeiling && !otherCeiling) {
                            newSpeed = new Vector3f(newSpeed.x, newSpeed.y, newSpeed.z);
                        }
                    }
                    if (!isOnWall && otherWall) {
                        if (otherDirection.m_122434_() == Direction.Axis.X) {
                            newSpeed = new Vector3f(newSpeed.x - (otherDirection.m_122421_().equals((Object)Direction.AxisDirection.NEGATIVE) ? -newSpeed.y : newSpeed.y), 0.0f, 0.0f);
                        }
                        if (otherDirection.m_122434_() == Direction.Axis.Z) {
                            newSpeed = new Vector3f(0.0f, 0.0f, newSpeed.z + (otherDirection.m_122421_().equals((Object)Direction.AxisDirection.NEGATIVE) ? newSpeed.y : -newSpeed.y));
                        }
                    }
                    if (isOnWall && !otherWall && !otherCeiling) {
                        newSpeed = new Vector3f(0.0f, (float)(0.25 + entity.m_20184_().m_82553_()), 0.0f);
                    }
                    entity.m_20256_(new Vec3(newSpeed));
                    entity.m_183634_();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        player.m_36222_((ResourceLocation)StatisticsInit.TIMES_USED_PORTALS.get(), 1);
                        NetworkInit.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundTeleportMomentumPacket(new Vec3(newSpeed)));
                    }
                    Vec3 mathOtherPos = otherPortalPos;
                    entity.getCapability(CapabilityInit.APERTURE).ifPresent(cap -> {
                        cap.portal = new Pair((Object)uuid, (Object)(!isPrimary ? 1 : 0));
                        cap.updateDistance();
                        cap.setFrictionlessTime(2000);
                        if (entity instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)entity;
                            PortalTravelCriterion.INSTANCE.trigger(player, dimension.m_135782_(), otherDimension.m_135782_(), (long)portalPos.m_82557_(mathOtherPos), (long)cap.verticalDistance, (long)cap.horizontalDistance, otherMoonshot);
                        }
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PortalLinkData data = PortalLinkData.get(serverPlayer.m_9236_());
            NetworkInit.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientBoundPortalLinkSyncPacket(data.portalLinks, new HashMap<UUID, ClientPortalLink>()));
        }
    }

    @SubscribeEvent
    public static void playerFall(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        DamageSource source = event.getSource();
        for (ItemStack stack : living.m_6168_()) {
            if (!source.equals(living.m_269291_().m_268989_()) && !source.equals(living.m_269291_().m_269515_()) || !(stack.m_41720_() instanceof LongFallBootsItem)) continue;
            if (!living.m_9236_().m_5776_()) {
                ServerLevel level = (ServerLevel)living.m_9236_();
                level.m_5594_(null, living.m_20183_(), (SoundEvent)SoundInit.LONG_FALL_BOOTS_LAND.get(), SoundSource.PLAYERS, 0.15f, 1.0f);
            }
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void playerFallDamage(LivingFallEvent event) {
        LivingEntity living = event.getEntity();
        for (ItemStack stack : living.m_6168_()) {
            if (!(stack.m_41720_() instanceof LongFallBootsItem)) continue;
            if (!living.m_9236_().m_5776_() && event.getDistance() > 5.0f) {
                if (((Boolean)LongFallBootsConfig.long_fall_boots_use_energy.get()).booleanValue() && !CommonEvents.consumeEnergy(stack)) {
                    return;
                }
                ServerLevel level = (ServerLevel)living.m_9236_();
                level.m_5594_(null, living.m_20183_(), (SoundEvent)SoundInit.LONG_FALL_BOOTS_LAND.get(), SoundSource.PLAYERS, 0.15f, 1.0f);
            }
            event.setCanceled(true);
            return;
        }
    }

    public static boolean consumeEnergy(ItemStack stack) {
        IEnergyStorage storage;
        Optional optionalCapability = stack.getCapability(ForgeCapabilities.ENERGY).resolve();
        if (optionalCapability.isPresent() && (storage = (IEnergyStorage)optionalCapability.get()) instanceof ApertureEnergy) {
            ApertureEnergy energy = (ApertureEnergy)storage;
            long requiredEnergy = (Long)LongFallBootsConfig.fall_energy_consumption.get();
            if (energy.getTrueEnergyStored() >= requiredEnergy) {
                energy.extractLongEnergy(requiredEnergy, false);
                return true;
            }
            return false;
        }
        return false;
    }

    @SubscribeEvent
    public static void playerDied(LivingDeathEvent event) {
        LivingEntity living = event.getEntity();
        Level level = living.m_9236_();
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            Pair<UUID, Boolean> closestPortal = PortalUtilities.getClosestPortal((Entity)player);
            UUID linkID = (UUID)closestPortal.getFirst();
            if (linkID == null) {
                return;
            }
            boolean isPrimary = (Boolean)closestPortal.getSecond();
            Vec3 portalPos = PortalUtilities.getPortalPos(level, linkID, isPrimary);
            if (portalPos == null) {
                return;
            }
            boolean onWall = PortalUtilities.isPortalOnWall(level, linkID, isPrimary);
            boolean onCeiling = PortalUtilities.isPortalOnCeiling(level, linkID, isPrimary);
            long distance = (long)portalPos.m_82554_(player.m_20182_());
            if (distance > 16L) {
                return;
            }
            NearPortalDeathCriterion.INSTANCE.trigger(player, distance, !onWall && !onCeiling);
        }
    }

    @SubscribeEvent
    public static void totemDeath(LivingUseTotemEvent event) {
        LivingEntity living = event.getEntity();
        Level level = living.m_9236_();
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            Pair<UUID, Boolean> closestPortal = PortalUtilities.getClosestPortal((Entity)player);
            UUID linkID = (UUID)closestPortal.getFirst();
            if (linkID == null) {
                return;
            }
            boolean isPrimary = (Boolean)closestPortal.getSecond();
            Vec3 portalPos = PortalUtilities.getPortalPos(level, linkID, isPrimary);
            if (portalPos == null) {
                return;
            }
            boolean onWall = PortalUtilities.isPortalOnWall(level, linkID, isPrimary);
            boolean onCeiling = PortalUtilities.isPortalOnCeiling(level, linkID, isPrimary);
            long distance = (long)portalPos.m_82554_(player.m_20182_());
            if (distance > 16L) {
                return;
            }
            NearPortalDeathCriterion.INSTANCE.trigger(player, distance, !onWall && !onCeiling);
        }
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingTickEvent event) {
        event.getEntity().getCapability(CapabilityInit.APERTURE).ifPresent(cap -> cap.tick(event.getEntity().m_9236_(), event.getEntity()));
    }

    @SubscribeEvent
    public static void itemToss(ItemTossEvent event) {
        if (event.getEntity().m_32055_().m_41720_() instanceof PortalGunItem) {
            event.getEntity().m_32052_(event.getPlayer().m_20148_());
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("aperture_innovations", "aperture"), new GenericProvider<ApertureCapability>(CapabilityInit.APERTURE, new ApertureCapability()));
        }
    }

    private static /* synthetic */ LevelChunk lambda$levelTick$4(Level otherPortalLevel, Vec3 otherPos) {
        return otherPortalLevel.m_46745_(BlockPos.m_274446_((Position)otherPos));
    }
}

