/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.init;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.mistersecret312.aperture_innovations.blocks.VerticalOneByTwoBlock;
import net.mistersecret312.aperture_innovations.init.ItemInit;

public class BlockInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"aperture_innovations");
    public static final RegistryObject<Block> METAL_SURFACE_BLOCK = BlockInit.registerBlock("metal_surface_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_).m_284180_(MapColor.f_283818_)));
    public static final RegistryObject<Block> METAL_SURFACE_TILE_BLOCK = BlockInit.registerBlock("metal_surface_tile_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_).m_284180_(MapColor.f_283818_)));
    public static final RegistryObject<Block> METAL_SURFACE_1x2_BLOCK = BlockInit.registerBlock("metal_surface_1x2_block", () -> new VerticalOneByTwoBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_).m_284180_(MapColor.f_283818_)));
    public static final RegistryObject<Block> CONCRETE_SURFACE_BLOCK = BlockInit.registerBlock("concrete_surface_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50542_).m_284180_(MapColor.f_283919_)));
    public static final RegistryObject<Block> CONCRETE_SURFACE_TILE_BLOCK = BlockInit.registerBlock("concrete_surface_tile_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50542_).m_284180_(MapColor.f_283919_)));
    public static final RegistryObject<Block> CONCRETE_SURFACE_1x2_BLOCK = BlockInit.registerBlock("concrete_surface_1x2_block", () -> new VerticalOneByTwoBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50542_).m_284180_(MapColor.f_283919_)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus bus) {
        BLOCKS.register(bus);
    }
}

