/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.items;

import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.mistersecret312.aperture_innovations.capabilities.ApertureEnergy;
import net.mistersecret312.aperture_innovations.capabilities.item.ItemEnergyProvider;
import net.mistersecret312.aperture_innovations.client.renderer.LongFallBootsRenderProperties;
import net.mistersecret312.aperture_innovations.config.LongFallBootsConfig;
import org.jetbrains.annotations.Nullable;

public class LongFallBootsItem
extends ArmorItem {
    public static final String ENERGY = "Energy";

    public LongFallBootsItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public boolean m_142522_(ItemStack stack) {
        return (Boolean)LongFallBootsConfig.long_fall_boots_use_energy.get() != false && LongFallBootsItem.getEnergy(stack) != LongFallBootsItem.getCapacity();
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)LongFallBootsItem.getEnergy(stack) / (float)LongFallBootsItem.getCapacity());
    }

    public int m_142159_(ItemStack stack) {
        return new Color(0, 200, 255).getRGB();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(LongFallBootsRenderProperties.INSTANCE);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (((Boolean)LongFallBootsConfig.long_fall_boots_use_energy.get()).booleanValue()) {
            components.add((Component)Component.m_237115_((String)"item.aperture_innovations.long_fall_boots.energy").m_130946_(ApertureEnergy.energyToString(LongFallBootsItem.getEnergy(stack), LongFallBootsItem.getCapacity())).m_130940_(ChatFormatting.DARK_RED));
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "aperture_innovations:textures/models/armor/long_fall_boots.png";
    }

    public static long getEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(ENERGY, 4)) {
            return tag.m_128454_(ENERGY);
        }
        tag.m_128356_(ENERGY, LongFallBootsItem.getCapacity());
        return 0L;
    }

    public static long getCapacity() {
        return (Long)LongFallBootsConfig.long_fall_boots_max_energy_stored.get();
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemEnergyProvider(stack){

            @Override
            public long capacity() {
                return LongFallBootsItem.getCapacity();
            }

            @Override
            public long maxReceive() {
                return 1000L;
            }

            @Override
            public long maxExtract() {
                return 1000L;
            }
        };
    }
}

