/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.items;

import java.awt.Color;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.PacketDistributor;
import net.mistersecret312.aperture_innovations.ApertureInnovations;
import net.mistersecret312.aperture_innovations.advancements.ThrownIntoFluidCriterion;
import net.mistersecret312.aperture_innovations.capabilities.ApertureEnergy;
import net.mistersecret312.aperture_innovations.capabilities.item.ItemEnergyProvider;
import net.mistersecret312.aperture_innovations.client.renderer.PortalGunRenderer;
import net.mistersecret312.aperture_innovations.config.PortalGunConfig;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.init.NetworkInit;
import net.mistersecret312.aperture_innovations.network.ClientboundPortalSoundsPacket;
import net.mistersecret312.aperture_innovations.portal.PortalLink;
import net.mistersecret312.aperture_innovations.portal.PortalLinkData;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PortalGunItem
extends Item
implements GeoItem {
    public static final String ENERGY = "Energy";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PortalGunItem(Item.Properties pProperties) {
        super(pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static ItemStack createPortalGun(ResourceLocation variantKey) {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.PORTAL_GUN.get());
        PortalGunItem item = (PortalGunItem)stack.m_41720_();
        item.setVariant(stack, variantKey);
        return stack;
    }

    public boolean m_142522_(ItemStack stack) {
        return (Boolean)PortalGunConfig.portal_gun_uses_energy.get() != false && PortalGunItem.getEnergy(stack) != PortalGunItem.getCapacity();
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)PortalGunItem.getEnergy(stack) / (float)PortalGunItem.getCapacity());
    }

    public int m_142159_(ItemStack stack) {
        return new Color(0, 200, 255).getRGB();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)("aperture_innovations.portal_gun.variant_" + this.getVariant(stack).m_135815_())).m_130940_(ChatFormatting.YELLOW));
        int dualityState = this.getDualityState(stack);
        int primaryStripeColor = this.getPrimaryStripeColor(stack);
        int secondaryStripeColor = this.getSecondaryStripeColor(stack);
        int primaryPortalColor = this.getPrimaryPortalColor(stack);
        int secondaryPortalColor = this.getSecondaryPortalColor(stack);
        if (dualityState == 0) {
            components.add((Component)Component.m_237115_((String)"item.aperture_innovations.portal_gun.duality_primary").m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
        if (dualityState == 1) {
            components.add((Component)Component.m_237115_((String)"item.aperture_innovations.portal_gun.duality_secondary").m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
        if (this.getPair(stack) != null && dualityState != 2) {
            components.add((Component)Component.m_237115_((String)"item.aperture_innovations.portal_gun.paired").m_130940_(ChatFormatting.DARK_PURPLE));
        }
        if (((Boolean)PortalGunConfig.portal_gun_uses_energy.get()).booleanValue()) {
            components.add((Component)Component.m_237115_((String)"item.aperture_innovations.portal_gun.energy").m_130946_(ApertureEnergy.energyToString(PortalGunItem.getEnergy(stack), PortalGunItem.getCapacity())).m_130940_(ChatFormatting.DARK_RED));
        }
        if (primaryPortalColor != -1 || primaryStripeColor != -1 || secondaryPortalColor != -1 || secondaryStripeColor != -1) {
            components.add((Component)Component.m_237113_((String)""));
        }
        if (primaryPortalColor != -1) {
            components.add((Component)Component.m_237110_((String)"item.aperture_innovations.portal_gun.portal_primary_color", (Object[])new Object[]{Integer.toHexString(primaryPortalColor).toUpperCase()}).m_130938_(style -> style.m_178520_(primaryPortalColor)));
        }
        if (secondaryPortalColor != -1) {
            components.add((Component)Component.m_237110_((String)"item.aperture_innovations.portal_gun.portal_secondary_color", (Object[])new Object[]{Integer.toHexString(secondaryPortalColor).toUpperCase()}).m_130938_(style -> style.m_178520_(secondaryPortalColor)));
        }
        if (primaryStripeColor != -1) {
            components.add((Component)Component.m_237110_((String)"item.aperture_innovations.portal_gun.stripe_primary_color", (Object[])new Object[]{Integer.toHexString(primaryStripeColor).toUpperCase()}).m_130938_(style -> style.m_178520_(primaryStripeColor)));
        }
        if (secondaryStripeColor != -1) {
            components.add((Component)Component.m_237110_((String)"item.aperture_innovations.portal_gun.stripe_secondary_color", (Object[])new Object[]{Integer.toHexString(secondaryStripeColor).toUpperCase()}).m_130938_(style -> style.m_178520_(secondaryStripeColor)));
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (level.m_5776_() || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.isInitialized(stack)) {
            this.setInitialized(stack, true);
            PortalLinkData data = PortalLinkData.get(level);
            UUID linkID = this.getUUID(stack, true);
            PortalLink link = data.getLink(linkID);
            if (link == null) {
                data.addFreshLink(linkID);
                NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(player.m_20183_())), (Object)new ClientboundPortalSoundsPacket.GunActivate(linkID, player.m_20183_()));
            }
        } else {
            PortalLink link = PortalUtilities.getPortalLinks(level).get(this.getUUID(stack, false));
            if (link != null && link.isOpen() && ((Boolean)PortalGunConfig.portal_gun_uses_energy.get()).booleanValue()) {
                stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> {
                    long toExtract;
                    ApertureEnergy energy;
                    long extracted;
                    if (cap instanceof ApertureEnergy && (extracted = (energy = (ApertureEnergy)cap).extractLongEnergy(toExtract = (link.isInterdimensionalLink() ? (Long)PortalGunConfig.portal_gun_passive_consumption.get() : (Long)PortalGunConfig.portal_gun_interdimensional_passive_consumption.get()).longValue(), false)) < toExtract) {
                        player.m_5661_((Component)Component.m_237115_((String)"item.aperture_innovations.portal_gun.not_enough_energy"), true);
                        link.reset(level);
                    }
                });
            }
            if (link != null && isSelected && (this.getPair(stack) == null || this.getDualityState(stack) == 2)) {
                link.updateColors(level, this.getPrimaryPortalColor(stack), this.getSecondaryPortalColor(stack));
                link.updateVariant(level, this.getVariant(stack));
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Entity owner;
        if (entity.isInFluidType() && (owner = entity.m_19749_()) instanceof Player) {
            Player player = (Player)owner;
            ThrownIntoFluidCriterion.INSTANCE.trigger((ServerPlayer)player, stack, entity.m_20183_());
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return this.getDualityState(stack) != 2;
    }

    public static long getEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(ENERGY, 4)) {
            return tag.m_128454_(ENERGY);
        }
        tag.m_128356_(ENERGY, PortalGunItem.getCapacity());
        return 0L;
    }

    public static long getCapacity() {
        return (Long)PortalGunConfig.portal_gun_max_energy_stored.get();
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemEnergyProvider(stack){

            @Override
            public long capacity() {
                return PortalGunItem.getCapacity();
            }

            @Override
            public long maxReceive() {
                return 10000L;
            }

            @Override
            public long maxExtract() {
                return 10000L;
            }

            @Override
            public boolean canReceiveEnergy() {
                return true;
            }
        };
    }

    public static BlockHitResult rayTrace(Level level, Player player, double range) {
        float xRot = player.m_146909_();
        float yRot = player.m_146908_();
        Vec3 eyePos = player.m_146892_();
        float f2 = Mth.m_14089_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-xRot * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-xRot * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 lookVec = new Vec3((double)f6, (double)f5, (double)f7);
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(range));
        ClipContext context = new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player){

            public VoxelShape m_45694_(BlockState state, BlockGetter level, BlockPos pos) {
                if (state.m_204336_(ApertureInnovations.SHOOT_THROUGH)) {
                    return Shapes.m_83040_();
                }
                return super.m_45694_(state, level, pos);
            }
        };
        return level.m_45547_(context);
    }

    public boolean isLookingAtMoon(Player player, Level level) {
        HitResult hit = player.m_19907_((double)((Integer)PortalGunConfig.portal_gun_shoot_range.get()).intValue(), 0.0f, false);
        if (hit.m_6662_() != HitResult.Type.MISS) {
            return false;
        }
        float timeAngle = level.m_46490_(0.0f);
        double moonX = Math.sin(timeAngle);
        double moonY = -Math.cos(timeAngle);
        Vec3 moonVector = new Vec3(moonX, moonY, 0.0);
        Vec3 lookVector = player.m_20154_();
        double dot = lookVector.m_82526_(moonVector);
        return dot > 0.995;
    }

    public UUID getUUID(ItemStack stack, boolean generateIfEmpty) {
        CompoundTag tag = stack.m_41784_();
        int dualityState = this.getDualityState(stack);
        if (dualityState != 2 && tag.m_128441_("pair")) {
            return tag.m_128342_("pair");
        }
        if (tag.m_128441_("link")) {
            return tag.m_128342_("link");
        }
        if (generateIfEmpty) {
            UUID uuid = UUID.randomUUID();
            this.setUUID(stack, uuid);
            return uuid;
        }
        return null;
    }

    public void setUUID(ItemStack stack, UUID uuid) {
        stack.m_41784_().m_128362_("link", uuid);
    }

    public UUID getPair(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("pair")) {
            return tag.m_128342_("pair");
        }
        return null;
    }

    public void setPair(ItemStack stack, UUID pairID) {
        if (pairID == null) {
            stack.m_41784_().m_128473_("pair");
            return;
        }
        stack.m_41784_().m_128362_("pair", pairID);
    }

    public int getDualityState(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("duality")) {
            return tag.m_128451_("duality");
        }
        return 2;
    }

    public int getPrimaryStripeColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("primaryStripeColor")) {
            return tag.m_128451_("primaryStripeColor");
        }
        return -1;
    }

    public int getSecondaryStripeColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("secondaryStripeColor")) {
            return tag.m_128451_("secondaryStripeColor");
        }
        return -1;
    }

    public int getPrimaryPortalColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("primaryPortalColor")) {
            return tag.m_128451_("primaryPortalColor");
        }
        return -1;
    }

    public int getSecondaryPortalColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("secondaryPortalColor")) {
            return tag.m_128451_("secondaryPortalColor");
        }
        return -1;
    }

    public ResourceLocation getVariant(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("variant")) {
            return ResourceLocation.parse((String)tag.m_128461_("variant"));
        }
        return ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"chell");
    }

    public void setDualityState(ItemStack stack, int state) {
        stack.m_41784_().m_128405_("duality", state);
    }

    public void setPrimaryStripeColor(ItemStack stack, int color) {
        stack.m_41784_().m_128405_("primaryStripeColor", color);
    }

    public void setSecondaryStripeColor(ItemStack stack, int color) {
        stack.m_41784_().m_128405_("secondaryStripeColor", color);
    }

    public void setPrimaryPortalColor(ItemStack stack, int color) {
        stack.m_41784_().m_128405_("primaryPortalColor", color);
    }

    public void setSecondaryPortalColor(ItemStack stack, int color) {
        stack.m_41784_().m_128405_("secondaryPortalColor", color);
    }

    public void setVariant(ItemStack stack, ResourceLocation variantKey) {
        stack.m_41784_().m_128359_("variant", variantKey.toString());
    }

    public int getLastShotPortal(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("lastPortal")) {
            return tag.m_128451_("lastPortal");
        }
        return -1;
    }

    public void setLastShotPortal(ItemStack stack, int portal) {
        stack.m_41784_().m_128405_("lastPortal", portal);
    }

    public void setInitialized(ItemStack stack, boolean value) {
        stack.m_41784_().m_128379_("init", value);
    }

    public boolean isInitialized(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("init")) {
            return tag.m_128471_("init");
        }
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private PortalGunRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PortalGunRenderer();
                }
                return this.renderer;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return HumanoidModel.ArmPose.CROSSBOW_HOLD;
            }
        });
    }

    private <T extends PortalGunItem> PlayState handleAnimationState(AnimationState<T> state) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "main", 0, this::handleAnimationState);
        controller.triggerableAnim("shoot", Animations.SHOOT);
        controller.triggerableAnim("reset", Animations.RESET);
        controller.triggerableAnim("hold", Animations.HOLD);
        controllers.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static class Animations {
        protected static final String MAIN_CONTROLLER = "main";
        protected static final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");
        protected static final RawAnimation RESET = RawAnimation.begin().thenPlay("reset");
        protected static final RawAnimation HOLD = RawAnimation.begin().thenLoop("hold");

        private Animations() {
        }
    }
}

