/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.mistersecret312.aperture_innovations.client.renderer.PortalRenderer;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.PortalLink;

public class ClientBoundPortalLinkSyncPacket {
    public HashMap<UUID, PortalLink> links;
    public HashMap<UUID, ClientPortalLink> clientLinks = new HashMap();

    public ClientBoundPortalLinkSyncPacket(HashMap<UUID, PortalLink> links, HashMap<UUID, ClientPortalLink> clientLinks) {
        this.links = links;
        this.clientLinks = clientLinks;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_236828_(this.links.entrySet(), (writer, entry) -> {
            PortalLink link = (PortalLink)entry.getValue();
            writer.m_130077_(link.linkID);
            if (link.posPrimary != null) {
                writer.writeBoolean(true);
                writer.m_130064_(link.posPrimary);
                writer.writeBoolean(link.wallPrimary);
                writer.writeBoolean(link.ceilingPrimary);
                writer.m_236858_(link.dimensionPrimary);
                writer.m_130068_((Enum)link.directionPrimary);
                writer.writeFloat(link.openingPrimary > 6 ? 1.0f : 0.0f);
            } else {
                writer.writeBoolean(false);
            }
            writer.writeBoolean(link.moonshotPrimary);
            if (link.posSecondary != null) {
                writer.writeBoolean(true);
                writer.m_130064_(link.posSecondary);
                writer.writeBoolean(link.wallSecondary);
                writer.writeBoolean(link.ceilingSecondary);
                writer.m_236858_(link.dimensionSecondary);
                writer.m_130068_((Enum)link.directionSecondary);
                writer.writeFloat(link.openingSecondary > 6 ? 1.0f : 0.0f);
            } else {
                writer.writeBoolean(false);
            }
            writer.writeBoolean(link.moonshotSecondary);
            writer.m_130085_(link.variantKey);
            writer.writeInt(link.primaryPortalColor);
            writer.writeInt(link.secondaryPortalColor);
        });
    }

    public static ClientBoundPortalLinkSyncPacket decode(FriendlyByteBuf buffer) {
        ArrayList links = (ArrayList)buffer.m_236838_(i -> new ArrayList(), reader -> {
            UUID linkID = reader.m_130259_();
            boolean hasPrimary = reader.readBoolean();
            BlockPos posPrimary = null;
            boolean wallPrimary = false;
            boolean ceilingPrimary = false;
            ResourceKey dimensionPrimary = null;
            Direction directionPrimary = null;
            float openingPrimary = 0.0f;
            if (hasPrimary) {
                posPrimary = reader.m_130135_();
                wallPrimary = reader.readBoolean();
                ceilingPrimary = reader.readBoolean();
                dimensionPrimary = reader.m_236801_(Registries.f_256858_);
                directionPrimary = (Direction)reader.m_130066_(Direction.class);
                openingPrimary = reader.readFloat();
            }
            boolean moonshotPrimary = reader.readBoolean();
            boolean hasSecondary = reader.readBoolean();
            BlockPos posSecondary = null;
            boolean wallSecondary = false;
            boolean ceilingSecondary = false;
            ResourceKey dimensionSecondary = null;
            Direction directionSecondary = null;
            float openingSecondary = 0.0f;
            if (hasSecondary) {
                posSecondary = reader.m_130135_();
                wallSecondary = reader.readBoolean();
                ceilingSecondary = reader.readBoolean();
                dimensionSecondary = reader.m_236801_(Registries.f_256858_);
                directionSecondary = (Direction)reader.m_130066_(Direction.class);
                openingSecondary = reader.readFloat();
            }
            boolean moonshotSecondary = reader.readBoolean();
            ResourceLocation variantKey = reader.m_130281_();
            int primaryPortalColor = reader.readInt();
            int secondaryPortalColor = reader.readInt();
            ClientPortalLink link = new ClientPortalLink(linkID, posPrimary, posSecondary, wallPrimary, wallSecondary, ceilingPrimary, ceilingSecondary, (ResourceKey<Level>)dimensionPrimary, (ResourceKey<Level>)dimensionSecondary, directionPrimary, directionSecondary, moonshotPrimary, moonshotSecondary, openingPrimary, openingSecondary, variantKey, primaryPortalColor, secondaryPortalColor);
            return Map.entry(linkID, link);
        });
        HashMap<UUID, ClientPortalLink> linkMap = new HashMap<UUID, ClientPortalLink>();
        for (Map.Entry link : links) {
            linkMap.put((UUID)link.getKey(), (ClientPortalLink)link.getValue());
        }
        return new ClientBoundPortalLinkSyncPacket(new HashMap<UUID, PortalLink>(), linkMap);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PortalRenderer.LINKS = this.clientLinks;
        });
        return true;
    }
}

