/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.mistersecret312.aperture_innovations.sounds.SoundAccess;

public abstract class ClientboundPortalSoundsPacket {
    public UUID linkID;
    public boolean isPrimary;

    public ClientboundPortalSoundsPacket(UUID linkID, boolean isPrimary) {
        this.linkID = linkID;
        this.isPrimary = isPrimary;
    }

    public ClientboundPortalSoundsPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130259_(), buffer.readBoolean());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.linkID);
        buffer.writeBoolean(this.isPrimary);
    }

    public abstract boolean handle(Supplier<NetworkEvent.Context> var1);

    public static class ResetPortal
    extends ClientboundPortalSoundsPacket {
        public BlockPos pos;

        public ResetPortal(UUID linkID, BlockPos pos) {
            super(linkID, true);
            this.pos = pos;
        }

        public ResetPortal(FriendlyByteBuf buffer) {
            this(buffer.m_130259_(), buffer.m_130135_());
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.linkID);
            buffer.m_130064_(this.pos);
            buffer.writeBoolean(this.isPrimary);
        }

        @Override
        public boolean handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> SoundAccess.playResetPortalSound(this.linkID, this.pos, this.isPrimary));
            return true;
        }
    }

    public static class ShootPortal
    extends ClientboundPortalSoundsPacket {
        public BlockPos pos;

        public ShootPortal(UUID linkID, BlockPos pos, boolean isPrimary) {
            super(linkID, isPrimary);
            this.pos = pos;
        }

        public ShootPortal(FriendlyByteBuf buffer) {
            this(buffer.m_130259_(), buffer.m_130135_(), buffer.readBoolean());
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.linkID);
            buffer.m_130064_(this.pos);
            buffer.writeBoolean(this.isPrimary);
        }

        @Override
        public boolean handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> SoundAccess.playShootPortalSound(this.linkID, this.pos, this.isPrimary));
            return true;
        }
    }

    public static class GunActivate
    extends ClientboundPortalSoundsPacket {
        public BlockPos pos;

        public GunActivate(UUID linkID, BlockPos pos) {
            super(linkID, true);
            this.pos = pos;
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.linkID);
            buffer.m_130064_(this.pos);
        }

        public GunActivate(FriendlyByteBuf buffer) {
            this(buffer.m_130259_(), buffer.m_130135_());
        }

        @Override
        public boolean handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> SoundAccess.playGunActivateSound(this.linkID, this.pos, this.isPrimary));
            return true;
        }
    }

    public static class FizzlePortal
    extends ClientboundPortalSoundsPacket {
        public FizzlePortal(UUID linkID, boolean isPrimary) {
            super(linkID, isPrimary);
        }

        public FizzlePortal(FriendlyByteBuf buffer) {
            super(buffer);
        }

        @Override
        public boolean handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> SoundAccess.playFizzlePortalSound(this.linkID, this.isPrimary));
            return true;
        }
    }

    public static class InvalidSurface
    extends ClientboundPortalSoundsPacket {
        public BlockPos pos;

        public InvalidSurface(UUID linkID, BlockPos pos, boolean isPrimary) {
            super(linkID, isPrimary);
            this.pos = pos;
        }

        public InvalidSurface(FriendlyByteBuf buffer) {
            this(buffer.m_130259_(), buffer.m_130135_(), buffer.readBoolean());
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.linkID);
            buffer.m_130064_(this.pos);
            buffer.writeBoolean(this.isPrimary);
        }

        @Override
        public boolean handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> SoundAccess.playInvalidSurfaceSound(this.linkID, this.pos, this.isPrimary));
            return true;
        }
    }

    public static class EnterPortal
    extends ClientboundPortalSoundsPacket {
        public EnterPortal(UUID linkID, boolean isPrimary) {
            super(linkID, isPrimary);
        }

        public EnterPortal(FriendlyByteBuf buffer) {
            super(buffer);
        }

        @Override
        public boolean handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> SoundAccess.playEnterPortalSound(this.linkID, this.isPrimary));
            return true;
        }
    }

    public static class OpenPortal
    extends ClientboundPortalSoundsPacket {
        public OpenPortal(UUID linkID, boolean isPrimary) {
            super(linkID, isPrimary);
        }

        public OpenPortal(FriendlyByteBuf buffer) {
            super(buffer);
        }

        @Override
        public boolean handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> SoundAccess.playOpenPortalSound(this.linkID, this.isPrimary));
            return true;
        }
    }
}

