/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.network;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.mistersecret312.aperture_innovations.ApertureInnovations;
import net.mistersecret312.aperture_innovations.capabilities.ApertureEnergy;
import net.mistersecret312.aperture_innovations.config.PortalGunConfig;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.init.NetworkInit;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.network.ClientboundPortalSoundsPacket;
import net.mistersecret312.aperture_innovations.portal.PortalLink;
import net.mistersecret312.aperture_innovations.portal.PortalLinkData;
import net.mistersecret312.aperture_innovations.portal.PortalPlacement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.animatable.GeoItem;

public class ServerboundOpenPortalPacket {
    private static final Logger log = LoggerFactory.getLogger(ServerboundOpenPortalPacket.class);
    boolean isPrimary;

    public ServerboundOpenPortalPacket(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public ServerboundOpenPortalPacket(FriendlyByteBuf buffer) {
        this(buffer.readBoolean());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isPrimary);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            boolean hasPortalGun;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level level = player.m_9236_();
            ItemStack main = player.m_21205_();
            ItemStack off = player.m_21206_();
            boolean bl = hasPortalGun = main.m_150930_((Item)ItemInit.PORTAL_GUN.get()) || off.m_150930_((Item)ItemInit.PORTAL_GUN.get());
            if (!hasPortalGun) {
                return;
            }
            ItemStack gunStack = main.m_150930_((Item)ItemInit.PORTAL_GUN.get()) ? main : off;
            PortalGunItem portalGun = (PortalGunItem)gunStack.m_41720_();
            if (((Boolean)PortalGunConfig.portal_gun_consume_on_shot.get()).booleanValue() && ((Boolean)PortalGunConfig.portal_gun_uses_energy.get()).booleanValue() && !this.consumeEnergy(gunStack, (Player)player)) {
                return;
            }
            boolean moonshot = portalGun.isLookingAtMoon((Player)player, level);
            if (moonshot) {
                UUID linkID = portalGun.getUUID(gunStack, true);
                PortalLinkData linkData = PortalLinkData.get(level);
                PortalLink link = linkData.getLink(gunStack);
                if (link == null) {
                    linkData.addFreshLink(linkID);
                    link = linkData.getLink(linkID);
                }
                portalGun.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                portalGun.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                if (this.isPrimary) {
                    portalGun.setLastShotPortal(gunStack, 0);
                    link.setMoonshot(this.isPrimary, true, level);
                } else {
                    portalGun.setLastShotPortal(gunStack, 1);
                    link.setMoonshot(this.isPrimary, true, level);
                }
                NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(player.m_20183_())), (Object)new ClientboundPortalSoundsPacket.ShootPortal(linkID, player.m_20183_(), this.isPrimary));
                return;
            }
            BlockHitResult result = PortalGunItem.rayTrace(player.m_9236_(), (Player)player, ((Integer)PortalGunConfig.portal_gun_shoot_range.get()).intValue());
            if (!result.m_6662_().equals((Object)HitResult.Type.MISS)) {
                PortalPlacement.Result placement;
                UUID linkID = portalGun.getUUID(gunStack, false);
                if (linkID != null && !level.m_8055_(result.m_82425_()).m_204336_(ApertureInnovations.SHOOT_THROUGH) && (level.m_8055_(result.m_82425_()).m_204336_(ApertureInnovations.IMPORTALABLE) || !level.m_6425_(result.m_82425_()).m_76178_() || ((Boolean)PortalGunConfig.use_portalable_tag.get()).booleanValue() && !level.m_8055_(result.m_82425_()).m_204336_(ApertureInnovations.PORTALABLE))) {
                    if (!((Boolean)PortalGunConfig.portal_gun_consume_on_shot.get()).booleanValue() && ((Boolean)PortalGunConfig.portal_gun_uses_energy.get()).booleanValue() && !this.consumeEnergy(gunStack, (Player)player)) {
                        return;
                    }
                    portalGun.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    portalGun.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(player.m_20183_())), (Object)new ClientboundPortalSoundsPacket.ShootPortal(linkID, player.m_20183_(), this.isPrimary));
                    NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(player.m_20183_())), (Object)new ClientboundPortalSoundsPacket.InvalidSurface(linkID, player.m_20183_(), this.isPrimary));
                    return;
                }
                PortalLinkData linkData = PortalLinkData.get(level);
                PortalLink link = linkData.getLink(gunStack);
                if (link == null) {
                    linkData.addFreshLink(linkID);
                    link = linkData.getLink(linkID);
                }
                if ((placement = PortalPlacement.getBestPlacement(level, result, (Player)player, linkID, this.isPrimary)) != null) {
                    portalGun.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    portalGun.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    if (!((Boolean)PortalGunConfig.portal_gun_consume_on_shot.get()).booleanValue() && ((Boolean)PortalGunConfig.portal_gun_uses_energy.get()).booleanValue() && !this.consumeEnergy(gunStack, (Player)player)) {
                        return;
                    }
                    if (this.isPrimary) {
                        portalGun.setLastShotPortal(gunStack, 0);
                        link.createPrimaryPortal(level, placement.bottomPos, (ResourceKey<Level>)level.m_46472_(), placement.facing, placement.rotation);
                        NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(player.m_20183_())), (Object)new ClientboundPortalSoundsPacket.ShootPortal(linkID, player.m_20183_(), this.isPrimary));
                    } else {
                        portalGun.setLastShotPortal(gunStack, 1);
                        link.createSecondaryPortal(level, placement.bottomPos, (ResourceKey<Level>)level.m_46472_(), placement.facing, placement.rotation);
                        NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(player.m_20183_())), (Object)new ClientboundPortalSoundsPacket.ShootPortal(linkID, player.m_20183_(), this.isPrimary));
                    }
                } else {
                    portalGun.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    portalGun.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)gunStack, (ServerLevel)((ServerLevel)level)), "main", "shoot");
                    NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(player.m_20183_())), (Object)new ClientboundPortalSoundsPacket.ShootPortal(linkID, player.m_20183_(), this.isPrimary));
                    NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(player.m_20183_())), (Object)new ClientboundPortalSoundsPacket.InvalidSurface(linkID, player.m_20183_(), this.isPrimary));
                }
            }
        });
        return true;
    }

    public boolean consumeEnergy(ItemStack stack, Player player) {
        IEnergyStorage storage;
        Optional optionalCapability = stack.getCapability(ForgeCapabilities.ENERGY).resolve();
        if (optionalCapability.isPresent() && (storage = (IEnergyStorage)optionalCapability.get()) instanceof ApertureEnergy) {
            ApertureEnergy energy = (ApertureEnergy)storage;
            long requiredEnergy = (Long)PortalGunConfig.portal_gun_shoot_consumption.get();
            if (energy.getTrueEnergyStored() >= requiredEnergy) {
                energy.extractLongEnergy(requiredEnergy, false);
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"item.aperture_innovations.portal_gun.not_enough_energy").m_130940_(ChatFormatting.DARK_RED), true);
            return false;
        }
        return false;
    }
}

