/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.portal;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.PacketDistributor;
import net.mistersecret312.aperture_innovations.datapack.PortalGunVariant;
import net.mistersecret312.aperture_innovations.init.NetworkInit;
import net.mistersecret312.aperture_innovations.network.ClientboundPortalSoundsPacket;
import net.mistersecret312.aperture_innovations.portal.PortalLinkData;

public class PortalLink {
    public UUID linkID;
    public BlockPos posPrimary;
    public BlockPos posSecondary;
    public boolean wallPrimary;
    public boolean wallSecondary;
    public boolean ceilingPrimary;
    public boolean ceilingSecondary;
    public ResourceKey<Level> dimensionPrimary;
    public ResourceKey<Level> dimensionSecondary;
    public Direction directionPrimary;
    public Direction directionSecondary;
    public boolean moonshotPrimary = false;
    public boolean moonshotSecondary = false;
    public int openingPrimary = 0;
    public int openingSecondary = 0;
    public ResourceLocation variantKey = null;
    public int primaryPortalColor = -1;
    public int secondaryPortalColor = -1;

    public PortalLink(UUID linkID, ResourceLocation variantKey) {
        this.linkID = linkID;
        this.variantKey = variantKey;
    }

    public PortalLink(UUID linkID, BlockPos posPrimary, BlockPos posSecondary, boolean wallPrimary, boolean wallSecondary, boolean ceilingPrimary, boolean ceilingSecondary, ResourceKey<Level> dimensionPrimary, ResourceKey<Level> dimensionSecondary, Direction directionPrimary, Direction directionSecondary, ResourceLocation variantKey, int primaryPortalColor, int secondaryPortalColor) {
        this.linkID = linkID;
        this.posPrimary = posPrimary;
        this.posSecondary = posSecondary;
        this.wallPrimary = wallPrimary;
        this.wallSecondary = wallSecondary;
        this.ceilingPrimary = ceilingPrimary;
        this.ceilingSecondary = ceilingSecondary;
        this.dimensionPrimary = dimensionPrimary;
        this.dimensionSecondary = dimensionSecondary;
        this.directionPrimary = directionPrimary;
        this.directionSecondary = directionSecondary;
        this.primaryPortalColor = primaryPortalColor;
        this.secondaryPortalColor = secondaryPortalColor;
        this.variantKey = variantKey;
    }

    public void createPrimaryPortal(Level level, BlockPos pos, ResourceKey<Level> dimension, Direction direction, Direction facing) {
        this.posPrimary = pos;
        this.dimensionPrimary = dimension;
        this.directionPrimary = facing.equals((Object)Direction.UP) ? direction : facing;
        this.wallPrimary = facing.equals((Object)Direction.UP);
        this.ceilingPrimary = direction.equals((Object)Direction.DOWN);
        this.moonshotPrimary = false;
        this.openingPrimary = 0;
        ServerLevel portalLevel = level.m_7654_().m_129880_(this.dimensionPrimary);
        if (portalLevel != null) {
            NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> PortalLink.lambda$createPrimaryPortal$0((Level)portalLevel, pos)), (Object)new ClientboundPortalSoundsPacket.OpenPortal(this.linkID, true));
        }
        PortalLinkData.get(level).m_77762_();
    }

    public void createSecondaryPortal(Level level, BlockPos pos, ResourceKey<Level> dimension, Direction direction, Direction facing) {
        this.posSecondary = pos;
        this.dimensionSecondary = dimension;
        this.directionSecondary = facing.equals((Object)Direction.UP) ? direction : facing;
        this.wallSecondary = facing.equals((Object)Direction.UP);
        this.ceilingSecondary = direction.equals((Object)Direction.DOWN);
        this.moonshotSecondary = false;
        this.openingSecondary = 0;
        ServerLevel portalLevel = level.m_7654_().m_129880_(this.dimensionSecondary);
        if (portalLevel != null) {
            NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> PortalLink.lambda$createSecondaryPortal$1((Level)portalLevel, pos)), (Object)new ClientboundPortalSoundsPacket.OpenPortal(this.linkID, false));
        }
        PortalLinkData.get(level).m_77762_();
    }

    public void updateColors(Level level, int primaryPortalColor, int secondaryPortalColor) {
        if (this.primaryPortalColor != primaryPortalColor || this.secondaryPortalColor != secondaryPortalColor) {
            this.primaryPortalColor = primaryPortalColor;
            this.secondaryPortalColor = secondaryPortalColor;
            PortalLinkData.get(level).m_77762_();
        }
    }

    public void updateVariant(Level level, ResourceLocation variantKey) {
        if (this.variantKey != variantKey) {
            this.variantKey = variantKey;
            PortalLinkData.get(level).m_77762_();
        }
    }

    public void reset(Level level) {
        if (this.posPrimary != null || this.moonshotPrimary) {
            this.resetPrimary(level);
        }
        if (this.posSecondary != null || this.moonshotSecondary) {
            this.resetSecondary(level);
        }
    }

    public void resetPrimary(Level level) {
        ServerLevel portalLevel;
        if (this.posPrimary != null && (portalLevel = level.m_7654_().m_129880_(this.dimensionPrimary)) != null) {
            NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.lambda$resetPrimary$2((Level)portalLevel)), (Object)new ClientboundPortalSoundsPacket.FizzlePortal(this.linkID, true));
        }
        this.posPrimary = null;
        this.wallPrimary = false;
        this.ceilingPrimary = false;
        this.dimensionPrimary = null;
        this.directionPrimary = null;
        this.openingPrimary = 0;
        this.moonshotPrimary = false;
        PortalLinkData.get(level).m_77762_();
    }

    public void resetSecondary(Level level) {
        ServerLevel portalLevel;
        if (this.posSecondary != null && (portalLevel = level.m_7654_().m_129880_(this.dimensionSecondary)) != null) {
            NetworkInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.lambda$resetSecondary$3((Level)portalLevel)), (Object)new ClientboundPortalSoundsPacket.FizzlePortal(this.linkID, false));
        }
        this.posSecondary = null;
        this.wallSecondary = false;
        this.ceilingSecondary = false;
        this.dimensionSecondary = null;
        this.directionSecondary = null;
        this.openingSecondary = 0;
        this.moonshotSecondary = false;
        PortalLinkData.get(level).m_77762_();
    }

    public void setMoonshot(boolean isPrimary, boolean moonshot, Level level) {
        if (isPrimary) {
            this.posPrimary = null;
            this.moonshotPrimary = moonshot;
        } else {
            this.posSecondary = null;
            this.moonshotSecondary = moonshot;
        }
        PortalLinkData.get(level).m_77762_();
    }

    public boolean isOpen() {
        return !(this.posPrimary == null && !this.moonshotPrimary || this.posSecondary == null && !this.moonshotSecondary);
    }

    public boolean isInterdimensionalLink() {
        if (this.posPrimary == null || this.posSecondary == null) {
            return false;
        }
        return this.dimensionPrimary != this.dimensionSecondary;
    }

    public static PortalLink load(CompoundTag tag) {
        UUID linkID = tag.m_128342_("link");
        BlockPos posPrimary = null;
        boolean wallPrimary = false;
        boolean ceilingPrimary = false;
        ResourceKey<Level> dimensionPrimary = null;
        Direction directionPrimary = null;
        int openingPrimary = 0;
        if (tag.m_128441_("posPrimary")) {
            posPrimary = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("posPrimary"));
            wallPrimary = tag.m_128471_("wallPrimary");
            ceilingPrimary = tag.m_128471_("ceilingPrimary");
            dimensionPrimary = PortalLink.stringToDimension(tag.m_128461_("dimensionPrimary"));
            directionPrimary = Direction.m_122376_((int)tag.m_128451_("directionPrimary"));
            openingPrimary = tag.m_128451_("openingPrimary");
        }
        BlockPos posSecondary = null;
        boolean wallSecondary = false;
        boolean ceilingSecondary = false;
        ResourceKey<Level> dimensionSecondary = null;
        Direction directionSecondary = null;
        int openingSecondary = 0;
        if (tag.m_128441_("posSecondary")) {
            posSecondary = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("posSecondary"));
            wallSecondary = tag.m_128471_("wallSecondary");
            ceilingSecondary = tag.m_128471_("ceilingSecondary");
            dimensionSecondary = PortalLink.stringToDimension(tag.m_128461_("dimensionSecondary"));
            directionSecondary = Direction.m_122376_((int)tag.m_128451_("directionSecondary"));
            openingSecondary = tag.m_128451_("openingSecondary");
        }
        ResourceLocation variantKey = ResourceLocation.parse((String)tag.m_128461_("variantKey"));
        int primaryPortalColor = tag.m_128451_("primaryPortalColor");
        int secondaryPortalColor = tag.m_128451_("secondaryPortalColor");
        PortalLink link = new PortalLink(linkID, posPrimary, posSecondary, wallPrimary, wallSecondary, ceilingPrimary, ceilingSecondary, dimensionPrimary, dimensionSecondary, directionPrimary, directionSecondary, variantKey, primaryPortalColor, secondaryPortalColor);
        link.openingPrimary = openingPrimary;
        link.openingSecondary = openingSecondary;
        return link;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("link", this.linkID);
        if (this.posPrimary != null) {
            tag.m_128365_("posPrimary", (Tag)NbtUtils.m_129224_((BlockPos)this.posPrimary));
            tag.m_128379_("wallPrimary", this.wallPrimary);
            tag.m_128379_("ceilingPrimary", this.ceilingPrimary);
            tag.m_128359_("dimensionPrimary", this.dimensionPrimary.m_135782_().toString());
            tag.m_128405_("directionPrimary", this.directionPrimary.m_122411_());
            tag.m_128405_("openingPrimary", this.openingPrimary);
        }
        if (this.posSecondary != null) {
            tag.m_128365_("posSecondary", (Tag)NbtUtils.m_129224_((BlockPos)this.posSecondary));
            tag.m_128379_("wallSecondary", this.wallSecondary);
            tag.m_128379_("ceilingSecondary", this.ceilingSecondary);
            tag.m_128359_("dimensionSecondary", this.dimensionSecondary.m_135782_().toString());
            tag.m_128405_("directionSecondary", this.directionSecondary.m_122411_());
            tag.m_128405_("openingSecondary", this.openingSecondary);
        }
        if (this.variantKey == null) {
            this.variantKey = ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"chell");
        }
        tag.m_128359_("variantKey", this.variantKey.toString());
        tag.m_128405_("primaryPortalColor", this.primaryPortalColor);
        tag.m_128405_("secondaryPortalColor", this.secondaryPortalColor);
        return tag;
    }

    public PortalGunVariant getGunVariant(Level level) {
        Registry registry = level.m_7654_().m_206579_().m_175515_(PortalGunVariant.REGISTRY_KEY);
        return (PortalGunVariant)registry.m_7745_(this.variantKey);
    }

    public static ResourceKey<Level> stringToDimension(String dimensionString) {
        String[] split = dimensionString.split(":");
        if (split.length > 1) {
            return ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("minecraft", "dimension")), (ResourceLocation)new ResourceLocation(split[0], split[1]));
        }
        return null;
    }

    private /* synthetic */ LevelChunk lambda$resetSecondary$3(Level portalLevel) {
        return portalLevel.m_46745_(this.posSecondary);
    }

    private /* synthetic */ LevelChunk lambda$resetPrimary$2(Level portalLevel) {
        return portalLevel.m_46745_(this.posPrimary);
    }

    private static /* synthetic */ LevelChunk lambda$createSecondaryPortal$1(Level portalLevel, BlockPos pos) {
        return portalLevel.m_46745_(pos);
    }

    private static /* synthetic */ LevelChunk lambda$createPrimaryPortal$0(Level portalLevel, BlockPos pos) {
        return portalLevel.m_46745_(pos);
    }
}

