/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.portal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.network.PacketDistributor;
import net.mistersecret312.aperture_innovations.datapack.PortalGunVariant;
import net.mistersecret312.aperture_innovations.init.NetworkInit;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.network.ClientBoundPortalLinkSyncPacket;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.PortalLink;

public class PortalLinkData
extends SavedData {
    private static final String FILE_NAME = "aperture_innovations-portal_links";
    private static final String PORTAL_LINK = "portal_links";
    public HashMap<UUID, PortalLink> portalLinks = new HashMap();
    private MinecraftServer server;

    private CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(PORTAL_LINK, (Tag)this.serializePortalLinkData());
        return tag;
    }

    private CompoundTag serializePortalLinkData() {
        CompoundTag objectsTag = new CompoundTag();
        this.portalLinks.forEach((uuid, pad) -> objectsTag.m_128365_(uuid.toString(), (Tag)pad.save()));
        return objectsTag;
    }

    private void deserialize(CompoundTag tag) {
        this.deserializePortalLinkData(tag.m_128469_(PORTAL_LINK));
    }

    private void deserializePortalLinkData(CompoundTag tag) {
        for (String key : tag.m_128431_()) {
            this.portalLinks.put(UUID.fromString(key), PortalLink.load(tag.m_128469_(key)));
        }
    }

    public void addFreshLink(UUID uuid) {
        Registry registry = this.server.m_206579_().m_175515_(PortalGunVariant.REGISTRY_KEY);
        List variants = registry.m_6579_().stream().toList();
        ResourceLocation location = ((ResourceKey)((Map.Entry)variants.get(this.server.m_129783_().m_213780_().m_188503_(variants.size()))).getKey()).m_135782_();
        this.portalLinks.put(uuid, new PortalLink(uuid, location));
        this.m_77762_();
    }

    public PortalLink getLink(UUID uuid) {
        return this.portalLinks.get(uuid);
    }

    @Nullable
    public PortalLink getLink(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof PortalGunItem) {
            PortalGunItem portalGun = (PortalGunItem)item;
            return this.portalLinks.get(portalGun.getUUID(stack, true));
        }
        return null;
    }

    public void m_77762_() {
        super.m_77762_();
        NetworkInit.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientBoundPortalLinkSyncPacket(this.portalLinks, new HashMap<UUID, ClientPortalLink>()));
    }

    public PortalLinkData(MinecraftServer server) {
        this.server = server;
    }

    public static PortalLinkData create(MinecraftServer server) {
        return new PortalLinkData(server);
    }

    public static PortalLinkData load(MinecraftServer server, CompoundTag tag) {
        PortalLinkData data = PortalLinkData.create(server);
        data.server = server;
        data.deserialize(tag);
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = this.serialize();
        return tag;
    }

    @Nonnull
    public static PortalLinkData get(Level level) {
        if (level.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return PortalLinkData.get(level.m_7654_());
    }

    @Nonnull
    public static PortalLinkData get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (PortalLinkData)storage.m_164861_(tag -> PortalLinkData.load(server, tag), () -> PortalLinkData.create(server), FILE_NAME);
    }
}

