/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.portal;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;

public class PortalPlacement {
    public static Result getBestPlacement(Level level, BlockHitResult hit, Player player, UUID uuid, boolean isPrimary) {
        BlockPos hitPos = hit.m_82425_();
        Direction face = hit.m_82434_();
        Direction rotation = face.m_122434_().m_122478_() ? player.m_6350_() : Direction.UP;
        BlockPos tryBottomPos = !face.m_122434_().m_122478_() ? hitPos.m_121945_(rotation.m_122424_()) : (face.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE) ? hitPos.m_121945_(rotation.m_122424_()) : hitPos.m_121945_(rotation));
        if (PortalPlacement.isValidSpot(level, tryBottomPos, rotation, face, uuid, isPrimary)) {
            return new Result(tryBottomPos, rotation, face);
        }
        tryBottomPos = hitPos;
        if (face.m_122434_().m_122478_() && face.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE)) {
            tryBottomPos = hitPos;
        }
        if (PortalPlacement.isValidSpot(level, tryBottomPos, rotation, face, uuid, isPrimary)) {
            return new Result(tryBottomPos, rotation, face);
        }
        return null;
    }

    private static boolean isValidSpot(Level level, BlockPos bottomPos, Direction rotation, Direction face, UUID uuid, boolean isPrimary) {
        BlockPos topPos = face.m_122434_().m_122478_() ? (face.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE) ? bottomPos.m_121945_(rotation) : bottomPos.m_121945_(rotation.m_122424_())) : bottomPos.m_121945_(rotation);
        BlockPos portalBottom = bottomPos.m_121945_(face);
        BlockPos portalTop = topPos.m_121945_(face);
        if (level.m_8055_(bottomPos).m_60795_() || level.m_8055_(topPos).m_60795_()) {
            return false;
        }
        if (!PortalPlacement.isReplaceable(level, portalBottom) || !PortalPlacement.isReplaceable(level, portalTop)) {
            return false;
        }
        if (!level.m_8055_(bottomPos).m_60783_((BlockGetter)level, bottomPos, face) || !level.m_8055_(topPos).m_60783_((BlockGetter)level, topPos, face)) {
            return false;
        }
        return !PortalPlacement.hasExistingPortal(level, portalBottom, uuid, isPrimary) && !PortalPlacement.hasExistingPortal(level, portalTop, uuid, isPrimary);
    }

    private static boolean isReplaceable(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60795_() || state.m_247087_();
    }

    private static boolean hasExistingPortal(Level level, BlockPos pos, UUID uuid, boolean isPrimary) {
        AtomicBoolean found = new AtomicBoolean(false);
        PortalUtilities.getPortalLinks(level).forEach((entryID, portalLink) -> {
            for (int i = 0; i < 2; ++i) {
                boolean onCeiling;
                boolean onWall;
                Direction portalDirection;
                AABB portalBox;
                Vec3 portalPos;
                boolean entryPrimarity;
                boolean bl = entryPrimarity = i == 0;
                if (uuid.equals(entryID) && entryPrimarity == isPrimary || (portalPos = PortalUtilities.getPortalPos(level, entryID, entryPrimarity)) == null || !(portalBox = PortalUtilities.getPortalTeleportBox(portalPos, portalDirection = PortalUtilities.getPortalDirection(level, entryID, entryPrimarity), onWall = PortalUtilities.isPortalOnWall(level, entryID, entryPrimarity), onCeiling = PortalUtilities.isPortalOnCeiling(level, entryID, entryPrimarity))).m_82381_(new AABB(pos))) continue;
                found.set(true);
            }
        });
        return found.get();
    }

    public static class Result {
        public BlockPos bottomPos;
        public Direction rotation;
        public Direction facing;

        public Result(BlockPos pos, Direction rot, Direction face) {
            this.bottomPos = pos;
            this.rotation = rot;
            this.facing = face;
        }
    }
}

