/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.sounds;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;

public class PortalSound<T extends ClientPortalLink>
extends AbstractTickableSoundInstance {
    protected T link;
    protected BlockPos portalPos;
    protected Minecraft minecraft = Minecraft.m_91087_();
    protected int fullDistance;
    protected int maxDistance;

    public PortalSound(T link, boolean isPrimary, SoundEvent soundEvent, int fullDistance, int maxDistance) {
        super(soundEvent, SoundSource.AMBIENT, SoundInstance.m_235150_());
        this.link = link;
        BlockPos blockPos = this.portalPos = isPrimary ? ((ClientPortalLink)link).posPrimary() : ((ClientPortalLink)link).posSecondary();
        if (this.portalPos == null) {
            this.portalPos = this.minecraft.f_91074_.m_20097_();
        }
        this.f_119582_ = true;
        this.fullDistance = fullDistance;
        this.maxDistance = maxDistance;
    }

    public void m_7788_() {
        if (this.link == null || this.portalPos == null) {
            this.m_119609_();
        }
    }

    public boolean m_7784_() {
        return true;
    }

    public void stopSound() {
        this.m_119609_();
    }

    public double getDistanceFromSource() {
        LocalPlayer player = this.minecraft.f_91074_;
        Vec3 playerPos = player.m_20182_();
        return this.portalPos.m_252807_().m_82554_(playerPos);
    }

    public float m_7769_() {
        float localVolume = 0.0f;
        double distanceFromSource = this.getDistanceFromSource();
        float fullDistance = this.fullDistance;
        float maxDistance = this.maxDistance;
        if (fullDistance >= maxDistance) {
            maxDistance = fullDistance + 1.0f;
        }
        if (fullDistance >= maxDistance) {
            maxDistance = fullDistance + 1.0f;
        }
        localVolume = distanceFromSource <= (double)fullDistance ? this.getMaxVolume() : (distanceFromSource <= (double)maxDistance ? (float)((double)this.getMaxVolume() - (distanceFromSource - (double)fullDistance) / (double)(maxDistance - fullDistance)) : this.getMinVolume());
        return super.m_7769_() * localVolume;
    }

    public float getMaxVolume() {
        return 1.0f;
    }

    public float getMinVolume() {
        return 0.0f;
    }
}

