/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria;

import com.google.common.collect.ImmutableList;
import com.idark.valoria.Valoria;
import com.idark.valoria.api.events.SoulEvent;
import com.idark.valoria.api.unlockable.UnlockUtils;
import com.idark.valoria.api.unlockable.Unlockables;
import com.idark.valoria.api.unlockable.types.OnMobKilledListener;
import com.idark.valoria.api.unlockable.types.Unlockable;
import com.idark.valoria.client.ui.screen.book.codex.CodexEntries;
import com.idark.valoria.client.ui.screen.book.codex.checklist.BossEntryLoader;
import com.idark.valoria.core.capability.IMagmaLevel;
import com.idark.valoria.core.capability.INihilityLevel;
import com.idark.valoria.core.capability.IUnlockable;
import com.idark.valoria.core.capability.MagmaLevelCap;
import com.idark.valoria.core.capability.MagmaLevelProvider;
import com.idark.valoria.core.capability.NihilityLevelCap;
import com.idark.valoria.core.capability.NihilityLevelProvider;
import com.idark.valoria.core.capability.UnloackbleCap;
import com.idark.valoria.core.config.CommonConfig;
import com.idark.valoria.core.interfaces.CritDamageItem;
import com.idark.valoria.core.interfaces.ILivingEntityData;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.MagmaPacket;
import com.idark.valoria.core.network.packets.NihilityPacket;
import com.idark.valoria.core.network.packets.UnlockableUpdatePacket;
import com.idark.valoria.core.network.packets.particle.SoulCollectParticlePacket;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.ItemTierRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.registries.effect.AbstractImmunityEffect;
import com.idark.valoria.registries.entity.ElementalTypes;
import com.idark.valoria.registries.item.armor.ArmorRegistry;
import com.idark.valoria.registries.item.armor.item.HitEffectArmorItem;
import com.idark.valoria.registries.item.types.SoulCollectorItem;
import com.idark.valoria.registries.item.types.consumables.ValoriaFood;
import com.idark.valoria.registries.item.types.elemental.EtherealSwordItem;
import com.idark.valoria.registries.level.LevelGen;
import com.idark.valoria.registries.level.events.MagmaEvent;
import com.idark.valoria.registries.level.events.NihilityEvent;
import com.idark.valoria.util.Pal;
import com.idark.valoria.util.ValoriaUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.interfaces.OverlayRenderItem;
import pro.komaru.tridot.api.render.text.DotStyleEffects;
import pro.komaru.tridot.client.gfx.text.DotStyle;
import pro.komaru.tridot.common.registry.item.armor.SuitArmorItem;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class Events {
    public ArcRandom arcRandom = Tmp.rnd;

    @SubscribeEvent
    public static void onMissingMappings(MissingMappingsEvent event) {
        String newId;
        String oldId;
        block30: for (MissingMappingsEvent.Mapping mapping : event.getMappings(ForgeRegistries.Keys.BLOCKS, "valoria")) {
            switch (oldId = mapping.getKey().m_135815_()) {
                case "shadewood": {
                    mapping.remap((Object)((Block)BlockRegistry.shadeWood.get()));
                    continue block30;
                }
                case "stripped_shadewood": {
                    mapping.remap((Object)((Block)BlockRegistry.strippedShadeWood.get()));
                    continue block30;
                }
                case "stripped_shadelog": {
                    mapping.remap((Object)((Block)BlockRegistry.strippedShadeLog.get()));
                    continue block30;
                }
                case "shadelog": {
                    mapping.remap((Object)((Block)BlockRegistry.shadeLog.get()));
                    continue block30;
                }
                case "trapped_shadewood_chest": {
                    mapping.remap((Object)((Block)BlockRegistry.shadeTrappedChest.get()));
                    continue block30;
                }
                case "potted_shadewood_sappling": {
                    mapping.remap((Object)((Block)BlockRegistry.pottedShadewoodSapling.get()));
                    continue block30;
                }
            }
            if (oldId.startsWith("dreadwood_")) {
                newId = oldId.replace("dreadwood_", "dread_");
                Block newItem = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("valoria", newId));
                if (newItem != null) {
                    mapping.remap((Object)newItem);
                    Valoria.LOGGER.error("[REMAP] Remmaping: {} to {}", (Object)oldId, (Object)newId);
                } else {
                    mapping.ignore();
                }
            }
            if (!oldId.startsWith("shadewood_")) continue;
            newId = oldId.replace("shadewood_", "shade_");
            Block newBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("valoria", newId));
            if (newBlock != null) {
                mapping.remap((Object)newBlock);
                Valoria.LOGGER.error("[REMAP] Remmaping: {} to {}", (Object)oldId, (Object)newId);
                continue;
            }
            mapping.ignore();
        }
        block31: for (MissingMappingsEvent.Mapping mapping : event.getMappings(ForgeRegistries.Keys.ITEMS, "valoria")) {
            switch (oldId = mapping.getKey().m_135815_()) {
                case "shadewood": {
                    mapping.remap((Object)((Block)BlockRegistry.shadeWood.get()).m_5456_());
                    continue block31;
                }
                case "stripped_shadewood": {
                    mapping.remap((Object)((Block)BlockRegistry.strippedShadeWood.get()).m_5456_());
                    continue block31;
                }
                case "stripped_shadelog": {
                    mapping.remap((Object)((Block)BlockRegistry.strippedShadeLog.get()).m_5456_());
                    continue block31;
                }
                case "shadelog": {
                    mapping.remap((Object)((Block)BlockRegistry.shadeLog.get()).m_5456_());
                    continue block31;
                }
                case "trapped_shadewood_chest": {
                    mapping.remap((Object)((Block)BlockRegistry.shadeTrappedChest.get()).m_5456_());
                    continue block31;
                }
            }
            if (oldId.startsWith("dreadwood_")) {
                newId = oldId.replace("dreadwood_", "dread_");
                Item newItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("valoria", newId));
                if (newItem != null) {
                    mapping.remap((Object)newItem);
                    Valoria.LOGGER.error("[REMAP] Remmaping: {} to {}", (Object)oldId, (Object)newId);
                } else {
                    mapping.ignore();
                }
            }
            if (!oldId.startsWith("shadewood_")) continue;
            newId = oldId.replace("shadewood_", "shade_");
            Item newItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("valoria", newId));
            if (newItem != null) {
                mapping.remap((Object)newItem);
                Valoria.LOGGER.error("[REMAP] Remmaping: {} to {}", (Object)oldId, (Object)newId);
                continue;
            }
            mapping.ignore();
        }
    }

    @SubscribeEvent
    public void onReload(AddReloadListenerEvent event) {
        Valoria.LOGGER.info("Reloading Codex Chapters...");
        CodexEntries.initChapters();
        event.addListener((PreparableReloadListener)BossEntryLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        int foodRot;
        TieredItem tiered;
        Item list;
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("poison_hits")) {
            int hits = stack.m_41783_().m_128451_("poison_hits");
            list = ImmutableList.of((Object)new MobEffectInstance(MobEffects.f_19614_, 120, 0));
            tooltip.add(Component.m_237110_((String)"tooltip.valoria.poisoned", (Object[])new Object[]{hits}).m_130940_(ChatFormatting.GRAY));
            Utils.Items.effectTooltip((ImmutableList)list, (List)tooltip, (float)1.0f, (float)1.0f);
        }
        if (Unlockables.getUnlockableByItem(stack.m_41720_()).isPresent()) {
            if (Screen.m_96637_()) {
                tooltip.add(Component.m_237110_((String)"tooltip.valoria.open", (Object[])new Object[]{Component.m_237115_((String)"key.keyboard.left.control"), Component.m_237115_((String)"key.mouse.right")}).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add(Component.m_237110_((String)"tooltip.valoria.info", (Object[])new Object[]{Component.m_237115_((String)"key.keyboard.left.control")}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        if ((list = stack.m_41720_()) instanceof TieredItem && (tiered = (TieredItem)list).m_43314_() == ItemTierRegistry.HALLOWEEN) {
            tooltip.add(1, Component.m_237110_((String)"tooltip.valoria.soul_on_kill", (Object[])new Object[]{2}).m_130940_(ChatFormatting.AQUA).m_130938_(style -> style.m_131150_(Valoria.FONT)));
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("ValoriaRot") && (foodRot = ValoriaUtils.getCurrentNBTValue("ValoriaRot", stack)) > 0) {
            ChatFormatting color;
            String stageKey;
            if (foodRot >= 60) {
                stageKey = "tooltip.valoria.stage.rotting";
                color = ChatFormatting.RED;
            } else if (foodRot >= 30) {
                stageKey = "tooltip.valoria.stage.stale";
                color = ChatFormatting.YELLOW;
            } else {
                stageKey = "tooltip.valoria.stage.fresh";
                color = ChatFormatting.GREEN;
            }
            MutableComponent status = Component.m_237115_((String)stageKey).m_130940_(color);
            MutableComponent line = Component.m_237110_((String)"tooltip.valoria.rot_status", (Object[])new Object[]{status, foodRot}).m_130940_(ChatFormatting.GRAY);
            tooltip.add(1, line);
        }
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        Entity entity;
        int hits;
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        if (event.isCancelable() && player.m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("poison_hits") && (hits = stack.m_41783_().m_128451_("poison_hits")) > 0 && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 0));
            stack.m_41783_().m_128405_("poison_hits", hits - 1);
            if (hits - 1 == 0) {
                stack.m_41783_().m_128473_("poison_hits");
            }
        }
        for (ItemStack armorPiece : player.m_6168_()) {
            Item item = armorPiece.m_41720_();
            if (!(item instanceof HitEffectArmorItem)) continue;
            HitEffectArmorItem hitEffect = (HitEffectArmorItem)item;
            if (player.m_9236_().f_46443_) continue;
            hitEffect.onAttack(event);
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent ev) {
        Player player = ev.getEntity();
        player.getCapability(INihilityLevel.INSTANCE).ifPresent(nihilityLevel -> nihilityLevel.setAmountFromServer((LivingEntity)player, 0.0f));
        player.getCapability(IMagmaLevel.INSTANCE).ifPresent(nihilityLevel -> nihilityLevel.setAmountFromServer((LivingEntity)player, 0.0f));
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (event.getTo() == LevelGen.VALORIA_KEY) {
            this.onValoriaEnter(player);
        }
    }

    public void onValoriaEnter(Player player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ResourceLocation loc = Valoria.loc("advancements/valoria/visit_the_valoria.json");
                Advancement adv = s.m_7654_().m_129889_().m_136041_(loc);
                if (adv == null) {
                    return;
                }
                if (!sp.m_8960_().m_135996_(adv).m_8193_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.valoria.nihility").m_130948_((Style)DotStyle.of().effects(new DotStyle.StyleEffect[]{DotStyleEffects.WaveFX.of((float)0.25f, (float)0.1f), DotStyleEffects.OutlineFX.of((Col)Pal.amethyst, (boolean)true)})), true);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!player.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (((Boolean)CommonConfig.NIHILITY.get()).booleanValue()) {
                player.getCapability(INihilityLevel.INSTANCE).ifPresent(nihilityLevel -> {
                    if (!player.m_150110_().f_35937_ && !player.m_5833_()) {
                        NihilityEvent.tick(event, nihilityLevel, player);
                    }
                });
            }
            player.getCapability(IMagmaLevel.INSTANCE).ifPresent(magmaLevel -> {
                if (!player.m_150110_().f_35937_ && !player.m_5833_()) {
                    MagmaEvent.tick(event, magmaLevel, player);
                }
            });
            if (player.f_19797_ % 60 == 0) {
                ArrayList<Unlockable> all = new ArrayList<Unlockable>(Unlockables.get());
                Set<Unlockable> unlocked = UnlockUtils.getUnlocked((Player)serverPlayer);
                if (unlocked != null) {
                    all.removeAll(unlocked);
                }
                for (Unlockable unknown : all) {
                    unknown.tick(serverPlayer);
                }
            }
        }
        if (((Boolean)CommonConfig.NIHILITY.get()).booleanValue() && player.m_9236_().m_5776_()) {
            player.getCapability(INihilityLevel.INSTANCE).ifPresent(nihilityLevel -> NihilityEvent.clientTick(nihilityLevel, player));
        }
        if (((Boolean)CommonConfig.FOOD_ROT.get()).booleanValue() && player.m_9236_().m_46472_().equals(LevelGen.VALORIA_KEY) && player.f_19797_ % 60 == 0) {
            Inventory inv = player.m_150109_();
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (!stack.m_41614_() || stack.m_41780_() != UseAnim.EAT || stack.m_41720_() instanceof ValoriaFood) continue;
                CompoundTag tag = stack.m_41784_();
                ValoriaUtils.addNBT("ValoriaRot", 1, 100, stack);
                int rot = tag.m_128451_("ValoriaRot");
                if (rot == 100) {
                    Events.convertToRot(event, stack, inv, i);
                    continue;
                }
                tag.m_128405_("ValoriaRot", rot);
                stack.m_41751_(tag);
            }
        }
    }

    private static void convertToRot(TickEvent.PlayerTickEvent event, ItemStack stack, Inventory inv, int i) {
        ItemStack rotStack = new ItemStack((ItemLike)ItemsRegistry.rot.get());
        CompoundTag tag = rotStack.m_41784_();
        rotStack.m_41751_(tag.m_6426_());
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (key == null) {
            return;
        }
        tag.m_128359_("OriginalItem", key.toString());
        rotStack.m_41751_(tag);
        rotStack.m_41764_(stack.m_41613_());
        inv.m_6836_(i, rotStack);
        event.player.m_216990_(SoundEvents.f_215689_);
    }

    @SubscribeEvent
    public void onFluid(BlockEvent.FluidPlaceBlockEvent e) {
        ServerLevel level;
        LevelAccessor levelAccessor;
        if ((e.getNewState().m_204336_(Tags.Blocks.STONE) || e.getNewState().m_204336_(Tags.Blocks.COBBLESTONE)) && (levelAccessor = e.getLevel()) instanceof ServerLevel && (level = (ServerLevel)levelAccessor).m_46472_() == LevelGen.VALORIA_KEY) {
            e.setNewState(((Block)BlockRegistry.picrite.get()).m_49966_());
        }
    }

    @SubscribeEvent
    public void convertEvent(LivingConversionEvent.Pre ev) {
        Zombie zombie;
        LivingEntity livingEntity = ev.getEntity();
        if (livingEntity instanceof Zombie && (zombie = (Zombie)livingEntity).m_9236_().m_204166_(zombie.m_20183_()).m_203656_(Tags.Biomes.IS_SWAMP)) {
            zombie.m_21406_((EntityType)EntityTypeRegistry.SWAMP_WANDERER.get(), false);
        }
    }

    @SubscribeEvent
    public void attachEntityCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("valoria", "pages"), (ICapabilityProvider)new UnloackbleCap());
            event.addCapability(new ResourceLocation("valoria", "nihility_level"), (ICapabilityProvider)new NihilityLevelCap());
            event.addCapability(new ResourceLocation("valoria", "magma_level"), (ICapabilityProvider)new MagmaLevelCap());
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingBlockDestroy(LivingDestroyBlockEvent event) {
        if (event.getEntity().m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerBlockDestroy(PlayerEvent.BreakSpeed event) {
        if (event.getEntity().m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setNewSpeed(-1.0f);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (event.getEntity().m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMobKilled(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LivingEntity victim = event.getEntity();
            ArrayList<Unlockable> all = new ArrayList<Unlockable>(Unlockables.get());
            Set<Unlockable> unlocked = UnlockUtils.getUnlocked((Player)player);
            if (unlocked != null) {
                all.removeAll(unlocked);
            }
            for (Unlockable unknown : all) {
                if (!(unknown instanceof OnMobKilledListener)) continue;
                OnMobKilledListener entityU = (OnMobKilledListener)((Object)unknown);
                entityU.checkCondition(player, victim);
            }
        }
    }

    @SubscribeEvent
    public void onEffectApply(MobEffectEvent.Applicable event) {
        AbstractImmunityEffect immunityEffect;
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        MobEffect mobEffect = effect.m_19544_();
        if (mobEffect instanceof AbstractImmunityEffect && (immunityEffect = (AbstractImmunityEffect)mobEffect).effectRemoveReason(entity)) {
            event.setResult(Event.Result.DENY);
        }
        if (effect.m_19544_() == MobEffects.f_19614_ && ValoriaUtils.isEquippedCurio(TagsRegistry.POISON_IMMUNE, entity)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.getSource().m_269533_(DamageTypeTags.f_268490_)) {
            return;
        }
        Entity attackerEntity = event.getSource().m_7639_();
        if (!(attackerEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)attackerEntity;
        LivingEntity target = event.getEntity();
        float totalBonus = 0.0f;
        if (!(attacker instanceof Player) || !(target instanceof Player)) {
            for (AttributeReg.ElementalType type : ElementalTypes.ELEMENTALS) {
                AttributeInstance attackAttr = attacker.m_21051_((Attribute)type.damageAttr().get());
                AttributeInstance resistAttr = target.m_21051_((Attribute)type.resistAttr().get());
                if (attackAttr == null) continue;
                totalBonus = Events.applyAttackBonus(attackAttr, resistAttr, target, totalBonus);
            }
        }
        event.setAmount(event.getAmount() + totalBonus);
    }

    private static float applyAttackBonus(AttributeInstance attackAttr, AttributeInstance resistAttr, LivingEntity target, float totalBonus) {
        float damage = (float)attackAttr.m_22135_();
        float resistance = (float)(resistAttr != null ? resistAttr.m_22135_() : 0.0);
        boolean flag = attackAttr.m_22099_() != AttributeReg.NIHILITY_DAMAGE.get() && target.m_21051_((Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get()) != null;
        resistance += (float)(flag ? target.m_21133_((Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get()) : 0.0);
        if (attackAttr.m_22099_() == AttributeReg.NIHILITY_DAMAGE.get()) {
            target.getCapability(INihilityLevel.INSTANCE).ifPresent(nihility -> nihility.modifyAmount(target, damage));
        }
        float multiplier = Math.max(1.0f - resistance / 100.0f, 0.0f);
        return totalBonus += damage * multiplier;
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        LivingEntity e;
        Player player;
        ILivingEntityData data;
        DamageSource pSource = event.getSource();
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        Entity entity2 = pSource.m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            data = (ILivingEntityData)entity;
            if (level instanceof ServerLevel) {
                Player player2;
                ServerLevel s = (ServerLevel)level;
                Vec3 pushDirection = new Vec3(entity.m_20185_() + attacker.m_20185_(), 0.0, entity.m_20189_() + attacker.m_20185_()).m_82541_();
                if (attacker.m_21051_((Attribute)AttributeReg.MISS_CHANCE.get()) != null && Tmp.rnd.chance(attacker.m_21133_((Attribute)AttributeReg.MISS_CHANCE.get()) / 100.0)) {
                    level.m_247517_(null, attacker.m_20183_(), (SoundEvent)SoundsRegistry.MISS.get(), SoundSource.HOSTILE);
                    s.m_8767_((ParticleOptions)ParticleTypes.f_123762_, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), 16, 1.0, 1.0, 1.0, (double)0.025f);
                    data.valoria$missTime(10);
                    if (attacker instanceof Player) {
                        player2 = (Player)attacker;
                        player2.m_5661_((Component)Component.m_237115_((String)"popup.valoria.miss"), true);
                    }
                    event.setCanceled(true);
                }
                if (entity.m_21051_((Attribute)AttributeReg.DODGE_CHANCE.get()) != null && Tmp.rnd.chance(entity.m_21133_((Attribute)AttributeReg.DODGE_CHANCE.get()) / 100.0)) {
                    level.m_247517_(null, entity.m_20183_(), (SoundEvent)SoundsRegistry.DODGE.get(), SoundSource.HOSTILE);
                    Events.knockbackEntity(entity, pushDirection.m_82548_());
                    s.m_8767_((ParticleOptions)ParticleTypes.f_123808_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 16, 1.0, 1.0, 1.0, (double)0.025f);
                    data.valoria$dodgeTime(10);
                    if (entity instanceof Player) {
                        player2 = (Player)entity;
                        player2.m_5661_((Component)Component.m_237115_((String)"popup.valoria.dodge"), true);
                    }
                    event.setCanceled(true);
                }
            }
        }
        if (entity instanceof Player) {
            Player plr = (Player)entity;
            if ((pSource.m_276093_(DamageTypes.f_268565_) || pSource.m_276093_(DamageTypes.f_268448_)) && SuitArmorItem.hasCorrectArmorOn((ArmorMaterial)ArmorRegistry.PYRATITE, (Player)plr)) {
                event.setCanceled(true);
            }
        }
        if (pSource.m_276093_(DamageTypes.f_268546_) || pSource.m_276093_(DamageTypes.f_268631_) || pSource.m_276093_(DamageTypes.f_268468_) || pSource.m_276093_(DamageTypes.f_268434_) || pSource.m_276093_(DamageTypes.f_268556_) || pSource.m_276093_(DamageTypes.f_268684_)) {
            if (ValoriaUtils.isEquippedCurio(TagsRegistry.FIRE_IMMUNE, entity)) {
                event.setCanceled(true);
            }
            if (entity instanceof Player) {
                player = (Player)entity;
                player.getCapability(IMagmaLevel.INSTANCE).ifPresent(magmaLevel -> {
                    float max = magmaLevel.getMaxAmount((LivingEntity)player);
                    float amount = magmaLevel.getAmount();
                    if (max <= 0.0f || amount <= 0.0f) {
                        return;
                    }
                    event.setCanceled(true);
                });
            }
        }
        if ((data = pSource.m_7639_()) instanceof LivingEntity && (e = (LivingEntity)data).m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
        if ((data = pSource.m_7640_()) instanceof Player) {
            boolean flag;
            player = (Player)data;
            float f2 = player.m_36403_(0.5f);
            boolean bl = flag = f2 > 0.9f;
            if (ValoriaUtils.isEquippedCurio(TagsRegistry.INFLICTS_FIRE, (LivingEntity)player) && flag) {
                entity.m_20254_(15);
            }
        }
    }

    private static void knockbackEntity(LivingEntity entity, Vec3 pushDirection) {
        entity.f_19864_ = true;
        entity.m_147240_(0.5, pushDirection.f_82479_, pushDirection.f_82481_);
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21124_((MobEffect)EffectsRegistry.STUN.get()) != null) {
            entity.m_20334_(entity.m_20184_().m_7096_(), 0.0, entity.m_20184_().m_7094_());
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (event.isCancelable() && player.m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onUseItem(LivingEntityUseItemEvent event) {
        LivingEntity living = event.getEntity();
        if (event.isCancelable() && living.m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (event.isCancelable() && living.m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        Player living = event.getEntity();
        if (living != null && event.isCancelable() && living.m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.isCancelable() && event.getPlayer().m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent event) {
        float healMultiplier;
        int amplifier;
        float amount = event.getAmount();
        if (event.getEntity().m_21023_((MobEffect)EffectsRegistry.EXHAUSTION.get())) {
            amplifier = event.getEntity().m_21124_((MobEffect)EffectsRegistry.EXHAUSTION.get()).m_19564_();
            healMultiplier = 1.0f - 0.1f * (float)(amplifier + 1);
            healMultiplier = Math.max(0.5f, healMultiplier);
            amount *= healMultiplier;
        }
        if (event.getEntity().m_21023_((MobEffect)EffectsRegistry.RENEWAL.get())) {
            amplifier = event.getEntity().m_21124_((MobEffect)EffectsRegistry.RENEWAL.get()).m_19564_();
            healMultiplier = 1.0f + 0.1f * (float)(amplifier + 1);
            healMultiplier = Math.min(1.5f, healMultiplier);
            amount *= healMultiplier;
        }
        event.setAmount(amount);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectsRegistry.STUN.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerKill(LivingDeathEvent deathEvent) {
        Level level = deathEvent.getEntity().m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity attacker = deathEvent.getSource().m_7639_();
            if (attacker instanceof Player) {
                Player plr = (Player)attacker;
                for (ItemStack itemStack : plr.m_6167_()) {
                    SoulEvent.Added event;
                    Item pos;
                    OverlayRenderItem soul;
                    Item item = itemStack.m_41720_();
                    if (item instanceof SoulCollectorItem) {
                        soul = (SoulCollectorItem)item;
                        pos = deathEvent.getEntity().m_20182_().m_82520_(0.0, (double)(deathEvent.getEntity().m_20206_() / 2.0f), 0.0);
                        PacketHandler.sendToTracking((Level)serverLevel, BlockPos.m_274446_((Position)pos), new SoulCollectParticlePacket(plr.m_20148_(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_()));
                        event = new SoulEvent.Added(plr.m_21205_(), 1);
                        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                            soul.addCount(event.count, itemStack, plr);
                        }
                    }
                    if (!((pos = itemStack.m_41720_()) instanceof EtherealSwordItem)) continue;
                    soul = (EtherealSwordItem)pos;
                    pos = deathEvent.getEntity().m_20182_().m_82520_(0.0, (double)(deathEvent.getEntity().m_20206_() / 2.0f), 0.0);
                    PacketHandler.sendToTracking((Level)serverLevel, BlockPos.m_274446_((Position)pos), new SoulCollectParticlePacket(plr.m_20148_(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_()));
                    event = new SoulEvent.Added(plr.m_21205_(), 1);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) continue;
                    soul.addCount(event.count, itemStack, plr);
                }
            }
        }
    }

    @SubscribeEvent
    public void onSoulCollect(SoulEvent.Added event) {
        TieredItem tiered;
        Item item = event.stack.m_41720_();
        if (item instanceof TieredItem && (tiered = (TieredItem)item).m_43314_() == ItemTierRegistry.HALLOWEEN) {
            event.addCount(2);
        }
    }

    @SubscribeEvent
    public void critDamage(CriticalHitEvent event) {
        ItemStack curioStack;
        boolean flag;
        Player plr = event.getEntity();
        float f2 = plr.m_36403_(0.5f);
        boolean bl = flag = f2 > 0.9f;
        if (flag && plr.m_20096_() && (curioStack = ValoriaUtils.getEquippedCurio(item -> item.m_41720_() instanceof CritDamageItem, (LivingEntity)event.getEntity())) != null) {
            ((CritDamageItem)curioStack.m_41720_()).critDamage(event);
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getEntity().getCapability(IUnlockable.INSTANCE).ifPresent(k -> event.getOriginal().getCapability(IUnlockable.INSTANCE).ifPresent(o -> ((INBTSerializable)k).deserializeNBT((Tag)((CompoundTag)((INBTSerializable)o).serializeNBT()))));
        if (!event.getEntity().m_9236_().f_46443_) {
            PacketHandler.sendTo((ServerPlayer)event.getEntity(), (Object)new UnlockableUpdatePacket(event.getEntity()));
        }
        event.getOriginal().reviveCaps();
        event.getEntity().getCapability(INihilityLevel.INSTANCE).ifPresent(k -> event.getOriginal().getCapability(INihilityLevel.INSTANCE).ifPresent(o -> ((INBTSerializable)k).deserializeNBT((Tag)((CompoundTag)((INBTSerializable)o).serializeNBT()))));
        if (!event.getEntity().m_9236_().f_46443_) {
            PacketHandler.sendTo((ServerPlayer)event.getEntity(), (Object)new NihilityPacket(new NihilityLevelProvider(), (LivingEntity)event.getEntity()));
        }
        event.getOriginal().reviveCaps();
        event.getEntity().getCapability(IMagmaLevel.INSTANCE).ifPresent(k -> event.getOriginal().getCapability(IMagmaLevel.INSTANCE).ifPresent(o -> ((INBTSerializable)k).deserializeNBT((Tag)((CompoundTag)((INBTSerializable)o).serializeNBT()))));
        if (!event.getEntity().m_9236_().f_46443_) {
            PacketHandler.sendTo((ServerPlayer)event.getEntity(), (Object)new MagmaPacket(new MagmaLevelProvider(), (LivingEntity)event.getEntity()));
        }
    }

    @SubscribeEvent
    public void registerCustomAI(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getEntity() instanceof LivingEntity && !event.getLevel().f_46443_ && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            PacketHandler.sendTo((ServerPlayer)event.getEntity(), (Object)new UnlockableUpdatePacket(player));
            player.getCapability(INihilityLevel.INSTANCE).ifPresent(nihility -> {
                nihility.modifyAmount((LivingEntity)player, 1.0f);
                nihility.decrease((LivingEntity)player, 1.0f);
            });
            PacketHandler.sendTo((ServerPlayer)event.getEntity(), (Object)new NihilityPacket(new NihilityLevelProvider(), (LivingEntity)player));
            player.getCapability(IMagmaLevel.INSTANCE).ifPresent(magma -> {
                magma.modifyAmount((LivingEntity)player, 1.0f);
                magma.decrease((LivingEntity)player, 1.0f);
            });
            PacketHandler.sendTo((ServerPlayer)event.getEntity(), (Object)new MagmaPacket(new MagmaLevelProvider(), (LivingEntity)player));
        }
    }
}

