/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria;

import com.google.common.collect.ImmutableMap;
import com.idark.valoria.ClientEvents;
import com.idark.valoria.Events;
import com.idark.valoria.ValoriaClient;
import com.idark.valoria.client.event.KeyBindHandler;
import com.idark.valoria.client.particle.ParticleRegistry;
import com.idark.valoria.client.ui.screen.book.unlockable.RegisterUnlockables;
import com.idark.valoria.core.capability.IMagmaLevel;
import com.idark.valoria.core.capability.INihilityLevel;
import com.idark.valoria.core.capability.IUnlockable;
import com.idark.valoria.core.command.arguments.ModArgumentTypes;
import com.idark.valoria.core.compat.ModCompats;
import com.idark.valoria.core.config.ClientConfig;
import com.idark.valoria.core.config.CommonConfig;
import com.idark.valoria.core.config.ServerConfig;
import com.idark.valoria.core.datagen.BlockStateGen;
import com.idark.valoria.core.datagen.LootTableGen;
import com.idark.valoria.core.datagen.RecipeGen;
import com.idark.valoria.core.loot.conditions.LootConditionsRegistry;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.proxy.ClientProxy;
import com.idark.valoria.core.proxy.ISidedProxy;
import com.idark.valoria.core.proxy.ServerProxy;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.BlockEntitiesRegistry;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.EnchantmentsRegistry;
import com.idark.valoria.registries.EntityStatsRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.ItemTabRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.MenuRegistry;
import com.idark.valoria.registries.MiscRegistry;
import com.idark.valoria.registries.RecipesRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.block.types.ModWoodTypes;
import com.idark.valoria.registries.block.types.SarcophagusBlock;
import com.idark.valoria.registries.entity.living.DraugrEntity;
import com.idark.valoria.registries.entity.living.Goblin;
import com.idark.valoria.registries.entity.living.ShadewoodSpider;
import com.idark.valoria.registries.entity.living.SorcererEntity;
import com.idark.valoria.registries.entity.living.elemental.AbstractDevil;
import com.idark.valoria.registries.entity.living.elemental.Ent;
import com.idark.valoria.registries.entity.living.elemental.KingCrabEntity;
import com.idark.valoria.registries.entity.living.elemental.Scavenger;
import com.idark.valoria.registries.entity.living.elemental.WickedScorpion;
import com.idark.valoria.registries.item.recipe.PotionBrewery;
import com.idark.valoria.registries.item.skins.SkinsRegistry;
import com.idark.valoria.registries.item.types.curio.charm.rune.CurioCurses;
import com.idark.valoria.registries.level.LevelGen;
import com.idark.valoria.registries.level.events.DispenserBehaviours;
import com.idark.valoria.registries.level.events.StructureEvents;
import com.idark.valoria.util.ValoriaUtils;
import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import pro.komaru.tridot.common.registry.item.skins.ISkinProvider;
import pro.komaru.tridot.common.registry.item.skins.SkinRegistryManager;

@Mod(value="valoria")
public class Valoria {
    public static final String ID = "valoria";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation FONT = Valoria.loc("icons");
    public static final ISidedProxy proxy = (ISidedProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static UUID BASE_ENTITY_REACH_UUID = UUID.fromString("c2e6b27c-fff1-4296-a6b2-7cfff13296cf");
    public static UUID BASE_DASH_DISTANCE_UUID = UUID.fromString("b0e5853a-d071-40db-a585-3ad07100db82");
    public static UUID BASE_ATTACK_RADIUS_UUID = UUID.fromString("49438567-6ad2-41bd-8385-676ad2a1bd5e");
    public static UUID BASE_NECROMANCY_LIFETIME_UUID = UUID.fromString("09a12525-61a5-4d57-a125-2561a56d578e");
    public static UUID BASE_NECROMANCY_COUNT_UUID = UUID.fromString("ed80691e-f153-4b5e-8069-1ef153bb5eed");
    public static UUID BASE_NATURE_DAMAGE_UUID = UUID.fromString("15171755-91d0-466e-9717-5591d0b66eba");
    public static UUID BASE_DEPTH_DAMAGE_UUID = UUID.fromString("ff1ed1ea-4a25-462e-9ed1-ea4a25862ef9");
    public static UUID BASE_INFERNAL_DAMAGE_UUID = UUID.fromString("780fa02c-8040-44c7-8fa0-2c804004c776");
    public static UUID BASE_NIHILITY_DAMAGE_UUID = UUID.fromString("8a7e1c44-e461-4692-be1c-44e4618692f6");
    public static UUID BASE_NATURE_RESISTANCE_UUID = UUID.fromString("38289748-ba5b-4ee1-a897-48ba5b3ee15a");
    public static UUID BASE_DEPTH_RESISTANCE_UUID = UUID.fromString("59a7d286-60fc-4a18-a7d2-8660fc9a1803");
    public static UUID BASE_INFERNAL_RESISTANCE_UUID = UUID.fromString("b3198f26-6e76-497b-998f-266e76097b48");
    public static UUID BASE_NIHILITY_RESISTANCE_UUID = UUID.fromString("d54e60fa-ef27-4181-8e60-faef2771814e");
    public static UUID BASE_ELEMENTAL_RESISTANCE_UUID = UUID.fromString("14e99f51-ad2a-4996-a99f-51ad2a0996a0");
    public static final GameRules.Key<GameRules.BooleanValue> DISABLE_BLOCK_BREAKING = GameRules.m_46189_((String)"valoria:disableBossDungeonGriefing", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final GameRules.Key<GameRules.BooleanValue> TRAP_ACTIVATING = GameRules.m_46189_((String)"valoria:trapActivating", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));

    public Valoria() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        EffectsRegistry.register(eventBus);
        EnchantmentsRegistry.register(eventBus);
        MiscRegistry.init(eventBus);
        AttributeReg.register(eventBus);
        PotionBrewery.register(eventBus);
        EntityTypeRegistry.register(eventBus);
        ItemsRegistry.load(eventBus);
        BlockRegistry.load(eventBus);
        LevelGen.init(eventBus);
        LootConditionsRegistry.init(eventBus);
        BlockEntitiesRegistry.register(eventBus);
        RecipesRegistry.register(eventBus);
        MenuRegistry.register(eventBus);
        ParticleRegistry.register(eventBus);
        ModArgumentTypes.register(eventBus);
        SkinRegistryManager.getInstance().registerSkinProvider((ISkinProvider)new SkinsRegistry());
        ItemTabRegistry.register(eventBus);
        SoundsRegistry.register(eventBus);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC);
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            forgeBus.addListener(KeyBindHandler::onInput);
            forgeBus.addListener(Events::onTooltip);
            return new Object();
        });
        eventBus.addListener(ItemTabRegistry::addCreative);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        forgeBus.addListener(Events::onMissingMappings);
        forgeBus.register((Object)this);
        forgeBus.register((Object)new Events());
        forgeBus.register((Object)new StructureEvents());
        if (FMLEnvironment.dist.isClient()) {
            forgeBus.register(ClientEvents.class);
        }
    }

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(ID, path);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ValoriaClient.setupClient(event);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.debug("Item count: {}", (Object)ItemsRegistry.ITEMS.getEntries().size());
        LOGGER.debug("Block count: {}", (Object)BlockRegistry.BLOCK.getEntries().size());
        LOGGER.debug("Entity count: {}", (Object)EntityTypeRegistry.ENTITY_TYPES.getEntries().size());
        RegisterUnlockables.init();
        ItemsRegistry.setupBook();
        PacketHandler.init();
        PotionBrewery.m_43499_();
        DispenserBehaviours.bootStrap();
        event.enqueueWork(() -> {
            ModCompats.init();
            FireBlock fireblock = (FireBlock)Blocks.f_50083_;
            fireblock.m_53444_((Block)BlockRegistry.shadeLog.get(), 5, 20);
            fireblock.m_53444_((Block)BlockRegistry.shadeWood.get(), 5, 20);
            fireblock.m_53444_((Block)BlockRegistry.shadeLeaves.get(), 30, 60);
            fireblock.m_53444_((Block)BlockRegistry.shadePlanksSlab.get(), 5, 40);
            fireblock.m_53444_((Block)BlockRegistry.shadePlanksStairs.get(), 5, 40);
            fireblock.m_53444_((Block)BlockRegistry.shadePlanks.get(), 5, 25);
            fireblock.m_53444_((Block)BlockRegistry.strippedShadeLog.get(), 5, 30);
            fireblock.m_53444_((Block)BlockRegistry.strippedShadeWood.get(), 5, 30);
            fireblock.m_53444_((Block)BlockRegistry.eldritchLog.get(), 5, 20);
            fireblock.m_53444_((Block)BlockRegistry.eldritchWood.get(), 5, 20);
            fireblock.m_53444_((Block)BlockRegistry.eldritchLeaves.get(), 30, 60);
            fireblock.m_53444_((Block)BlockRegistry.eldritchPlanksSlab.get(), 5, 40);
            fireblock.m_53444_((Block)BlockRegistry.eldritchPlanksStairs.get(), 5, 40);
            fireblock.m_53444_((Block)BlockRegistry.eldritchPlanks.get(), 5, 25);
            fireblock.m_53444_((Block)BlockRegistry.strippedEldritchLog.get(), 5, 30);
            fireblock.m_53444_((Block)BlockRegistry.strippedEldritchWood.get(), 5, 30);
            fireblock.m_53444_((Block)BlockRegistry.dreadwoodLog.get(), 5, 20);
            fireblock.m_53444_((Block)BlockRegistry.dreadWood.get(), 5, 20);
            fireblock.m_53444_((Block)BlockRegistry.dreadwoodPlanksSlab.get(), 5, 40);
            fireblock.m_53444_((Block)BlockRegistry.dreadwoodPlanksStairs.get(), 5, 40);
            fireblock.m_53444_((Block)BlockRegistry.dreadwoodPlanks.get(), 5, 25);
            fireblock.m_53444_((Block)BlockRegistry.strippedDreadwoodLog.get(), 5, 30);
            fireblock.m_53444_((Block)BlockRegistry.strippedDreadWood.get(), 5, 30);
            DraugrEntity.spawnable(Items.f_42411_, Items.f_42423_, Items.f_42425_, Items.f_42383_, Items.f_42433_, Items.f_42385_);
            Goblin.spawnable((Item)ItemsRegistry.woodenRapier.get(), (Item)ItemsRegistry.stoneRapier.get(), (Item)ItemsRegistry.ironRapier.get(), (Item)ItemsRegistry.club.get());
            ValoriaUtils.addList(SarcophagusBlock.spawnableWith, Items.f_42411_, Items.f_42423_, Items.f_42425_, Items.f_42383_, Items.f_42433_, Items.f_42385_);
            ValoriaUtils.addList(SarcophagusBlock.halloweenSpawnableWith, Items.f_42046_, Items.f_42055_, Items.f_42047_);
            CurioCurses.effects(MobEffects.f_216964_, MobEffects.f_19613_, MobEffects.f_19615_, MobEffects.f_19614_, MobEffects.f_19597_, MobEffects.f_19599_);
            AxeItem.f_150683_ = new ImmutableMap.Builder().putAll(AxeItem.f_150683_).put((Object)((Block)BlockRegistry.shadeLog.get()), (Object)((Block)BlockRegistry.strippedShadeLog.get())).put((Object)((Block)BlockRegistry.shadeWood.get()), (Object)((Block)BlockRegistry.strippedShadeWood.get())).put((Object)((Block)BlockRegistry.dreadwoodLog.get()), (Object)((Block)BlockRegistry.strippedDreadwoodLog.get())).put((Object)((Block)BlockRegistry.dreadWood.get()), (Object)((Block)BlockRegistry.strippedDreadWood.get())).put((Object)((Block)BlockRegistry.eldritchLog.get()), (Object)((Block)BlockRegistry.strippedEldritchLog.get())).put((Object)((Block)BlockRegistry.eldritchWood.get()), (Object)((Block)BlockRegistry.strippedEldritchWood.get())).build();
            WoodType.m_61844_((WoodType)ModWoodTypes.ELDRITCH);
            WoodType.m_61844_((WoodType)ModWoodTypes.SHADEWOOD);
            WoodType.m_61844_((WoodType)ModWoodTypes.DREADWOOD);
        });
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerCaps(RegisterCapabilitiesEvent event) {
            event.register(IUnlockable.class);
            event.register(INihilityLevel.class);
            event.register(IMagmaLevel.class);
        }

        @SubscribeEvent
        public static void onPlacementRegistry(SpawnPlacementRegisterEvent event) {
            event.register((EntityType)EntityTypeRegistry.GOBLIN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Goblin::checkGoblinSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.DRAUGR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.SWAMP_WANDERER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.SCOURGE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.SHADEWOOD_SPIDER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ShadewoodSpider::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.DEVIL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AbstractDevil::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.HAUNTED_MERCHANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.TROLL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.CORRUPTED_TROLL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.SORCERER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SorcererEntity::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.ENT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Ent::checkEntSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.NATURE_GOLEM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.RIVER_GOLEM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.MAGGOT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.CORRUPTED.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.KING_CRAB.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, KingCrabEntity::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.WICKED_SCORPION.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WickedScorpion::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityTypeRegistry.SCAVENGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Scavenger::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        }

        @SubscribeEvent
        public static void registerAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)EntityTypeRegistry.MANNEQUIN.get(), EntityStatsRegistry.MANNEQUIN);
            event.put((EntityType)EntityTypeRegistry.GOBLIN.get(), EntityStatsRegistry.GOBLIN);
            event.put((EntityType)EntityTypeRegistry.DRAUGR.get(), EntityStatsRegistry.DRAUGR);
            event.put((EntityType)EntityTypeRegistry.NECROMANCER.get(), EntityStatsRegistry.NECROMANCER);
            event.put((EntityType)EntityTypeRegistry.SCOURGE.get(), EntityStatsRegistry.SCOURGE);
            event.put((EntityType)EntityTypeRegistry.SWAMP_WANDERER.get(), EntityStatsRegistry.SWAMP_WANDERER);
            event.put((EntityType)EntityTypeRegistry.UNDEAD.get(), EntityStatsRegistry.UNDEAD);
            event.put((EntityType)EntityTypeRegistry.SHADEWOOD_SPIDER.get(), EntityStatsRegistry.SHADEWOOD_SPIDER);
            event.put((EntityType)EntityTypeRegistry.DEVIL.get(), EntityStatsRegistry.DEVIL);
            event.put((EntityType)EntityTypeRegistry.TROLL.get(), EntityStatsRegistry.TROLL);
            event.put((EntityType)EntityTypeRegistry.CORRUPTED_TROLL.get(), EntityStatsRegistry.CORRUPTED_TROLL);
            event.put((EntityType)EntityTypeRegistry.SORCERER.get(), EntityStatsRegistry.SORCERER);
            event.put((EntityType)EntityTypeRegistry.WICKED_SCORPION.get(), EntityStatsRegistry.WICKED_SCORPION);
            event.put((EntityType)EntityTypeRegistry.WICKED_CRYSTAL.get(), EntityStatsRegistry.WICKED_CRYSTAL);
            event.put((EntityType)EntityTypeRegistry.WICKED_SHIELD.get(), EntityStatsRegistry.WICKED_SHIELD);
            event.put((EntityType)EntityTypeRegistry.CRYSTAL.get(), EntityStatsRegistry.CRYSTAL);
            event.put((EntityType)EntityTypeRegistry.ENT.get(), EntityStatsRegistry.ENT);
            event.put((EntityType)EntityTypeRegistry.NATURE_GOLEM.get(), EntityStatsRegistry.NATURE_GOLEM);
            event.put((EntityType)EntityTypeRegistry.RIVER_GOLEM.get(), EntityStatsRegistry.RIVER_GOLEM);
            event.put((EntityType)EntityTypeRegistry.MAGGOT.get(), EntityStatsRegistry.MAGGOT);
            event.put((EntityType)EntityTypeRegistry.DRYADOR.get(), EntityStatsRegistry.DRYADOR);
            event.put((EntityType)EntityTypeRegistry.PIXIE.get(), EntityStatsRegistry.PIXIE);
            event.put((EntityType)EntityTypeRegistry.CORRUPTED.get(), EntityStatsRegistry.CORRUPTED);
            event.put((EntityType)EntityTypeRegistry.KING_CRAB.get(), EntityStatsRegistry.KING_CRAB);
            event.put((EntityType)EntityTypeRegistry.SCAVENGER.get(), EntityStatsRegistry.SCAVENGER);
            event.put((EntityType)EntityTypeRegistry.FIRRON.get(), EntityStatsRegistry.FIRRON);
            event.put((EntityType)EntityTypeRegistry.HAUNTED_MERCHANT.get(), EntityStatsRegistry.HAUNTED_MERCHANT);
            event.put((EntityType)EntityTypeRegistry.FLESH_SENTINEL.get(), EntityStatsRegistry.FLESH_SENTINEL);
        }

        @SubscribeEvent
        public static void attachAttribute(EntityAttributeModificationEvent event) {
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.DASH_DISTANCE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.ATTACK_RADIUS.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.NECROMANCY_LIFETIME.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.NECROMANCY_COUNT.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.MAX_NIHILITY.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.NIHILITY_RESILIENCE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.MISS_CHANCE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.DODGE_CHANCE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.EXCAVATION_SPEED.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.INFERNAL_DAMAGE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.DEPTH_DAMAGE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.NATURE_DAMAGE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.NIHILITY_DAMAGE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.DEPTH_RESISTANCE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.NATURE_RESISTANCE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.NIHILITY_RESISTANCE.get());
            event.add(EntityType.f_20532_, (Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get());
            if (ModList.get().isLoaded("dummmmmmy")) {
                event.add((EntityType)Dummmmmmy.TARGET_DUMMY.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get());
                event.add((EntityType)Dummmmmmy.TARGET_DUMMY.get(), (Attribute)AttributeReg.DEPTH_RESISTANCE.get());
                event.add((EntityType)Dummmmmmy.TARGET_DUMMY.get(), (Attribute)AttributeReg.NATURE_RESISTANCE.get());
                event.add((EntityType)Dummmmmmy.TARGET_DUMMY.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get());
                event.add((EntityType)Dummmmmmy.TARGET_DUMMY.get(), (Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get());
            }
            event.add((EntityType)EntityTypeRegistry.WICKED_CRYSTAL.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), 45.0);
            event.add((EntityType)EntityTypeRegistry.WICKED_CRYSTAL.get(), (Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get(), 15.0);
            event.add((EntityType)EntityTypeRegistry.DRYADOR.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -25.0);
            event.add((EntityType)EntityTypeRegistry.DRYADOR.get(), (Attribute)AttributeReg.NATURE_RESISTANCE.get(), 50.0);
            event.add((EntityType)EntityTypeRegistry.DRYADOR.get(), (Attribute)AttributeReg.NATURE_DAMAGE.get(), 2.0);
            event.add((EntityType)EntityTypeRegistry.NECROMANCER.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -25.0);
            event.add((EntityType)EntityTypeRegistry.NECROMANCER.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), 15.0);
            event.add((EntityType)EntityTypeRegistry.DEVIL.get(), (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), -15.0);
            event.add((EntityType)EntityTypeRegistry.DEVIL.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), 25.0);
            event.add((EntityType)EntityTypeRegistry.DEVIL.get(), (Attribute)AttributeReg.INFERNAL_DAMAGE.get(), 2.0);
            event.add((EntityType)EntityTypeRegistry.SHADEWOOD_SPIDER.get(), (Attribute)AttributeReg.NATURE_RESISTANCE.get(), 15.0);
            event.add((EntityType)EntityTypeRegistry.SHADEWOOD_SPIDER.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), 25.0);
            event.add((EntityType)EntityTypeRegistry.SHADEWOOD_SPIDER.get(), (Attribute)AttributeReg.NIHILITY_DAMAGE.get(), 1.0);
            event.add((EntityType)EntityTypeRegistry.PIXIE.get(), (Attribute)AttributeReg.NATURE_RESISTANCE.get(), 15.0);
            event.add((EntityType)EntityTypeRegistry.PIXIE.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -25.0);
            event.add((EntityType)EntityTypeRegistry.TROLL.get(), (Attribute)AttributeReg.NATURE_RESISTANCE.get(), 15.0);
            event.add((EntityType)EntityTypeRegistry.TROLL.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -15.0);
            event.add((EntityType)EntityTypeRegistry.CORRUPTED_TROLL.get(), (Attribute)AttributeReg.NATURE_RESISTANCE.get(), -25.0);
            event.add((EntityType)EntityTypeRegistry.CORRUPTED_TROLL.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), 35.0);
            event.add((EntityType)EntityTypeRegistry.CORRUPTED_TROLL.get(), (Attribute)AttributeReg.NIHILITY_DAMAGE.get(), 3.0);
            event.add((EntityType)EntityTypeRegistry.ENT.get(), (Attribute)AttributeReg.NATURE_RESISTANCE.get(), 35.0);
            event.add((EntityType)EntityTypeRegistry.ENT.get(), (Attribute)AttributeReg.NATURE_DAMAGE.get(), 2.0);
            event.add((EntityType)EntityTypeRegistry.ENT.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -25.0);
            event.add((EntityType)EntityTypeRegistry.NATURE_GOLEM.get(), (Attribute)AttributeReg.NATURE_RESISTANCE.get(), 50.0);
            event.add((EntityType)EntityTypeRegistry.NATURE_GOLEM.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -15.0);
            event.add((EntityType)EntityTypeRegistry.RIVER_GOLEM.get(), (Attribute)AttributeReg.NATURE_RESISTANCE.get(), 15.0);
            event.add((EntityType)EntityTypeRegistry.RIVER_GOLEM.get(), (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), 50.0);
            event.add((EntityType)EntityTypeRegistry.RIVER_GOLEM.get(), (Attribute)AttributeReg.DEPTH_DAMAGE.get(), 2.0);
            event.add((EntityType)EntityTypeRegistry.RIVER_GOLEM.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -65.0);
            event.add((EntityType)EntityTypeRegistry.SORCERER.get(), (Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get(), 25.0);
            event.add((EntityType)EntityTypeRegistry.CORRUPTED.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -45.0);
            event.add((EntityType)EntityTypeRegistry.CORRUPTED.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), 35.0);
            event.add((EntityType)EntityTypeRegistry.CORRUPTED.get(), (Attribute)AttributeReg.NIHILITY_DAMAGE.get(), 2.0);
            event.add((EntityType)EntityTypeRegistry.WICKED_SCORPION.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -45.0);
            event.add((EntityType)EntityTypeRegistry.WICKED_SCORPION.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), 65.0);
            event.add((EntityType)EntityTypeRegistry.WICKED_SCORPION.get(), (Attribute)AttributeReg.NIHILITY_DAMAGE.get(), 6.0);
            event.add((EntityType)EntityTypeRegistry.FLESH_SENTINEL.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -45.0);
            event.add((EntityType)EntityTypeRegistry.FLESH_SENTINEL.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), 35.0);
            event.add((EntityType)EntityTypeRegistry.UNDEAD.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -25.0);
            event.add((EntityType)EntityTypeRegistry.UNDEAD.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -25.0);
            event.add((EntityType)EntityTypeRegistry.SCOURGE.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -25.0);
            event.add((EntityType)EntityTypeRegistry.SCOURGE.get(), (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), 25.0);
            event.add((EntityType)EntityTypeRegistry.SCOURGE.get(), (Attribute)AttributeReg.DEPTH_DAMAGE.get(), 2.0);
            event.add((EntityType)EntityTypeRegistry.SWAMP_WANDERER.get(), (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -25.0);
            event.add((EntityType)EntityTypeRegistry.SWAMP_WANDERER.get(), (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), 25.0);
            event.add((EntityType)EntityTypeRegistry.SWAMP_WANDERER.get(), (Attribute)AttributeReg.DEPTH_DAMAGE.get(), 2.0);
            event.add((EntityType)EntityTypeRegistry.DRAUGR.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -15.0);
            event.add((EntityType)EntityTypeRegistry.KING_CRAB.get(), (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -25.0);
            event.add((EntityType)EntityTypeRegistry.KING_CRAB.get(), (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), 50.0);
            event.add((EntityType)EntityTypeRegistry.KING_CRAB.get(), (Attribute)AttributeReg.DEPTH_DAMAGE.get(), 2.0);
            event.add(EntityType.f_20562_, (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), 25.0);
            event.add(EntityType.f_20562_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -25.0);
            event.add(EntityType.f_20458_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -15.0);
            event.add(EntityType.f_20501_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -15.0);
            event.add(EntityType.f_20502_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -15.0);
            event.add(EntityType.f_20530_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -15.0);
            event.add(EntityType.f_20531_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), 35.0);
            event.add(EntityType.f_20524_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -15.0);
            event.add(EntityType.f_20525_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -15.0);
            event.add(EntityType.f_20558_, (Attribute)AttributeReg.NATURE_RESISTANCE.get(), 35.0);
            event.add(EntityType.f_20479_, (Attribute)AttributeReg.NATURE_RESISTANCE.get(), 15.0);
            event.add(EntityType.f_20554_, (Attribute)AttributeReg.NATURE_RESISTANCE.get(), 15.0);
            event.add(EntityType.f_20526_, (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), 35.0);
            event.add(EntityType.f_20468_, (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), -50.0);
            event.add(EntityType.f_20468_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), 25.0);
            event.add(EntityType.f_20468_, (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -25.0);
            event.add(EntityType.f_20496_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), 100.0);
            event.add(EntityType.f_20497_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), 50.0);
            event.add(EntityType.f_20497_, (Attribute)AttributeReg.NATURE_RESISTANCE.get(), -15.0);
            event.add(EntityType.f_20528_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -35.0);
            event.add(EntityType.f_20528_, (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -25.0);
            event.add(EntityType.f_20460_, (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -25.0);
            event.add(EntityType.f_20482_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), 50.0);
            event.add(EntityType.f_20455_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -25.0);
            event.add(EntityType.f_20563_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -50.0);
            event.add(EntityType.f_20455_, (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), 25.0);
            event.add(EntityType.f_20563_, (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), 50.0);
            event.add(EntityType.f_20481_, (Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get(), -15.0);
            event.add(EntityType.f_20481_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -15.0);
            event.add(EntityType.f_20509_, (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -35.0);
            event.add(EntityType.f_20509_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), -15.0);
            event.add(EntityType.f_20453_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), 25.0);
            event.add(EntityType.f_20453_, (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), 25.0);
            event.add(EntityType.f_20453_, (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -25.0);
            event.add(EntityType.f_20551_, (Attribute)AttributeReg.INFERNAL_RESISTANCE.get(), 45.0);
            event.add(EntityType.f_20551_, (Attribute)AttributeReg.DEPTH_RESISTANCE.get(), -25.0);
            event.add(EntityType.f_20491_, (Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get(), -25.0);
            event.add(EntityType.f_217015_, (Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get(), 45.0);
            event.add(EntityType.f_20495_, (Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get(), 25.0);
            event.add(EntityType.f_20495_, (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -35.0);
            event.add(EntityType.f_20566_, (Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get(), 15.0);
            event.add(EntityType.f_20566_, (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -15.0);
            event.add(EntityType.f_20521_, (Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get(), 15.0);
            event.add(EntityType.f_20521_, (Attribute)AttributeReg.NIHILITY_RESISTANCE.get(), -35.0);
            event.add(EntityType.f_217014_, (Attribute)AttributeReg.ELEMENTAL_RESISTANCE.get(), 15.0);
        }

        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput packOutput = generator.getPackOutput();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            generator.addProvider(event.includeServer(), (DataProvider)LootTableGen.create(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new RecipeGen(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGen(packOutput, existingFileHelper));
        }
    }
}

