/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.color;

import com.idark.valoria.registries.BlockRegistry;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ModBlockColors
implements BlockColor {
    private static final ModBlockColors INSTANCE = new ModBlockColors();
    public static final Block[] MODDED_GRASS = new Block[]{(Block)BlockRegistry.cattail.get(), (Block)BlockRegistry.voidTaint.get(), (Block)BlockRegistry.voidGrass.get(), (Block)BlockRegistry.voidSerpents.get(), (Block)BlockRegistry.voidRoots.get(), (Block)BlockRegistry.soulFlower.get(), (Block)BlockRegistry.falseFlower.get(), (Block)BlockRegistry.falseFlowerSmall.get()};
    public static final Block[] MODDED_FOLIAGE = new Block[]{(Block)BlockRegistry.eldritchLeaves.get(), (Block)BlockRegistry.eldritchSapling.get(), (Block)BlockRegistry.pottedEldritchSapling.get(), (Block)BlockRegistry.shadeLeaves.get(), (Block)BlockRegistry.shadeBranchVine.get(), (Block)BlockRegistry.shadeBranch.get(), (Block)BlockRegistry.shadeSapling.get(), (Block)BlockRegistry.pottedShadewoodSapling.get()};

    public static int brightenColor(int color, float factor) {
        int r = Math.min(255, (int)((float)(color >> 16 & 0xFF) * factor));
        int g = Math.min(255, (int)((float)(color >> 8 & 0xFF) * factor));
        int b = Math.min(255, (int)((float)(color & 0xFF) * factor));
        return r << 16 | g << 8 | b;
    }

    public static ModBlockColors getInstance() {
        return INSTANCE;
    }

    public int getAloeColor(BlockState pState, @Nullable BlockAndTintGetter pLevel, @Nullable BlockPos pPos, int pTintIndex) {
        return ModBlockColors.brightenColor(this.getGrassColor(pState, pLevel, pPos, pTintIndex), 1.125f);
    }

    public int getGrassColor(BlockState pState, @Nullable BlockAndTintGetter pLevel, @Nullable BlockPos pPos, int pTintIndex) {
        return pLevel != null && pPos != null ? BiomeColors.m_108793_((BlockAndTintGetter)pLevel, (BlockPos)pPos) : GrassColor.m_276205_();
    }

    public int getFoliageColor(BlockState pState, @Nullable BlockAndTintGetter pLevel, @Nullable BlockPos pPos, int pTintIndex) {
        return pLevel != null && pPos != null ? BiomeColors.m_108804_((BlockAndTintGetter)pLevel, (BlockPos)pPos) : FoliageColor.m_46113_();
    }

    public int m_92566_(BlockState blockState, @Nullable BlockAndTintGetter blockAndTintGetter, @Nullable BlockPos blockPos, int i) {
        return 0;
    }
}

