/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.model.entity;

import com.idark.valoria.client.model.animations.DevilAnimation;
import com.idark.valoria.client.model.entity.AbstractHierarchicalModel;
import com.idark.valoria.registries.entity.living.elemental.Devil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class DevilModel<T extends Devil>
extends AbstractHierarchicalModel<T>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public DevilModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.leftArm = root.m_171324_("left_arm");
        this.rightArm = root.m_171324_("right_arm");
        this.leftLeg = root.m_171324_("left_leg");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftWing = root.m_171324_("left_wing");
        this.rightWing = root.m_171324_("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.25f, -3.25f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(60, 27).m_171488_(-3.0f, 3.75f, -3.25f, 6.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-4.0f, -4.25f, -3.25f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)).m_171514_(0, 43).m_171488_(-7.0f, -9.25f, 0.75f, 14.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.75f, (float)-0.75f));
        PartDefinition Left_ear = partdefinition.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(16, 50).m_171488_(-1.5f, -0.5f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.5f, (float)-4.5f, (float)0.0f));
        PartDefinition Right_ear = partdefinition.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(22, 50).m_171488_(-1.5f, -0.5f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.5f, (float)-4.5f, (float)0.0f));
        PartDefinition Body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 11).m_171488_(-4.0f, -6.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(36, 27).m_171488_(-4.0f, -6.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition Left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(16, 59).m_171488_(0.0f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(30, 59).m_171488_(0.0f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)4.0f, (float)1.0f, (float)0.0f));
        PartDefinition Right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(44, 59).m_171488_(-3.0f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(58, 59).m_171488_(-3.0f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-4.0f, (float)1.0f, (float)0.0f));
        PartDefinition Left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(28, 43).m_171488_(-2.0f, 0.0132f, 0.0521f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 43).m_171488_(-2.0f, -0.3618f, 0.0521f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)-2.0f));
        PartDefinition Right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(56, 11).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition Left_wing = partdefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-8.0f, -5.5f, 2.0f, 18.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.9658f, (float)4.5f, (float)2.7844f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition Right_wing = partdefinition.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-10.0f, -5.5f, 2.0f, 18.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.8786f, (float)4.5f, (float)2.7806f, (float)0.0f, (float)0.0873f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.m_6973_(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        this.animateWalk(pLimbSwing, pLimbSwingAmount);
        this.m_267799_(DevilAnimation.WALK, pLimbSwing, pLimbSwingAmount, pEntity.m_6113_(), pAgeInTicks);
        this.animateIdle(((Devil)((Object)pEntity)).idleAnimationState, DevilAnimation.IDLE, pLimbSwingAmount, pAgeInTicks, 1.0f);
        this.m_233381_(((Devil)((Object)pEntity)).throwAnimationState, DevilAnimation.ATTACK_RANGE, pAgeInTicks);
        this.m_233381_(((Devil)((Object)pEntity)).magicAnimationState, DevilAnimation.ATTACK_MAGIC, pAgeInTicks);
        if (this.f_102608_ > 0.0f) {
            AnimationUtils.m_102091_((ModelPart)this.rightArm, (ModelPart)this.leftArm, pEntity, (float)(this.f_102608_ * 0.75f), (float)pAgeInTicks);
        }
    }

    private void animateWalk(float pLimbSwing, float pLimbSwingAmount) {
        float f = Math.min(0.5f, 3.0f * pLimbSwingAmount);
        float f1 = pLimbSwing * 0.8662f;
        this.leftWing.f_104204_ = -0.45f;
        this.rightWing.f_104204_ = 0.45f;
        this.leftWing.f_104204_ -= 0.35f * Mth.m_14089_((float)(f1 + (float)Math.PI)) * f;
        this.rightWing.f_104204_ += 0.35f * Mth.m_14089_((float)(f1 + (float)Math.PI)) * f;
        this.resetArmPoses();
    }

    private void resetArmPoses() {
        this.leftArm.f_104204_ = 0.0f;
        this.leftArm.f_104202_ = 0.0f;
        this.leftArm.f_104200_ = 4.0f;
        this.leftArm.f_104201_ = 0.0f;
        this.rightArm.f_104204_ = 0.0f;
        this.rightArm.f_104202_ = 0.0f;
        this.rightArm.f_104200_ = -4.0f;
        this.rightArm.f_104201_ = 0.0f;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    @Override
    public ModelPart getHead() {
        return this.head;
    }

    protected ModelPart getArm(HumanoidArm pSide) {
        return pSide == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public void m_6002_(HumanoidArm pSide, PoseStack pPoseStack) {
        this.getArm(pSide).m_104299_(pPoseStack);
    }
}

