/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.render.entity;

import com.idark.valoria.client.model.entity.WaterBubbleModel;
import com.idark.valoria.registries.entity.projectile.WaterBubble;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.client.ClientTick;

@OnlyIn(value=Dist.CLIENT)
public class WaterBubbleRenderer
extends EntityRenderer<WaterBubble> {
    private static final ResourceLocation LOCATION = new ResourceLocation("valoria", "textures/entity/water_bubble.png");
    private final WaterBubbleModel<WaterBubble> model = new WaterBubbleModel(WaterBubbleModel.createBodyLayer().m_171564_());

    public WaterBubbleRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(WaterBubble pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - pEntityYaw));
        pPoseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        pPoseStack.m_252880_(0.0f, -1.501f, 0.0f);
        double ticksUp = ((float)ClientTick.ticksInGame + pPartialTicks) * 4.0f;
        pPoseStack.m_252880_(0.0f, (float)(Math.sin(Math.toRadians(ticksUp %= 360.0)) * (double)0.12125f), 0.0f);
        float f = pEntity.getAnimationProgress(pPartialTicks);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(this.model.m_103119_(this.getTextureLocation(pEntity)));
        this.model.m_6839_(pEntity, f, 0.0f, pPartialTicks);
        this.model.setupAnim(pEntity, f, f, (float)pEntity.f_19797_ + f, pEntity.m_146908_(), pEntity.m_146909_());
        this.model.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(WaterBubble pEntity) {
        return LOCATION;
    }
}

