/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.menus;

import com.google.common.collect.Lists;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.MenuRegistry;
import com.idark.valoria.registries.item.recipe.TinkeringRecipe;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.client.render.gui.screen.ContainerMenuBase;

public class TinkererMenu
extends ContainerMenuBase {
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final ContainerLevelAccess access;
    private final Level level;
    private TinkeringRecipe currentRecipe;
    private List<TinkeringRecipe> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.f_41583_;
    long lastSoundTime;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            TinkererMenu.this.m_6199_((Container)this);
            TinkererMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public TinkererMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public TinkererMenu(int windowId, Inventory playerInventory, final ContainerLevelAccess pAccess) {
        super((MenuType)MenuRegistry.TINKERING_MENU.get(), windowId);
        this.level = playerInventory.f_35978_.m_9236_();
        this.access = pAccess;
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack p_40362_) {
                return false;
            }

            public void m_142406_(Player p_150672_, ItemStack p_150673_) {
                p_150673_.m_41678_(p_150672_.m_9236_(), p_150672_, p_150673_.m_41613_());
                TinkererMenu.this.resultContainer.m_58395_(p_150672_, this.getRelevantItems());
                ItemStack itemstack = TinkererMenu.this.inputSlot.m_6201_(TinkererMenu.this.currentRecipe.getIngredientCount());
                if (!itemstack.m_41619_()) {
                    TinkererMenu.this.setupResultSlot();
                }
                pAccess.m_39292_((p_40364_, p_40365_) -> {
                    long l = p_40364_.m_46467_();
                    if (TinkererMenu.this.lastSoundTime != l) {
                        p_40364_.m_5594_(null, p_40365_, SoundEvents.f_12493_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        TinkererMenu.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(p_150672_, p_150673_);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(TinkererMenu.this.inputSlot.m_7993_());
            }
        });
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.layoutPlayerInventorySlots(8, 84);
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    @Nullable
    public TinkeringRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void m_6199_(Container pInventory) {
        ItemStack itemstack = this.inputSlot.m_7993_();
        if (!itemstack.m_150930_(this.input.m_41720_())) {
            this.input = itemstack.m_41777_();
            this.setupRecipeList(pInventory, itemstack);
        }
        this.setupResultSlot();
        this.m_38946_();
    }

    private void setupRecipeList(Container pContainer, ItemStack pStack) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!pStack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_((RecipeType)TinkeringRecipe.Type.INSTANCE, pContainer, this.level);
        }
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.selectedRecipeIndex.m_6422_(pId);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.recipes.size();
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            this.currentRecipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack itemstack = this.currentRecipe.m_5874_(this.container, this.level.m_9598_());
            if (itemstack.m_246617_(this.level.m_246046_())) {
                this.resultContainer.m_6029_((Recipe)this.currentRecipe);
                this.resultSlot.m_5852_(itemstack);
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public void registerUpdateListener(Runnable pListener) {
        this.slotUpdateListener = pListener;
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.resultContainer && super.m_5882_(pStack, pSlot);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            itemstack = itemstack1.m_41777_();
            if (pIndex == 1) {
                item.m_7836_(itemstack1, pPlayer.m_9236_(), pPlayer);
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex == 0 ? !this.m_38903_(itemstack1, 2, 38, false) : (this.level.m_7465_().m_44015_((RecipeType)TinkeringRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{itemstack1}), this.level).isPresent() ? !this.m_38903_(itemstack1, 0, 1, false) : (pIndex >= 2 && pIndex < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : pIndex >= 29 && pIndex < 38 && !this.m_38903_(itemstack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((p_40313_, p_40314_) -> this.m_150411_(pPlayer, this.container));
    }

    public List<TinkeringRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player playerIn) {
        return TinkererMenu.m_38889_((ContainerLevelAccess)this.access, (Player)playerIn, (Block)((Block)BlockRegistry.tinkererWorkbench.get()));
    }
}

