/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.screen.book;

import com.idark.valoria.client.ui.screen.book.Chapter;
import com.idark.valoria.client.ui.screen.book.Page;
import com.idark.valoria.client.ui.screen.book.codex.Codex;
import com.idark.valoria.client.ui.screen.book.codex.CodexEntries;
import com.idark.valoria.client.ui.screen.book.codex.checklist.BossPage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BookGui
extends Screen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("valoria", "textures/gui/book/codex.png");
    public ItemStack item;
    public static Chapter currentChapter;
    public static int currentPage;
    public boolean openedFromInv;
    public boolean initializedPages = false;

    public BookGui(Chapter chapter, boolean openedFromInv) {
        super((Component)Component.m_237115_((String)"codex.valoria.main"));
        currentChapter = chapter;
        currentPage = 0;
        this.openedFromInv = openedFromInv;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        Page left = currentChapter.getPage(currentPage);
        Page right = currentChapter.getPage(currentPage + 1);
        if (left != null) {
            left.mouseReleased(pMouseX, pMouseY, pButton);
        }
        if (right != null) {
            right.mouseReleased(pMouseX, pMouseY, pButton);
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        Page left = currentChapter.getPage(currentPage);
        Page right = currentChapter.getPage(currentPage + 1);
        if (left != null) {
            left.mouseScrolled(mouseX, mouseY, scroll);
        }
        if (right != null) {
            right.mouseScrolled(mouseX, mouseY, scroll);
        }
        if (currentChapter != CodexEntries.BOSS_CHECKLIST) {
            if (scroll > 0.0 && currentChapter.size() >= currentPage + 3) {
                currentPage += 2;
                Minecraft.m_91087_().f_91074_.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            if (scroll < 0.0) {
                if (this.shouldOpenChecklist()) {
                    return super.m_6050_(mouseX, mouseY, scroll);
                }
                if (currentPage <= 0) {
                    this.m_7379_();
                    return true;
                }
                currentPage -= 2;
                Minecraft.m_91087_().f_91074_.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    private boolean shouldOpenChecklist() {
        if (currentChapter.getPage(currentPage) instanceof BossPage) {
            this.changeChapter(CodexEntries.BOSS_CHECKLIST);
            return true;
        }
        return false;
    }

    public void m_7379_() {
        if (this.openedFromInv) {
            super.m_7379_();
        } else {
            Minecraft.m_91087_().m_91152_((Screen)Codex.getInstance());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawItemWithTooltip(ItemStack stack, int x, int y, GuiGraphics gui, int mouseX, int mouseY, boolean ShowTooltip) {
        gui.m_280480_(stack, x, y);
        if (ShowTooltip && !stack.m_41619_() && mouseX >= x && mouseY >= y && mouseX <= x + 16 && mouseY <= y + 16) {
            gui.m_280153_(Minecraft.m_91087_().f_91062_, stack, mouseX, mouseY);
        }
    }

    public void m_86600_() {
        Page left = currentChapter.getPage(currentPage);
        Page right = currentChapter.getPage(currentPage + 1);
        if (left != null) {
            left.tick();
        }
        if (right != null) {
            right.tick();
        }
        if (!this.initializedPages) {
            if (left != null) {
                left.init();
            }
            if (right != null) {
                right.init();
            }
            this.initializedPages = right != null || left != null;
        }
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        this.item = ItemStack.f_41583_;
        this.f_96543_ = mc.m_91268_().m_85445_();
        this.f_96544_ = mc.m_91268_().m_85446_();
        int guiLeft = (this.f_96543_ - 272) / 2;
        int guiTop = (this.f_96544_ - 180) / 2;
        gui.m_280163_(BACKGROUND, guiLeft, guiTop, 0.0f, 0.0f, 272, 180, 512, 512);
        Page left = currentChapter.getPage(currentPage);
        Page right = currentChapter.getPage(currentPage + 1);
        if (left != null) {
            left.fullRender(gui, guiLeft + 10, guiTop + 8, mouseX, mouseY);
        }
        if (right != null) {
            right.fullRender(gui, guiLeft + 142, guiTop + 8, mouseX, mouseY);
        }
        int backX = guiLeft - 20;
        int y = guiTop + 150;
        int nextX = guiLeft + 271;
        if (currentChapter.size() >= currentPage + 3) {
            gui.m_280163_(BACKGROUND, nextX, y, 288.0f, 96.0f, 21, 22, 512, 512);
            if (this.isHover(mouseX, mouseY, nextX, y, 21, 22)) {
                this.renderTooltip(gui, Component.m_237115_((String)"codex.valoria.next"), nextX - 20, y);
            }
        }
        gui.m_280163_(BACKGROUND, backX, y, 288.0f, 74.0f, 21, 22, 512, 512);
        if (this.isHover(mouseX, mouseY, backX, y, 21, 22)) {
            this.renderTooltip(gui, Component.m_237115_((String)"codex.valoria.back"), backX - 10, y);
        }
    }

    public boolean isHover(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    public void renderTooltip(GuiGraphics gui, MutableComponent component, int x, int y) {
        gui.m_280557_(Minecraft.m_91087_().f_91062_, (Component)component, x, y);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        boolean flag;
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = flag = currentChapter.size() >= currentPage + 3;
        if (pKeyCode == 266 || pKeyCode == 262) {
            this.nextPage(flag, mc);
        }
        if (pKeyCode == 267 || pKeyCode == 263) {
            if (this.shouldOpenChecklist()) {
                return super.m_7933_(pKeyCode, pScanCode, pModifiers);
            }
            if (currentPage > 0) {
                this.backPage(mc);
            } else {
                this.m_7379_();
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Minecraft mc = Minecraft.m_91087_();
        Page left = currentChapter.getPage(currentPage);
        Page right = currentChapter.getPage(currentPage + 1);
        if (left != null) {
            left.mouseClicked(mouseX, mouseY, button);
        }
        if (right != null) {
            right.mouseClicked(mouseX, mouseY, button);
        }
        if (button == 266) {
            this.nextPage(currentChapter.size() >= currentPage + 3, mc);
        }
        if (button == 0) {
            this.f_96543_ = mc.m_91268_().m_85445_();
            this.f_96544_ = mc.m_91268_().m_85446_();
            int guiLeft = (this.f_96543_ - 272) / 2;
            int guiTop = (this.f_96544_ - 180) / 2;
            int backX = guiLeft - 20;
            int y = guiTop + 150;
            int nextX = guiLeft + 271;
            if (currentChapter.size() >= currentPage + 3) {
                this.nextPage(this.isHover(mouseX, mouseY, nextX, y, 21, 22), mc);
            }
            if (this.isHover(mouseX, mouseY, backX, y, 21, 22)) {
                if (this.shouldOpenChecklist()) {
                    return false;
                }
                if (currentPage > 0) {
                    this.backPage(mc);
                } else {
                    mc.f_91074_.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    this.m_7379_();
                }
            }
        }
        return false;
    }

    public void changeChapter(Chapter chapter) {
        currentChapter = chapter;
        currentPage = 0;
    }

    public void nextPage(boolean currentChapter, Minecraft mc) {
        if (currentChapter) {
            mc.f_91074_.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            currentPage += 2;
        }
    }

    public void backPage(Minecraft mc) {
        mc.f_91074_.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        currentPage -= 2;
    }

    public boolean m_7043_() {
        return false;
    }

    static {
        currentPage = 0;
    }
}

