/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.screen.book.codex;

import com.idark.valoria.api.events.CodexEvent;
import com.idark.valoria.api.unlockable.types.Unlockable;
import com.idark.valoria.client.ui.screen.book.Chapter;
import com.idark.valoria.client.ui.screen.book.codex.ChapterNode;
import com.idark.valoria.client.ui.screen.book.codex.CodexEntry;
import com.idark.valoria.client.ui.screen.book.codex.Style;
import com.idark.valoria.client.ui.screen.book.codex.checklist.BossEntry;
import com.idark.valoria.client.ui.screen.book.codex.checklist.BossMainPage;
import com.idark.valoria.client.ui.screen.book.pages.PicturePage;
import com.idark.valoria.client.ui.screen.book.pages.TextPage;
import com.idark.valoria.client.ui.screen.book.unlockable.RegisterUnlockables;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import pro.komaru.tridot.api.render.text.DotStyleEffects;
import pro.komaru.tridot.client.gfx.text.DotStyle;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.struct.data.Seq;

public class CodexEntries {
    public static Seq<CodexEntry> entries = new Seq();
    public static Seq<BossEntry> bossEntries = new Seq();
    public static Chapter MAIN_CHAPTER;
    public static Chapter PAGES_CHAPTER;
    public static Chapter TREASURES_CHAPTER;
    public static Chapter MEDICINE_CHAPTER;
    public static Chapter BOSS_CHECKLIST;
    public static Chapter PICK;
    public static Chapter HEAVY_WORKBENCH;
    public static Chapter STONE_CRUSHER;
    public static Chapter VALORIA_PORTAL;
    public static Chapter BOSSES;
    public static Chapter UNDEAD;
    public static Chapter KING_CRAB;
    public static Chapter NECROMANCER_GRIMOIRE;
    public static Chapter NECROMANCER;
    public static Chapter SUSPICIOUS_GEM;
    public static Chapter WICKED_CRYSTAL;
    public static Chapter CRYPT;
    public static Chapter FORTRESS;
    public static Chapter ELEMENTALS;
    public static Chapter HARMONY_ELEMENTALS;
    public static Chapter ELEMENTAL_EMPERORS;
    public static Chapter HARMONY_EMPEROR;
    public static Chapter HARMONY_CROWN;
    public static Chapter DRYADOR;
    public static Chapter BLACK_GOLD;
    public static Chapter NATURE_CORE;
    public static Chapter AQUARIUS_CORE;
    public static Chapter INFERNAL_CORE;
    public static Chapter VOID_CORE;
    static int spacingX;
    static int spacingY;

    public static void initChapters() {
        MAIN_CHAPTER = new Chapter("codex.valoria.main.name", new TextPage("codex.valoria.main"), new TextPage("codex.valoria.main.continuation").hideTitle());
        BOSS_CHECKLIST = new Chapter("codex.valoria.bosses.name", new BossMainPage("codex.valoria.bosses.name", bossEntries));
        PAGES_CHAPTER = new Chapter("codex.valoria.pages.name", new TextPage("codex.valoria.pages"));
        TREASURES_CHAPTER = new Chapter("codex.valoria.jewelry", new TextPage("codex.valoria.treasures"), new TextPage("codex.valoria.treasure.gems"), new TextPage("codex.valoria.treasure.gems.about").withCustomTitle("codex.valoria.treasure.gems.name"));
        MEDICINE_CHAPTER = new Chapter("codex.valoria.medicine.name", new TextPage("codex.valoria.medicine"));
        VALORIA_PORTAL = new Chapter("codex.valoria.valoria_portal.name", new PicturePage("codex.valoria.valoria_portal", new ResourceLocation("valoria", "textures/gui/book/valoria_portal.png"), 127, 15));
        PICK = new Chapter("codex.valoria.pick.name", new TextPage("codex.valoria.pick"));
        STONE_CRUSHER = new Chapter("codex.valoria.stone_crusher", new TextPage("codex.valoria.stone_crusher.description").withCustomTitle("codex.valoria.stone_crusher").withCraftEntry(((Block)BlockRegistry.stoneCrusher.get()).m_5456_().m_7968_()));
        HEAVY_WORKBENCH = new Chapter("codex.valoria.heavy_workbench.name", new TextPage("codex.valoria.heavy_workbench"));
        KING_CRAB = new Chapter("codex.valoria.king_crab.name", new TextPage("codex.valoria.king_crab").withEntity((EntityType<? extends LivingEntity>)((EntityType)EntityTypeRegistry.KING_CRAB.get())).setEntityData(191, 60, 32));
        BOSSES = new Chapter("codex.valoria.bosses.name", new TextPage("codex.valoria.bosses"), new TextPage("codex.valoria.bosses_continuation").hideTitle());
        NECROMANCER_GRIMOIRE = new Chapter("codex.valoria.necromancer_grimoire.name", new TextPage("codex.valoria.necromancer_grimoire"), new TextPage("codex.valoria.necromancer_grimoire_continuation").hideTitle()).setUnknownKey("codex.valoria.necromancer.name");
        NECROMANCER = new Chapter("codex.valoria.necromancer.name", new TextPage("codex.valoria.necromancer"), new TextPage("codex.valoria.necromancer_continuation").hideTitle());
        HARMONY_CROWN = new Chapter("codex.valoria.harmony_crown.name", new TextPage("codex.valoria.harmony_crown"), new TextPage("codex.valoria.harmony_crown.continuation").hideTitle()).setUnknownKey("codex.valoria.dryador.name");
        HARMONY_EMPEROR = new Chapter("codex.valoria.harmony_emperor.name", new TextPage("codex.valoria.harmony_emperor"));
        DRYADOR = new Chapter("codex.valoria.dryador.name", new TextPage("codex.valoria.dryador").hideTitle());
        SUSPICIOUS_GEM = new Chapter("codex.valoria.suspicious_gem.name", new TextPage("codex.valoria.suspicious_gem"), new TextPage("codex.valoria.suspicious_gem_continuation").hideTitle()).setUnknownKey("codex.valoria.wicked_crystal.name");
        WICKED_CRYSTAL = new Chapter("codex.valoria.wicked_crystal.name", new TextPage("codex.valoria.wicked_crystal"), new TextPage("codex.valoria.wicked_crystal_continuation").hideTitle());
        UNDEAD = new Chapter("codex.valoria.undead.name", new TextPage("codex.valoria.undead"));
        ELEMENTALS = new Chapter("codex.valoria.elementals.name", new TextPage("codex.valoria.elementals").hideTitle(), new TextPage("codex.valoria.elementals.continuation").hideTitle());
        HARMONY_ELEMENTALS = new Chapter("codex.valoria.harmony_elementals.name", new TextPage("codex.valoria.harmony_elementals").hideTitle(), new TextPage("codex.valoria.harmony_elementals.continuation").hideTitle());
        ELEMENTAL_EMPERORS = new Chapter("codex.valoria.elemental_emperors.name", new TextPage("codex.valoria.elemental_emperors").hideTitle(), new TextPage("codex.valoria.elemental_emperors.continuation").hideTitle());
        BLACK_GOLD = new Chapter("codex.valoria.black_gold.name", new TextPage("codex.valoria.black_gold"));
        NATURE_CORE = new Chapter("codex.valoria.nature_core.name", new TextPage("codex.valoria.nature_core"));
        AQUARIUS_CORE = new Chapter("codex.valoria.aquarius_core.name", new TextPage("codex.valoria.aquarius_core"));
        INFERNAL_CORE = new Chapter("codex.valoria.infernal_core.name", new TextPage("codex.valoria.infernal_core"));
        VOID_CORE = new Chapter("codex.valoria.void_core.name", new TextPage("codex.valoria.void_core"));
        CRYPT = new Chapter("codex.valoria.crypt.name", new TextPage("codex.valoria.crypt"), new PicturePage("codex.valoria.crypt_continuation", new ResourceLocation("valoria", "textures/gui/book/crypt.png"), -5, 40).hideTitle());
        FORTRESS = new Chapter("codex.valoria.fortress.name", new TextPage("codex.valoria.fortress"), new TextPage("codex.valoria.fortress_continuation").hideTitle());
    }

    @Nullable
    public static ChapterNode getNode(Unlockable unlockable) {
        CodexEntries.init();
        for (CodexEntry entry : entries) {
            if (entry.node.unlockable != unlockable) continue;
            return entry.node;
        }
        return null;
    }

    public static void init() {
        entries.clear();
        ChapterNode root = new ChapterNode(PAGES_CHAPTER, (Item)ItemsRegistry.page.get(), Style.GOLD).addChild(TREASURES_CHAPTER, ItemsRegistry.amethystGem).addChild(MEDICINE_CHAPTER, ItemsRegistry.aloeBandage).addChild(new ChapterNode(MAIN_CHAPTER, (Item)ItemsRegistry.codex.get(), Style.GOLD).addChild(new ChapterNode(STONE_CRUSHER, ((Block)BlockRegistry.stoneCrusher.get()).m_5456_()).addChild(new ChapterNode(HEAVY_WORKBENCH, ((Block)BlockRegistry.heavyWorkbench.get()).m_5456_(), Style.STANDARD, RegisterUnlockables.heavyWorkbench).addHintsDescription(Component.m_237115_((String)"codex.valoria.heavy_workbench.hint").m_130948_((net.minecraft.network.chat.Style)DotStyle.of().color(Col.gray).effect((DotStyle.StyleEffect)DotStyleEffects.PulseAlphaFX.of((float)1.0f)))).addChild(new ChapterNode(PICK, (Item)ItemsRegistry.pick.get(), Style.STANDARD, RegisterUnlockables.pick)))).addChild(new ChapterNode(ELEMENTALS, (Item)ItemsRegistry.elementalCrystal.get(), Style.GOLD).addChild(new ChapterNode(BLACK_GOLD, (Item)ItemsRegistry.blackGold.get(), Style.IRON, RegisterUnlockables.blackGold).addHintsDescription(Component.m_237115_((String)"codex.valoria.black_gold.hint").m_130948_((net.minecraft.network.chat.Style)DotStyle.of().color(Col.gray).effect((DotStyle.StyleEffect)DotStyleEffects.PulseAlphaFX.of((float)1.0f)))).addChild(new ChapterNode(NATURE_CORE, (Item)ItemsRegistry.natureCore.get(), Style.GOLD, RegisterUnlockables.natureCore)).addChild(new ChapterNode(AQUARIUS_CORE, (Item)ItemsRegistry.aquariusCore.get(), Style.GOLD, RegisterUnlockables.aquariusCore)).addChild(new ChapterNode(INFERNAL_CORE, (Item)ItemsRegistry.infernalCore.get(), Style.GOLD, RegisterUnlockables.infernalCore)).addChild(new ChapterNode(VOID_CORE, (Item)ItemsRegistry.voidCore.get(), Style.GOLD, RegisterUnlockables.voidCore))).addChild(new ChapterNode(KING_CRAB, (Item)ItemsRegistry.crabClaw.get(), RegisterUnlockables.kingCrab)).addChild(new ChapterNode(HARMONY_ELEMENTALS, (Item)ItemsRegistry.harmonyHeart.get(), RegisterUnlockables.harmonyEntities).addHintsDescription(Component.m_237115_((String)"codex.valoria.harmony_elementals.hint").m_130948_((net.minecraft.network.chat.Style)DotStyle.of().color(Col.gray).effect((DotStyle.StyleEffect)DotStyleEffects.PulseAlphaFX.of((float)1.0f)))))).addChild(new ChapterNode(ELEMENTAL_EMPERORS, (Item)ItemsRegistry.harmonyCrown.get(), Style.GOLD).addChild(new ChapterNode(HARMONY_EMPEROR, Items.f_42678_))));
        ChapterNode bossesRoot = new ChapterNode(BOSSES, Items.f_42678_, Style.CRYPT).addChild(new ChapterNode(CRYPT, (Item)ItemsRegistry.cryptPage.get(), Style.CRYPT, RegisterUnlockables.crypt).addHintsDescription(Component.m_237115_((String)"codex.valoria.crypt.hint").m_130948_((net.minecraft.network.chat.Style)DotStyle.of().color(Col.gray).effect((DotStyle.StyleEffect)DotStyleEffects.PulseAlphaFX.of((float)1.0f)))).addChild(new ChapterNode(NECROMANCER_GRIMOIRE, (Item)ItemsRegistry.necromancerGrimoire.get(), Style.IRON, RegisterUnlockables.necromancerGrimoire).addHintsDescription(Component.m_237115_((String)"codex.valoria.necromancer_grimoire.hint").m_130948_((net.minecraft.network.chat.Style)DotStyle.of().color(Col.gray).effect((DotStyle.StyleEffect)DotStyleEffects.PulseAlphaFX.of((float)1.0f)))).addChild(new ChapterNode(UNDEAD, Items.f_42500_, Style.STANDARD, RegisterUnlockables.undead)).addChild(new ChapterNode(NECROMANCER, Items.f_42678_, Style.GOLD, RegisterUnlockables.necromancer)))).addChild(new ChapterNode(HARMONY_CROWN, (Item)ItemsRegistry.harmonyCrown.get(), Style.IRON, RegisterUnlockables.harmonyCrown).addHintsDescription(Component.m_237115_((String)"codex.valoria.harmony_crown.hint").m_130948_((net.minecraft.network.chat.Style)DotStyle.of().color(Col.gray).effect((DotStyle.StyleEffect)DotStyleEffects.PulseAlphaFX.of((float)1.0f)))).addChild(new ChapterNode(DRYADOR, Items.f_42678_, Style.GOLD, RegisterUnlockables.dryador))).addChild(new ChapterNode(VALORIA_PORTAL, ((Block)BlockRegistry.valoriaPortalFrame.get()).m_5456_(), Style.GOLD, RegisterUnlockables.valoriaPortal).addHintsDescription(Component.m_237115_((String)"codex.valoria.valoria_portal.hint").m_130948_((net.minecraft.network.chat.Style)DotStyle.of().color(Col.gray).effect((DotStyle.StyleEffect)DotStyleEffects.PulseAlphaFX.of((float)1.0f)))).addChild(new ChapterNode(FORTRESS, (Item)ItemsRegistry.wickedAmethyst.get(), Style.CRYPT, RegisterUnlockables.fortress).addHintsDescription(Component.m_237115_((String)"codex.valoria.fortress.hint").m_130948_((net.minecraft.network.chat.Style)DotStyle.of().color(Col.gray).effect((DotStyle.StyleEffect)DotStyleEffects.PulseAlphaFX.of((float)1.0f))))).addChild(new ChapterNode(SUSPICIOUS_GEM, (Item)ItemsRegistry.suspiciousGem.get(), Style.IRON, RegisterUnlockables.suspiciousGem).addHintsDescription(Component.m_237115_((String)"codex.valoria.suspicious_gem.hint").m_130948_((net.minecraft.network.chat.Style)DotStyle.of().color(Col.gray).effect((DotStyle.StyleEffect)DotStyleEffects.PulseAlphaFX.of((float)1.0f)))).addChild(new ChapterNode(WICKED_CRYSTAL, Items.f_42678_, Style.DIAMOND, RegisterUnlockables.wickedCrystal))));
        int offset = 0;
        if (CodexEntries.onInit(root)) {
            CodexEntries.layoutTree(root, 0, -512 + offset);
        }
        if (CodexEntries.onInit(bossesRoot)) {
            CodexEntries.layoutTree(bossesRoot, 5, offset);
        }
    }

    private static int measureWidth(ChapterNode node) {
        if (node.children.isEmpty()) {
            return spacingX;
        }
        int width = 0;
        for (ChapterNode child : node.children) {
            width += CodexEntries.measureWidth(child);
        }
        return Math.max(width, spacingX);
    }

    private static int layoutTree(ChapterNode node, int depth, int x) {
        int y = depth * -spacingY;
        if (node.children.isEmpty()) {
            int nodeWidth = CodexEntries.measureWidth(node);
            CodexEntries.placeEntry(node, x + nodeWidth / 2, y);
            return nodeWidth + spacingX;
        }
        int totalChildrenWidth = 0;
        int currentChildX = x;
        ArrayList<Integer> childNodeCenters = new ArrayList<Integer>();
        for (ChapterNode child : node.children) {
            int childSubtreeWidth = CodexEntries.layoutTree(child, depth + 1, currentChildX);
            currentChildX = x + (totalChildrenWidth += childSubtreeWidth);
            childNodeCenters.add(child.entry.x);
        }
        int centerX = ((Integer)Collections.min(childNodeCenters) + (Integer)Collections.max(childNodeCenters)) / 2;
        CodexEntries.placeEntry(node, centerX, y);
        int nodeWidth = CodexEntries.measureWidth(node);
        int childrenSpan = totalChildrenWidth - spacingX;
        return Math.max(childrenSpan, nodeWidth) + spacingX;
    }

    private static void placeEntry(ChapterNode node, int x, int y) {
        CodexEntry entry = CodexEntries.addEntry(node, x, y);
        if (!CodexEntries.onEntryAdded(entry)) {
            entries.add((Object)entry);
        } else {
            entry.hide();
        }
    }

    private static boolean onInit(ChapterNode root) {
        return !MinecraftForge.EVENT_BUS.post((Event)new CodexEvent.OnInit(root));
    }

    private static boolean onEntryAdded(CodexEntry entry) {
        return MinecraftForge.EVENT_BUS.post((Event)new CodexEvent.EntryAdded(entry));
    }

    private static CodexEntry addEntry(ChapterNode node, int x, int y) {
        return new CodexEntry(node, x, y);
    }

    static {
        spacingX = 25;
        spacingY = 35;
    }
}

