/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.screen.book.codex.checklist;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.ui.screen.book.BookGui;
import com.idark.valoria.client.ui.screen.book.Chapter;
import com.idark.valoria.client.ui.screen.book.codex.checklist.BossEntry;
import com.idark.valoria.client.ui.screen.book.codex.checklist.BossPage;
import com.idark.valoria.client.ui.screen.book.pages.TextPage;
import com.idark.valoria.util.Pal;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.phys.AbsRect;
import pro.komaru.tridot.util.struct.data.Seq;

public class BossMainPage
extends TextPage {
    Seq<BossEntry> entries;
    public int checkboxSize = 11;
    public int yMargin = 15;
    public int namespaceOffset = 11;
    public int insideWidth = 300;
    public int insideHeight = 128;
    public int guiX;
    public int guiY;
    public int checkboxX;
    public float scrollOffset = 0.0f;
    public final float scrollStep = 20.0f;
    private boolean isDraggingScrollbar = false;
    private double dragStartMouseY;
    private float dragStartScrollOffset;
    private int scrollbarX;
    private int scrollbarY;
    private int scrollbarHeight;

    public BossMainPage(String textKey, Seq<BossEntry> entrySeq) {
        super(textKey);
        this.title = "valoria.book.boss_checklist.title";
        this.entries = entrySeq;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void scissorsOn(GuiGraphics gui, PoseStack pose, int x, int y, int w, int h) {
        AbsRect r = AbsRect.xywhDef((float)x, (float)y, (float)w, (float)h).pose(pose);
        gui.m_280588_((int)r.x, (int)r.y, (int)r.x2, (int)r.y2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void scissorsOff(GuiGraphics gui) {
        gui.m_280618_();
    }

    @Override
    public void mouseScrolled(double mouseX, double mouseY, double delta) {
        this.scrollOffset -= (float)(delta * 20.0);
        float maxOffset = Math.max(0, this.entries.size * this.yMargin - this.insideHeight);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)maxOffset);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y, int mouseX, int mouseY) {
        this.guiX = x;
        this.guiY = y;
        this.renderScroll(gui, x, y, mouseY);
        int yOffset = 25 - (int)this.scrollOffset;
        this.renderEntries(gui, x, y, mouseX, mouseY, yOffset, this.yMargin);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderScroll(GuiGraphics gui, int x, int y, int mouseY) {
        int contentHeight = this.entries.size * this.yMargin;
        int maxOffset = Math.max(0, contentHeight - this.insideHeight);
        if (this.isDraggingScrollbar) {
            double dragDeltaY = (double)mouseY - this.dragStartMouseY;
            float scrollRatio = (float)maxOffset / (float)(this.insideHeight - this.scrollbarHeight);
            this.scrollOffset = Mth.m_14036_((float)(this.dragStartScrollOffset + (float)(dragDeltaY * (double)scrollRatio)), (float)0.0f, (float)maxOffset);
        }
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)maxOffset);
        this.scrollbarX = x + 112 + 11;
        int scrollBarYOffset = 10;
        if (contentHeight > this.insideHeight) {
            float ratio = (float)this.insideHeight / (float)contentHeight;
            this.scrollbarHeight = (int)(ratio * (float)this.insideHeight);
            this.scrollbarHeight = Math.max(20, this.scrollbarHeight);
            float scrollbarTrackHeight = this.insideHeight - this.scrollbarHeight;
            this.scrollbarY = y + (int)(this.scrollOffset / (float)maxOffset * scrollbarTrackHeight);
            gui.m_280509_(this.scrollbarX, scrollBarYOffset + y, this.scrollbarX + 4, scrollBarYOffset + y + this.insideHeight, Col.fromHex((String)"413838").a(0.35f).rgb());
            gui.m_280509_(this.scrollbarX, scrollBarYOffset + this.scrollbarY, this.scrollbarX + 4, scrollBarYOffset + this.scrollbarY + this.scrollbarHeight, Col.fromHex((String)"413838").brighter().a(0.345f).rgb());
        } else {
            this.scrollbarHeight = 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderEntries(GuiGraphics gui, int x, int y, int mouseX, int mouseY, int yOffset, int yMargin) {
        this.checkboxX = x + 5;
        this.entries.sort(Comparator.comparing(BossEntry::getCategory).thenComparing(e -> e.name(e.type()).getString()));
        this.scissorsOn(gui, gui.m_280168_(), x + this.insideWidth / 2, y + 75, this.insideWidth, this.insideHeight);
        int currentY = y + yOffset - 10;
        String lastCategory = null;
        for (BossEntry entry : this.entries) {
            if (!entry.getCategory().equals(lastCategory)) {
                gui.m_280056_(Minecraft.m_91087_().f_91062_, entry.getCategory().toUpperCase(), this.checkboxX, currentY, -1, true);
                currentY += this.namespaceOffset;
                lastCategory = entry.getCategory();
            }
            if (currentY + yMargin > y + 21 && currentY < y + 21 + this.insideHeight) {
                gui.m_280163_(Valoria.loc("textures/gui/book/frame.png"), this.checkboxX, currentY, entry.isUnlocked() ? 400.0f : 411.0f, 0.0f, this.checkboxSize, this.checkboxSize, 512, 512);
                if (this.isHover(mouseX, mouseY, this.checkboxX + 15, currentY, 100, 11)) {
                    EntityPos result = BossMainPage.getEntityPos(entry);
                    this.renderEntity(entry.isUnlocked(), gui, entry.type, x + result.entityDrawX(), y + result.entityDrawY(), (int)result.scale(), Minecraft.m_91087_(), 13);
                    gui.m_280557_(Minecraft.m_91087_().f_91062_, entry.name(entry.type()), mouseX, mouseY);
                    Font font = Minecraft.m_91087_().f_91062_;
                    Component component = entry.name(entry.type());
                    int n = currentY + this.checkboxSize / 2;
                    Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                    gui.m_280614_(font, component, this.checkboxX + 15, n - 9 / 2, Pal.ecru.copy().brighter().rgb(), true);
                } else {
                    Font font = Minecraft.m_91087_().f_91062_;
                    Component component = entry.name(entry.type());
                    int n = currentY + this.checkboxSize / 2;
                    Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                    gui.m_280614_(font, component, this.checkboxX + 15, n - 9 / 2, Pal.ecru.rgb(), true);
                }
            }
            currentY += yMargin;
        }
        this.scissorsOff(gui);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.scrollbarHeight > 0 && this.isHover(mouseX, mouseY, this.scrollbarX, this.guiY, 4, this.insideHeight)) {
                this.isDraggingScrollbar = true;
                this.dragStartMouseY = mouseY;
                this.dragStartScrollOffset = this.scrollOffset;
                if (!this.isHover(mouseX, mouseY, this.scrollbarX, this.scrollbarY, 4, this.scrollbarHeight)) {
                    float clickRatio = (float)(mouseY - (double)this.guiY) / (float)this.insideHeight;
                    int maxOffset = Math.max(0, this.entries.size * this.yMargin - this.insideHeight);
                    this.scrollOffset = Mth.m_14036_((float)(clickRatio * (float)maxOffset), (float)0.0f, (float)maxOffset);
                }
                return true;
            }
            int currentY = this.guiY + 21 - (int)this.scrollOffset - 10;
            this.entries.sort(Comparator.comparing(BossEntry::getCategory).thenComparing(e -> e.name(e.type()).getString()));
            String lastCategory = null;
            for (BossEntry entry : this.entries) {
                if (!entry.getCategory().equals(lastCategory)) {
                    currentY += this.namespaceOffset;
                    lastCategory = entry.getCategory();
                }
                if (currentY + this.yMargin > this.guiY && currentY < this.guiY + this.insideHeight) {
                    if (this.isHover(mouseX, mouseY, this.checkboxX, currentY, this.checkboxSize, this.checkboxSize)) {
                        entry.setUnlocked(!entry.isUnlocked());
                        return true;
                    }
                    if (this.isHover(mouseX, mouseY, this.checkboxX + 15, currentY, 100, 11)) {
                        Item item = Items.f_41852_;
                        if (entry.summonItem != null) {
                            item = entry.summonItem;
                        }
                        EntityPos result = BossMainPage.getEntityPos(entry);
                        this.changeChapter(new Chapter("", new BossPage(entry.description(entry.type).getString()).withCraftEntry(new ItemStack((ItemLike)item)).setEntityData(result.entityDrawX(), result.entityDrawY(), (int)result.scale(), entry.isUnlocked()).withEntity(entry.type).hideTitle()));
                    }
                }
                currentY += this.yMargin;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    private static EntityPos getEntityPos(BossEntry entry) {
        float height;
        float width = entry.type.m_20678_();
        float maxDimension = Math.max(width, height = entry.type.m_20679_());
        float scale = maxDimension > 0.0f ? 120.0f / maxDimension : 1.0f;
        int entityDrawX = 215 - (int)(width * scale / 2.0f);
        int entityDrawY = 60 + (int)(height * scale / 2.0f);
        return new EntityPos(scale, entityDrawX, entityDrawY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void changeChapter(Chapter chapter) {
        Minecraft.m_91087_().m_91152_((Screen)new BookGui(chapter, false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isHover(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDraggingScrollbar = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private record EntityPos(float scale, int entityDrawX, int entityDrawY) {
    }
}

